/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.collector.Trace;
import org.glowroot.common.ChunkSource;
import org.glowroot.local.ui.TraceCommonService;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;

@ParametersAreNonnullByDefault
@Immutable
final class TraceExport
extends TraceCommonService.TraceExportBase {
    private final Trace trace;
    private final String traceJson;
    @Nullable
    private final ChunkSource entries;
    @Nullable
    private final ChunkSource profile;

    private TraceExport(Builder builder) {
        this.trace = builder.trace;
        this.traceJson = builder.traceJson;
        this.entries = builder.entries;
        this.profile = builder.profile;
    }

    private TraceExport(TraceExport original, Trace trace, String traceJson, @Nullable ChunkSource entries, @Nullable ChunkSource profile) {
        this.trace = trace;
        this.traceJson = traceJson;
        this.entries = entries;
        this.profile = profile;
    }

    @Override
    public Trace trace() {
        return this.trace;
    }

    @Override
    public String traceJson() {
        return this.traceJson;
    }

    @Override
    @Nullable
    public ChunkSource entries() {
        return this.entries;
    }

    @Override
    @Nullable
    public ChunkSource profile() {
        return this.profile;
    }

    public final TraceExport withTrace(Trace value) {
        if (this.trace == value) {
            return this;
        }
        Trace newValue = Preconditions.checkNotNull(value);
        return new TraceExport(this, newValue, this.traceJson, this.entries, this.profile);
    }

    public final TraceExport withTraceJson(String value) {
        if (this.traceJson == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new TraceExport(this, this.trace, newValue, this.entries, this.profile);
    }

    public final TraceExport withEntries(@Nullable ChunkSource value) {
        if (this.entries == value) {
            return this;
        }
        ChunkSource newValue = value;
        return new TraceExport(this, this.trace, this.traceJson, newValue, this.profile);
    }

    public final TraceExport withProfile(@Nullable ChunkSource value) {
        if (this.profile == value) {
            return this;
        }
        ChunkSource newValue = value;
        return new TraceExport(this, this.trace, this.traceJson, this.entries, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof TraceExport && this.equalTo((TraceExport)another);
    }

    private boolean equalTo(TraceExport another) {
        return this.trace.equals(another.trace) && this.traceJson.equals(another.traceJson) && Objects.equal(this.entries, another.entries) && Objects.equal(this.profile, another.profile);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.trace.hashCode();
        h = h * 17 + this.traceJson.hashCode();
        h = h * 17 + Objects.hashCode(this.entries);
        h = h * 17 + Objects.hashCode(this.profile);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TraceExport").add("trace", this.trace).add("traceJson", this.traceJson).add("entries", this.entries).add("profile", this.profile).toString();
    }

    static TraceExport copyOf(TraceCommonService.TraceExportBase instance) {
        if (instance instanceof TraceExport) {
            return (TraceExport)instance;
        }
        return TraceExport.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_TRACE = 1L;
        private static final long INITIALIZED_BIT_TRACE_JSON = 2L;
        private long initializedBitset;
        @Nullable
        private Trace trace;
        @Nullable
        private String traceJson;
        @Nullable
        private ChunkSource entries;
        @Nullable
        private ChunkSource profile;

        private Builder() {
        }

        public final Builder from(TraceCommonService.TraceExportBase instance) {
            ChunkSource profileValue;
            Preconditions.checkNotNull(instance);
            this.trace(instance.trace());
            this.traceJson(instance.traceJson());
            ChunkSource entriesValue = instance.entries();
            if (entriesValue != null) {
                this.entries(entriesValue);
            }
            if ((profileValue = instance.profile()) != null) {
                this.profile(profileValue);
            }
            return this;
        }

        public final Builder trace(Trace trace) {
            this.trace = Preconditions.checkNotNull(trace);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder traceJson(String traceJson) {
            this.traceJson = Preconditions.checkNotNull(traceJson);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder entries(@Nullable ChunkSource entries) {
            this.entries = entries;
            return this;
        }

        public final Builder profile(@Nullable ChunkSource profile) {
            this.profile = profile;
            return this;
        }

        public TraceExport build() {
            this.checkRequiredAttributes();
            return new TraceExport(this);
        }

        private boolean traceIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean traceJsonIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.traceIsSet()) {
                attributes.add("trace");
            }
            if (!this.traceJsonIsSet()) {
                attributes.add("traceJson");
            }
            return "Cannot build TraceExport, some of required attributes are not set " + attributes;
        }
    }
}

