/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import org.glowroot.collector.Trace;
import org.glowroot.common.ObjectMappers;
import org.glowroot.local.ui.GET;
import org.glowroot.local.ui.JsonService;
import org.glowroot.local.ui.TraceCommonService;
import org.glowroot.shaded.fasterxml.jackson.databind.ObjectMapper;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;

@JsonService
class TraceJsonService {
    private static final Logger logger = LoggerFactory.getLogger(TraceJsonService.class);
    private static final ObjectMapper mapper = ObjectMappers.create();
    private final TraceCommonService traceCommonService;

    TraceJsonService(TraceCommonService traceCommonService) {
        this.traceCommonService = traceCommonService;
    }

    @GET(value="/backend/trace/header/(.+)")
    String getTrace(String id) throws Exception {
        Trace trace = this.traceCommonService.getTrace(id);
        if (trace == null) {
            logger.debug("no trace found for id: {}", (Object)id);
            return "{\"expired\":true}";
        }
        return mapper.writeValueAsString(trace);
    }
}

