/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.TransactionJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Doubles;
import org.glowroot.shaded.google.common.primitives.Longs;

@ParametersAreNonnullByDefault
@Immutable
final class TransactionProfileRequest
extends TransactionJsonService.TransactionProfileRequestBase {
    private final long from;
    private final long to;
    private final String transactionType;
    @Nullable
    private final String transactionName;
    private final double truncateLeafPercentage;

    private TransactionProfileRequest(Builder builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.transactionType = builder.transactionType;
        this.transactionName = builder.transactionName;
        this.truncateLeafPercentage = builder.truncateLeafPercentage;
    }

    private TransactionProfileRequest(TransactionProfileRequest original, long from, long to, String transactionType, @Nullable String transactionName, double truncateLeafPercentage) {
        this.from = from;
        this.to = to;
        this.transactionType = transactionType;
        this.transactionName = transactionName;
        this.truncateLeafPercentage = truncateLeafPercentage;
    }

    @Override
    @JsonProperty(value="from")
    public long from() {
        return this.from;
    }

    @Override
    @JsonProperty(value="to")
    public long to() {
        return this.to;
    }

    @Override
    @JsonProperty(value="transactionType")
    public String transactionType() {
        return this.transactionType;
    }

    @Override
    @Nullable
    @JsonProperty(value="transactionName")
    public String transactionName() {
        return this.transactionName;
    }

    @Override
    @JsonProperty(value="truncateLeafPercentage")
    public double truncateLeafPercentage() {
        return this.truncateLeafPercentage;
    }

    public final TransactionProfileRequest withFrom(long value) {
        if (this.from == value) {
            return this;
        }
        long newValue = value;
        return new TransactionProfileRequest(this, newValue, this.to, this.transactionType, this.transactionName, this.truncateLeafPercentage);
    }

    public final TransactionProfileRequest withTo(long value) {
        if (this.to == value) {
            return this;
        }
        long newValue = value;
        return new TransactionProfileRequest(this, this.from, newValue, this.transactionType, this.transactionName, this.truncateLeafPercentage);
    }

    public final TransactionProfileRequest withTransactionType(String value) {
        if (this.transactionType == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new TransactionProfileRequest(this, this.from, this.to, newValue, this.transactionName, this.truncateLeafPercentage);
    }

    public final TransactionProfileRequest withTransactionName(@Nullable String value) {
        if (this.transactionName == value) {
            return this;
        }
        String newValue = value;
        return new TransactionProfileRequest(this, this.from, this.to, this.transactionType, newValue, this.truncateLeafPercentage);
    }

    public final TransactionProfileRequest withTruncateLeafPercentage(double value) {
        double newValue = value;
        return new TransactionProfileRequest(this, this.from, this.to, this.transactionType, this.transactionName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof TransactionProfileRequest && this.equalTo((TransactionProfileRequest)another);
    }

    private boolean equalTo(TransactionProfileRequest another) {
        return this.from == another.from && this.to == another.to && this.transactionType.equals(another.transactionType) && Objects.equal(this.transactionName, another.transactionName) && Double.doubleToLongBits(this.truncateLeafPercentage) == Double.doubleToLongBits(another.truncateLeafPercentage);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Longs.hashCode(this.from);
        h = h * 17 + Longs.hashCode(this.to);
        h = h * 17 + this.transactionType.hashCode();
        h = h * 17 + Objects.hashCode(this.transactionName);
        h = h * 17 + Doubles.hashCode(this.truncateLeafPercentage);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TransactionProfileRequest").add("from", this.from).add("to", this.to).add("transactionType", this.transactionType).add("transactionName", this.transactionName).add("truncateLeafPercentage", this.truncateLeafPercentage).toString();
    }

    @JsonCreator
    public static TransactionProfileRequest fromAllAttributes(@JsonProperty(value="from") @Nullable Long from, @JsonProperty(value="to") @Nullable Long to, @JsonProperty(value="transactionType") @Nullable String transactionType, @JsonProperty(value="transactionName") @Nullable String transactionName, @JsonProperty(value="truncateLeafPercentage") @Nullable Double truncateLeafPercentage) {
        Builder builder = TransactionProfileRequest.builder();
        if (from != null) {
            builder.from(from);
        }
        if (to != null) {
            builder.to(to);
        }
        if (transactionType != null) {
            builder.transactionType(transactionType);
        }
        if (transactionName != null) {
            builder.transactionName(transactionName);
        }
        if (truncateLeafPercentage != null) {
            builder.truncateLeafPercentage(truncateLeafPercentage);
        }
        return builder.build();
    }

    static TransactionProfileRequest copyOf(TransactionJsonService.TransactionProfileRequestBase instance) {
        if (instance instanceof TransactionProfileRequest) {
            return (TransactionProfileRequest)instance;
        }
        return TransactionProfileRequest.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 15L;
        private static final long INITIALIZED_BIT_FROM = 1L;
        private static final long INITIALIZED_BIT_TO = 2L;
        private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 4L;
        private static final long INITIALIZED_BIT_TRUNCATE_LEAF_PERCENTAGE = 8L;
        private long initializedBitset;
        private long from;
        private long to;
        @Nullable
        private String transactionType;
        @Nullable
        private String transactionName;
        private double truncateLeafPercentage;

        private Builder() {
        }

        public final Builder from(TransactionJsonService.TransactionProfileRequestBase instance) {
            Preconditions.checkNotNull(instance);
            this.from(instance.from());
            this.to(instance.to());
            this.transactionType(instance.transactionType());
            String transactionNameValue = instance.transactionName();
            if (transactionNameValue != null) {
                this.transactionName(transactionNameValue);
            }
            this.truncateLeafPercentage(instance.truncateLeafPercentage());
            return this;
        }

        public final Builder from(long from) {
            this.from = from;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder to(long to) {
            this.to = to;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder transactionType(String transactionType) {
            this.transactionType = Preconditions.checkNotNull(transactionType);
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder transactionName(@Nullable String transactionName) {
            this.transactionName = transactionName;
            return this;
        }

        public final Builder truncateLeafPercentage(double truncateLeafPercentage) {
            this.truncateLeafPercentage = truncateLeafPercentage;
            this.initializedBitset |= 8L;
            return this;
        }

        public TransactionProfileRequest build() {
            this.checkRequiredAttributes();
            return new TransactionProfileRequest(this);
        }

        private boolean fromIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean toIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean transactionTypeIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean truncateLeafPercentageIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 15L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.fromIsSet()) {
                attributes.add("from");
            }
            if (!this.toIsSet()) {
                attributes.add("to");
            }
            if (!this.transactionTypeIsSet()) {
                attributes.add("transactionType");
            }
            if (!this.truncateLeafPercentageIsSet()) {
                attributes.add("truncateLeafPercentage");
            }
            return "Cannot build TransactionProfileRequest, some of required attributes are not set " + attributes;
        }
    }
}

