/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.local.ui;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.ui.ConfigJsonService;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;

@ParametersAreNonnullByDefault
@Immutable
final class UserRecordingConfigDto
extends ConfigJsonService.UserRecordingConfigDtoBase {
    private final boolean enabled;
    private final String user;
    private final int profileIntervalMillis;
    private final String version;

    private UserRecordingConfigDto(Builder builder) {
        this.enabled = builder.enabled;
        this.user = builder.user;
        this.profileIntervalMillis = builder.profileIntervalMillis;
        this.version = builder.version;
    }

    private UserRecordingConfigDto(UserRecordingConfigDto original, boolean enabled, String user, int profileIntervalMillis, String version) {
        this.enabled = enabled;
        this.user = user;
        this.profileIntervalMillis = profileIntervalMillis;
        this.version = version;
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="user")
    public String user() {
        return this.user;
    }

    @Override
    @JsonProperty(value="profileIntervalMillis")
    public int profileIntervalMillis() {
        return this.profileIntervalMillis;
    }

    @Override
    @JsonProperty(value="version")
    public String version() {
        return this.version;
    }

    public final UserRecordingConfigDto withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        boolean newValue = value;
        return new UserRecordingConfigDto(this, newValue, this.user, this.profileIntervalMillis, this.version);
    }

    public final UserRecordingConfigDto withUser(String value) {
        if (this.user == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new UserRecordingConfigDto(this, this.enabled, newValue, this.profileIntervalMillis, this.version);
    }

    public final UserRecordingConfigDto withProfileIntervalMillis(int value) {
        if (this.profileIntervalMillis == value) {
            return this;
        }
        int newValue = value;
        return new UserRecordingConfigDto(this, this.enabled, this.user, newValue, this.version);
    }

    public final UserRecordingConfigDto withVersion(String value) {
        if (this.version == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new UserRecordingConfigDto(this, this.enabled, this.user, this.profileIntervalMillis, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof UserRecordingConfigDto && this.equalTo((UserRecordingConfigDto)another);
    }

    private boolean equalTo(UserRecordingConfigDto another) {
        return this.enabled == another.enabled && this.user.equals(another.user) && this.profileIntervalMillis == another.profileIntervalMillis && this.version.equals(another.version);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Booleans.hashCode(this.enabled);
        h = h * 17 + this.user.hashCode();
        h = h * 17 + this.profileIntervalMillis;
        h = h * 17 + this.version.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("UserRecordingConfigDto").add("enabled", this.enabled).add("user", this.user).add("profileIntervalMillis", this.profileIntervalMillis).add("version", this.version).toString();
    }

    @JsonCreator
    public static UserRecordingConfigDto fromAllAttributes(@JsonProperty(value="enabled") @Nullable Boolean enabled, @JsonProperty(value="user") @Nullable String user, @JsonProperty(value="profileIntervalMillis") @Nullable Integer profileIntervalMillis, @JsonProperty(value="version") @Nullable String version) {
        Builder builder = UserRecordingConfigDto.builder();
        if (enabled != null) {
            builder.enabled(enabled);
        }
        if (user != null) {
            builder.user(user);
        }
        if (profileIntervalMillis != null) {
            builder.profileIntervalMillis(profileIntervalMillis);
        }
        if (version != null) {
            builder.version(version);
        }
        return builder.build();
    }

    static UserRecordingConfigDto copyOf(ConfigJsonService.UserRecordingConfigDtoBase instance) {
        if (instance instanceof UserRecordingConfigDto) {
            return (UserRecordingConfigDto)instance;
        }
        return UserRecordingConfigDto.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 15L;
        private static final long INITIALIZED_BIT_ENABLED = 1L;
        private static final long INITIALIZED_BIT_USER = 2L;
        private static final long INITIALIZED_BIT_PROFILE_INTERVAL_MILLIS = 4L;
        private static final long INITIALIZED_BIT_VERSION = 8L;
        private long initializedBitset;
        private boolean enabled;
        @Nullable
        private String user;
        private int profileIntervalMillis;
        @Nullable
        private String version;

        private Builder() {
        }

        public final Builder from(ConfigJsonService.UserRecordingConfigDtoBase instance) {
            Preconditions.checkNotNull(instance);
            this.enabled(instance.enabled());
            this.user(instance.user());
            this.profileIntervalMillis(instance.profileIntervalMillis());
            this.version(instance.version());
            return this;
        }

        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder user(String user) {
            this.user = Preconditions.checkNotNull(user);
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder profileIntervalMillis(int profileIntervalMillis) {
            this.profileIntervalMillis = profileIntervalMillis;
            this.initializedBitset |= 4L;
            return this;
        }

        public final Builder version(String version) {
            this.version = Preconditions.checkNotNull(version);
            this.initializedBitset |= 8L;
            return this;
        }

        public UserRecordingConfigDto build() {
            this.checkRequiredAttributes();
            return new UserRecordingConfigDto(this);
        }

        private boolean enabledIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean userIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean profileIntervalMillisIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private boolean versionIsSet() {
            return (this.initializedBitset & 8L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 15L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.enabledIsSet()) {
                attributes.add("enabled");
            }
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            if (!this.profileIntervalMillisIsSet()) {
                attributes.add("profileIntervalMillis");
            }
            if (!this.versionIsSet()) {
                attributes.add("version");
            }
            return "Cannot build UserRecordingConfigDto, some of required attributes are not set " + attributes;
        }
    }
}

