/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.fasterxml.jackson.databind.jsontype.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonTypeInfo;
import org.glowroot.shaded.fasterxml.jackson.core.JsonParser;
import org.glowroot.shaded.fasterxml.jackson.databind.BeanProperty;
import org.glowroot.shaded.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.shaded.fasterxml.jackson.databind.DeserializationFeature;
import org.glowroot.shaded.fasterxml.jackson.databind.JavaType;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.shaded.fasterxml.jackson.databind.deser.std.NullifyingDeserializer;
import org.glowroot.shaded.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import org.glowroot.shaded.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import org.glowroot.shaded.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import org.glowroot.shaded.fasterxml.jackson.databind.util.ClassUtil;

public abstract class TypeDeserializerBase
extends TypeDeserializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final TypeIdResolver _idResolver;
    protected final JavaType _baseType;
    protected final BeanProperty _property;
    protected final JavaType _defaultImpl;
    protected final String _typePropertyName;
    protected final boolean _typeIdVisible;
    protected final HashMap<String, JsonDeserializer<Object>> _deserializers;
    protected JsonDeserializer<Object> _defaultImplDeserializer;

    protected TypeDeserializerBase(JavaType baseType, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, Class<?> defaultImpl) {
        this._baseType = baseType;
        this._idResolver = idRes;
        this._typePropertyName = typePropertyName;
        this._typeIdVisible = typeIdVisible;
        this._deserializers = new HashMap();
        this._defaultImpl = defaultImpl == null ? null : baseType.forcedNarrowBy(defaultImpl);
        this._property = null;
    }

    protected TypeDeserializerBase(TypeDeserializerBase src, BeanProperty property) {
        this._baseType = src._baseType;
        this._idResolver = src._idResolver;
        this._typePropertyName = src._typePropertyName;
        this._typeIdVisible = src._typeIdVisible;
        this._deserializers = src._deserializers;
        this._defaultImpl = src._defaultImpl;
        this._defaultImplDeserializer = src._defaultImplDeserializer;
        this._property = property;
    }

    @Override
    public abstract TypeDeserializer forProperty(BeanProperty var1);

    @Override
    public abstract JsonTypeInfo.As getTypeInclusion();

    public String baseTypeName() {
        return this._baseType.getRawClass().getName();
    }

    @Override
    public final String getPropertyName() {
        return this._typePropertyName;
    }

    @Override
    public TypeIdResolver getTypeIdResolver() {
        return this._idResolver;
    }

    @Override
    public Class<?> getDefaultImpl() {
        return this._defaultImpl == null ? null : this._defaultImpl.getRawClass();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.getClass().getName());
        sb.append("; base-type:").append(this._baseType);
        sb.append("; id-resolver: ").append(this._idResolver);
        sb.append(']');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JsonDeserializer<Object> _findDeserializer(DeserializationContext ctxt, String typeId) throws IOException {
        JsonDeserializer<Object> deser;
        HashMap<String, JsonDeserializer<Object>> hashMap = this._deserializers;
        synchronized (hashMap) {
            deser = this._deserializers.get(typeId);
            if (deser == null) {
                JavaType type = this._idResolver.typeFromId(ctxt, typeId);
                if (type == null) {
                    deser = this._findDefaultImplDeserializer(ctxt);
                    if (deser == null) {
                        deser = this._handleUnknownTypeId(ctxt, typeId, this._idResolver, this._baseType);
                    }
                } else {
                    if (this._baseType != null && this._baseType.getClass() == type.getClass()) {
                        type = this._baseType.narrowBy(type.getRawClass());
                    }
                    deser = ctxt.findContextualValueDeserializer(type, this._property);
                }
                this._deserializers.put(typeId, deser);
            }
        }
        return deser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final JsonDeserializer<Object> _findDefaultImplDeserializer(DeserializationContext ctxt) throws IOException {
        if (this._defaultImpl == null) {
            if (!ctxt.isEnabled(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE)) {
                return NullifyingDeserializer.instance;
            }
            return null;
        }
        Class<?> raw = this._defaultImpl.getRawClass();
        if (ClassUtil.isBogusClass(raw)) {
            return NullifyingDeserializer.instance;
        }
        JavaType javaType = this._defaultImpl;
        synchronized (javaType) {
            if (this._defaultImplDeserializer == null) {
                this._defaultImplDeserializer = ctxt.findContextualValueDeserializer(this._defaultImpl, this._property);
            }
            return this._defaultImplDeserializer;
        }
    }

    @Deprecated
    protected Object _deserializeWithNativeTypeId(JsonParser jp, DeserializationContext ctxt) throws IOException {
        return this._deserializeWithNativeTypeId(jp, ctxt, jp.getTypeId());
    }

    protected Object _deserializeWithNativeTypeId(JsonParser jp, DeserializationContext ctxt, Object typeId) throws IOException {
        JsonDeserializer<Object> deser;
        if (typeId == null) {
            deser = this._findDefaultImplDeserializer(ctxt);
            if (deser == null) {
                throw ctxt.mappingException("No (native) type id found when one was expected for polymorphic type handling");
            }
        } else {
            String typeIdStr = typeId instanceof String ? (String)typeId : String.valueOf(typeId);
            deser = this._findDeserializer(ctxt, typeIdStr);
        }
        return deser.deserialize(jp, ctxt);
    }

    protected JsonDeserializer<Object> _handleUnknownTypeId(DeserializationContext ctxt, String typeId, TypeIdResolver idResolver, JavaType baseType) throws IOException {
        String extraDesc;
        extraDesc = idResolver instanceof TypeIdResolverBase ? ((extraDesc = ((TypeIdResolverBase)idResolver).getDescForKnownTypeIds()) == null ? "known type ids are not statically known" : "known type ids = " + extraDesc) : null;
        throw ctxt.unknownTypeException(this._baseType, typeId, extraDesc);
    }
}

