/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.bnf;

import java.util.HashMap;
import java.util.HashSet;
import org.glowroot.shaded.h2.bnf.context.DbSchema;
import org.glowroot.shaded.h2.bnf.context.DbTableOrView;
import org.glowroot.shaded.h2.util.New;
import org.glowroot.shaded.h2.util.StringUtils;

public class Sentence {
    public static final int CONTEXT = 0;
    public static final int KEYWORD = 1;
    public static final int FUNCTION = 2;
    private static final long MAX_PROCESSING_TIME = 100L;
    private final HashMap<String, String> next = New.hashMap();
    private String query;
    private String queryUpper;
    private long stopAt;
    private DbSchema lastMatchedSchema;
    private DbTableOrView lastMatchedTable;
    private DbTableOrView lastTable;
    private HashSet<DbTableOrView> tables;
    private HashMap<String, DbTableOrView> aliases;

    public void start() {
        this.stopAt = System.currentTimeMillis() + 100L;
    }

    public void stopIfRequired() {
        if (System.currentTimeMillis() > this.stopAt) {
            throw new IllegalStateException();
        }
    }

    public void add(String string, String string2, int n) {
        this.next.put(n + "#" + string, string2);
    }

    public void addAlias(String string, DbTableOrView dbTableOrView) {
        if (this.aliases == null) {
            this.aliases = New.hashMap();
        }
        this.aliases.put(string, dbTableOrView);
    }

    public void addTable(DbTableOrView dbTableOrView) {
        this.lastTable = dbTableOrView;
        if (this.tables == null) {
            this.tables = New.hashSet();
        }
        this.tables.add(dbTableOrView);
    }

    public HashSet<DbTableOrView> getTables() {
        return this.tables;
    }

    public HashMap<String, DbTableOrView> getAliases() {
        return this.aliases;
    }

    public DbTableOrView getLastTable() {
        return this.lastTable;
    }

    public DbSchema getLastMatchedSchema() {
        return this.lastMatchedSchema;
    }

    public void setLastMatchedSchema(DbSchema dbSchema) {
        this.lastMatchedSchema = dbSchema;
    }

    public void setLastMatchedTable(DbTableOrView dbTableOrView) {
        this.lastMatchedTable = dbTableOrView;
    }

    public DbTableOrView getLastMatchedTable() {
        return this.lastMatchedTable;
    }

    public void setQuery(String string) {
        if (!StringUtils.equals(this.query, string)) {
            this.query = string;
            this.queryUpper = StringUtils.toUpperEnglish(string);
        }
    }

    public String getQuery() {
        return this.query;
    }

    public String getQueryUpper() {
        return this.queryUpper;
    }

    public HashMap<String, String> getNext() {
        return this.next;
    }
}

