/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.command.ddl;

import org.glowroot.shaded.h2.command.ddl.SchemaCommand;
import org.glowroot.shaded.h2.engine.Database;
import org.glowroot.shaded.h2.engine.Session;
import org.glowroot.shaded.h2.expression.Expression;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.schema.Constant;
import org.glowroot.shaded.h2.schema.Schema;
import org.glowroot.shaded.h2.value.Value;

public class CreateConstant
extends SchemaCommand {
    private String constantName;
    private Expression expression;
    private boolean ifNotExists;

    public CreateConstant(Session session, Schema schema) {
        super(session, schema);
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        if (this.getSchema().findConstant(this.constantName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw DbException.get(90114, this.constantName);
        }
        int n = this.getObjectId();
        Constant constant = new Constant(this.getSchema(), n, this.constantName);
        this.expression = this.expression.optimize(this.session);
        Value value = this.expression.getValue(this.session);
        constant.setValue(value);
        database.addSchemaObject(this.session, constant);
        return 0;
    }

    public void setConstantName(String string) {
        this.constantName = string;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    @Override
    public int getType() {
        return 23;
    }
}

