/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.expression;

import org.glowroot.shaded.h2.command.dml.Query;
import org.glowroot.shaded.h2.engine.Database;
import org.glowroot.shaded.h2.engine.Session;
import org.glowroot.shaded.h2.expression.Comparison;
import org.glowroot.shaded.h2.expression.Condition;
import org.glowroot.shaded.h2.expression.Expression;
import org.glowroot.shaded.h2.expression.ExpressionColumn;
import org.glowroot.shaded.h2.expression.ExpressionVisitor;
import org.glowroot.shaded.h2.index.IndexCondition;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.result.LocalResult;
import org.glowroot.shaded.h2.table.ColumnResolver;
import org.glowroot.shaded.h2.table.TableFilter;
import org.glowroot.shaded.h2.util.StringUtils;
import org.glowroot.shaded.h2.value.Value;
import org.glowroot.shaded.h2.value.ValueBoolean;
import org.glowroot.shaded.h2.value.ValueNull;

public class ConditionInSelect
extends Condition {
    private final Database database;
    private Expression left;
    private final Query query;
    private final boolean all;
    private final int compareType;
    private int queryLevel;

    public ConditionInSelect(Database database, Expression expression, Query query, boolean bl, int n) {
        this.database = database;
        this.left = expression;
        this.query = query;
        this.all = bl;
        this.compareType = n;
    }

    @Override
    public Value getValue(Session session) {
        this.query.setSession(session);
        LocalResult localResult = this.query.query(0);
        session.addTemporaryResult(localResult);
        Value value = this.left.getValue(session);
        if (localResult.getRowCount() == 0) {
            return ValueBoolean.get(this.all);
        }
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        if (!session.getDatabase().getSettings().optimizeInSelect) {
            return this.getValueSlow(localResult, value);
        }
        if (this.all || this.compareType != 0 && this.compareType != 16) {
            return this.getValueSlow(localResult, value);
        }
        int n = localResult.getColumnType(0);
        if (n == 0) {
            return ValueBoolean.get(false);
        }
        if (localResult.containsDistinct(new Value[]{value = value.convertTo(n)})) {
            return ValueBoolean.get(true);
        }
        if (localResult.containsDistinct(new Value[]{ValueNull.INSTANCE})) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(false);
    }

    private Value getValueSlow(LocalResult localResult, Value value) {
        boolean bl = false;
        boolean bl2 = this.all;
        while (localResult.next()) {
            boolean bl3;
            Value value2 = localResult.currentRow()[0];
            if (value2 == ValueNull.INSTANCE) {
                bl3 = false;
                bl = true;
            } else {
                bl3 = Comparison.compareNotNull(this.database, value, value2, this.compareType);
            }
            if (!bl3 && this.all) {
                bl2 = false;
                break;
            }
            if (!bl3 || this.all) continue;
            bl2 = true;
            break;
        }
        if (!bl2 && bl) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl2);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n) {
        this.left.mapColumns(columnResolver, n);
        this.query.mapColumns(columnResolver, n + 1);
        this.queryLevel = Math.max(n, this.queryLevel);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        this.query.setRandomAccessResult(true);
        this.query.prepare();
        if (this.query.getColumnCount() != 1) {
            throw DbException.get(90052);
        }
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        this.query.setEvaluatable(tableFilter, bl);
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(').append(this.left.getSQL()).append(' ');
        if (this.all) {
            stringBuilder.append(Comparison.getCompareOperator(this.compareType)).append(" ALL");
        } else if (this.compareType == 0) {
            stringBuilder.append("IN");
        } else {
            stringBuilder.append(Comparison.getCompareOperator(this.compareType)).append(" ANY");
        }
        stringBuilder.append("(\n").append(StringUtils.indent(this.query.getPlanSQL(), 4, false)).append("))");
        return stringBuilder.toString();
    }

    @Override
    public void updateAggregate(Session session) {
        this.left.updateAggregate(session);
        this.query.updateAggregate(session);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.left.isEverything(expressionVisitor) && this.query.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.left.getCost() + this.query.getCostAsExpression();
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!session.getDatabase().getSettings().optimizeInList) {
            return;
        }
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        ExpressionVisitor expressionVisitor = ExpressionVisitor.getNotFromResolverVisitor(tableFilter);
        if (!this.query.isEverything(expressionVisitor)) {
            return;
        }
        tableFilter.addIndexCondition(IndexCondition.getInQuery(expressionColumn, this.query));
    }
}

