/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.mvstore;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.glowroot.shaded.h2.compress.CompressDeflate;
import org.glowroot.shaded.h2.compress.CompressLZF;
import org.glowroot.shaded.h2.compress.Compressor;
import org.glowroot.shaded.h2.mvstore.Chunk;
import org.glowroot.shaded.h2.mvstore.DataUtils;
import org.glowroot.shaded.h2.mvstore.FileStore;
import org.glowroot.shaded.h2.mvstore.MVMap;
import org.glowroot.shaded.h2.mvstore.MVMapConcurrent;
import org.glowroot.shaded.h2.mvstore.Page;
import org.glowroot.shaded.h2.mvstore.WriteBuffer;
import org.glowroot.shaded.h2.mvstore.cache.CacheLongKeyLIRS;
import org.glowroot.shaded.h2.mvstore.type.StringDataType;
import org.glowroot.shaded.h2.util.MathUtils;
import org.glowroot.shaded.h2.util.New;

public class MVStore {
    public static final boolean ASSERT = false;
    static final int BLOCK_SIZE = 4096;
    private static final int FORMAT_WRITE = 1;
    private static final int FORMAT_READ = 1;
    volatile BackgroundWriterThread backgroundWriterThread;
    private volatile boolean reuseSpace = true;
    private boolean closed;
    private FileStore fileStore;
    private final int pageSplitSize;
    private CacheLongKeyLIRS<Page> cache;
    private Chunk lastChunk;
    private final ConcurrentHashMap<Integer, Chunk> chunks = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, HashMap<Integer, Chunk>> freedPageSpace = new ConcurrentHashMap();
    private MVMapConcurrent<String, String> meta;
    private final ConcurrentHashMap<Integer, MVMap<?, ?>> maps = new ConcurrentHashMap();
    private HashMap<String, Object> fileHeader = New.hashMap();
    private WriteBuffer writeBuffer;
    private int lastMapId;
    private int versionsToKeep = 5;
    private final int compressionLevel;
    private Compressor compressorFast;
    private Compressor compressorHigh;
    private final Thread.UncaughtExceptionHandler backgroundExceptionHandler;
    private long currentVersion;
    private long lastStoredVersion;
    private int unsavedPageCount;
    private int autoCommitPageCount;
    private boolean saveNeeded;
    private long creationTime;
    private int retentionTime;
    private long lastCommitTime;
    private Chunk retainChunk;
    private volatile long currentStoreVersion = -1L;
    private Thread currentStoreThread;
    private volatile boolean metaChanged;
    private int autoCommitDelay;

    MVStore(HashMap<String, Object> hashMap) {
        int n;
        int n2;
        int n3;
        int n4;
        Object object = hashMap.get("compress");
        this.compressionLevel = object == null ? 0 : (Integer)object;
        String string = (String)hashMap.get("fileName");
        object = hashMap.get("pageSplitSize");
        this.pageSplitSize = object == null ? (string == null ? 4096 : 16384) : (Integer)object;
        object = hashMap.get("backgroundExceptionHandler");
        this.backgroundExceptionHandler = (Thread.UncaughtExceptionHandler)object;
        this.meta = new MVMapConcurrent(StringDataType.INSTANCE, StringDataType.INSTANCE);
        HashMap<String, Object> hashMap2 = New.hashMap();
        hashMap2.put("id", 0);
        hashMap2.put("createVersion", this.currentVersion);
        this.meta.init(this, hashMap2);
        this.fileStore = (FileStore)hashMap.get("fileStore");
        if (string == null && this.fileStore == null) {
            this.cache = null;
            return;
        }
        if (this.fileStore == null) {
            this.fileStore = new FileStore();
        }
        this.retentionTime = this.fileStore.getDefaultRetentionTime();
        boolean bl = hashMap.containsKey("readOnly");
        object = hashMap.get("cacheSize");
        int n5 = n4 = object == null ? 16 : (Integer)object;
        if (n4 > 0) {
            n3 = n4 * 1024 * 1024;
            n2 = Math.max(10, this.pageSplitSize / 2);
            n = 16;
            int n6 = n3 / n2 * 2 / 100;
            this.cache = new CacheLongKeyLIRS(n3, n2, n, n6);
        }
        n3 = (object = hashMap.get("autoCommitBufferSize")) == null ? 512 : (Integer)object;
        n2 = n3 * 1024 * 19;
        n = this.pageSplitSize;
        this.autoCommitPageCount = n2 / (n == 0 ? 1 : n);
        char[] cArray = (char[])hashMap.get("encryptionKey");
        try {
            this.fileStore.open(string, bl, cArray);
            if (this.fileStore.size() == 0L) {
                this.lastCommitTime = this.creationTime = this.getTime();
                this.fileHeader.put("H", 2);
                this.fileHeader.put("blockSize", 4096);
                this.fileHeader.put("format", 1);
                this.fileHeader.put("created", this.creationTime);
                this.writeFileHeader();
            } else {
                this.readFileHeader();
            }
        }
        catch (IllegalStateException illegalStateException) {
            try {
                this.closeStore(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw illegalStateException;
        }
        finally {
            if (cArray != null) {
                Arrays.fill(cArray, '\u0000');
            }
        }
        this.lastCommitTime = this.getTime();
        object = hashMap.get("autoCommitDelay");
        int n7 = object == null ? 1000 : (Integer)object;
        this.setAutoCommitDelay(n7);
    }

    public static MVStore open(String string) {
        HashMap<String, Object> hashMap = New.hashMap();
        hashMap.put("fileName", string);
        return new MVStore(hashMap);
    }

    <T extends MVMap<?, ?>> T openMapVersion(long l, int n, MVMap<?, ?> mVMap) {
        MVMap<String, String> mVMap2 = this.getMetaMap(l);
        long l2 = MVStore.getRootPos(mVMap2, n);
        MVMap<?, ?> mVMap3 = mVMap.openReadOnly();
        mVMap3.setRootPos(l2, l);
        return (T)mVMap3;
    }

    public <K, V> MVMap<K, V> openMap(String string) {
        return this.openMap(string, new MVMap.Builder());
    }

    public synchronized <M extends MVMap<K, V>, K, V> M openMap(String string, MVMap.MapBuilder<M, K, V> mapBuilder) {
        long l;
        M m;
        int n;
        this.checkOpen();
        String string2 = (String)this.meta.get("name." + string);
        if (string2 != null) {
            n = DataUtils.parseHexInt(string2);
            MVMap<?, ?> mVMap = this.maps.get(n);
            if (mVMap != null) {
                return (M)mVMap;
            }
            m = mapBuilder.create();
            String string3 = (String)this.meta.get("map." + string2);
            HashMap<String, Object> hashMap = New.hashMap();
            hashMap.putAll(DataUtils.parseMap(string3));
            hashMap.put("id", n);
            ((MVMap)m).init(this, hashMap);
            l = MVStore.getRootPos(this.meta, n);
        } else {
            HashMap<String, Object> hashMap = New.hashMap();
            n = ++this.lastMapId;
            hashMap.put("id", n);
            hashMap.put("createVersion", this.currentVersion);
            m = mapBuilder.create();
            ((MVMap)m).init(this, hashMap);
            this.markMetaChanged();
            string2 = Integer.toHexString(n);
            this.meta.put("map." + string2, ((MVMap)m).asString(string));
            this.meta.put("name." + string, string2);
            l = 0L;
        }
        ((MVMap)m).setRootPos(l, -1L);
        this.maps.put(n, (MVMap<?, ?>)m);
        return m;
    }

    public synchronized Set<String> getMapNames() {
        String string;
        HashSet<String> hashSet = New.hashSet();
        this.checkOpen();
        Iterator<String> iterator = this.meta.keyIterator("name.");
        while (iterator.hasNext() && (string = iterator.next()).startsWith("name.")) {
            hashSet.add(string.substring("name.".length()));
        }
        return hashSet;
    }

    public MVMap<String, String> getMetaMap() {
        this.checkOpen();
        return this.meta;
    }

    private MVMap<String, String> getMetaMap(long l) {
        Chunk chunk = this.getChunkForVersion(l);
        DataUtils.checkArgument(chunk != null, "Unknown version {0}", l);
        chunk = this.readChunkHeader(chunk.block);
        MVMap<String, String> mVMap = this.meta.openReadOnly();
        mVMap.setRootPos(chunk.metaRootPos, l);
        return mVMap;
    }

    private Chunk getChunkForVersion(long l) {
        Chunk chunk = this.lastChunk;
        while (chunk != null && chunk.version > l) {
            chunk = this.chunks.get(chunk.id - 1);
        }
        return chunk;
    }

    public boolean hasMap(String string) {
        return this.meta.containsKey("name." + string);
    }

    private void markMetaChanged() {
        this.metaChanged = true;
    }

    private synchronized void readFileHeader() {
        String string;
        Object object2;
        int n;
        boolean bl = false;
        long l = -1L;
        long l2 = -1L;
        ByteBuffer byteBuffer = this.fileStore.readFully(0L, 8192);
        byte[] byArray = new byte[4096];
        for (int i = 0; i <= 4096; i += 4096) {
            byteBuffer.get(byArray);
            try {
                long l3;
                String string2 = new String(byArray, 0, 4096, DataUtils.LATIN).trim();
                HashMap<String, String> hashMap = DataUtils.parseMap(string2);
                int n2 = DataUtils.readHexInt(hashMap, "blockSize", 4096);
                if (n2 != 4096) {
                    throw DataUtils.newIllegalStateException(5, "Block size {0} is currently not supported", n2);
                }
                n = DataUtils.readHexInt(hashMap, "fletcher", 0);
                hashMap.remove("fletcher");
                string2 = string2.substring(0, string2.lastIndexOf("fletcher") - 1);
                object2 = string2.getBytes(DataUtils.LATIN);
                int n3 = DataUtils.getFletcher32(object2, ((byte[])object2).length);
                if (n != n3 || (l3 = DataUtils.readHexLong(hashMap, "version", 0L)) <= l) continue;
                l = l3;
                this.fileHeader.putAll(hashMap);
                l2 = DataUtils.readHexLong(hashMap, "block", 0L);
                this.creationTime = DataUtils.readHexLong(hashMap, "created", 0L);
                bl = true;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            throw DataUtils.newIllegalStateException(6, "Store header is corrupt: {0}", this.fileStore);
        }
        long l4 = DataUtils.readHexLong(this.fileHeader, "format", 1L);
        if (l4 > 1L && !this.fileStore.isReadOnly()) {
            throw DataUtils.newIllegalStateException(5, "The write format {0} is larger than the supported format {1}, and the file was not opened in read-only mode", l4, 1);
        }
        if ((l4 = DataUtils.readHexLong(this.fileHeader, "formatRead", l4)) > 1L) {
            throw DataUtils.newIllegalStateException(5, "The read format {0} is larger than the supported format {1}", l4, 1);
        }
        this.lastStoredVersion = -1L;
        this.chunks.clear();
        long l5 = System.currentTimeMillis();
        n = 1970 + (int)(l5 / 31557600000L);
        if (n < 2014) {
            this.creationTime = l5 - (long)this.fileStore.getDefaultRetentionTime();
        } else if (l5 < this.creationTime) {
            this.creationTime = l5;
            this.fileHeader.put("created", this.creationTime);
        }
        object2 = this.readChunkFooter(this.fileStore.size());
        if (object2 != null && object2.version > l) {
            l = object2.version;
            l2 = object2.block;
        }
        if (l2 <= 0L) {
            return;
        }
        this.lastChunk = null;
        while (true) {
            Chunk chunk;
            try {
                chunk = this.readChunkHeader(l2);
            }
            catch (Exception exception) {
                break;
            }
            if (chunk.version < l || (object2 = (Object)this.readChunkFooter((l2 + (long)chunk.len) * 4096L)) == null || object2.id != chunk.id) break;
            this.lastChunk = chunk;
            l = chunk.version;
            if (chunk.next == 0L || chunk.next >= this.fileStore.size() / 4096L) break;
            l2 = chunk.next;
        }
        if (this.lastChunk == null) {
            return;
        }
        this.lastMapId = this.lastChunk.mapId;
        this.currentVersion = this.lastChunk.version;
        this.setWriteVersion(this.currentVersion);
        this.chunks.put(this.lastChunk.id, this.lastChunk);
        this.meta.setRootPos(this.lastChunk.metaRootPos, -1L);
        Iterator<Object> iterator = this.meta.keyIterator("chunk.");
        while (iterator.hasNext() && (string = iterator.next()).startsWith("chunk.")) {
            String string3 = (String)this.meta.get(string);
            Chunk chunk = Chunk.fromString(string3);
            if (this.chunks.containsKey(chunk.id)) continue;
            if (chunk.block == Long.MAX_VALUE) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} is invalid", chunk.id);
            }
            this.chunks.put(chunk.id, chunk);
        }
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.pageCountLive == 0) {
                this.registerFreePage(this.currentVersion, chunk.id, 0L, 0);
            }
            long l3 = chunk.block * 4096L;
            int n2 = chunk.len * 4096;
            this.fileStore.markUsed(l3, n2);
        }
    }

    private Chunk readChunkFooter(long l) {
        try {
            ByteBuffer byteBuffer = this.fileStore.readFully(l - 128L, 128);
            byte[] byArray = new byte[128];
            byteBuffer.get(byArray);
            String string = new String(byArray, DataUtils.LATIN).trim();
            HashMap<String, String> hashMap = DataUtils.parseMap(string);
            int n = DataUtils.readHexInt(hashMap, "fletcher", 0);
            hashMap.remove("fletcher");
            string = string.substring(0, string.lastIndexOf("fletcher") - 1);
            byte[] byArray2 = string.getBytes(DataUtils.LATIN);
            int n2 = DataUtils.getFletcher32(byArray2, byArray2.length);
            if (n == n2) {
                int n3 = DataUtils.readHexInt(hashMap, "chunk", 0);
                Chunk chunk = new Chunk(n3);
                chunk.version = DataUtils.readHexLong(hashMap, "version", 0L);
                chunk.block = DataUtils.readHexLong(hashMap, "block", 0L);
                return chunk;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void writeFileHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.lastChunk != null) {
            this.fileHeader.put("block", this.lastChunk.block);
            this.fileHeader.put("chunk", this.lastChunk.id);
            this.fileHeader.put("version", this.lastChunk.version);
        }
        DataUtils.appendMap(stringBuilder, this.fileHeader);
        byte[] byArray = stringBuilder.toString().getBytes(DataUtils.LATIN);
        int n = DataUtils.getFletcher32(byArray, byArray.length);
        DataUtils.appendMap(stringBuilder, "fletcher", n);
        stringBuilder.append("\n");
        byArray = stringBuilder.toString().getBytes(DataUtils.LATIN);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
        byteBuffer.put(byArray);
        byteBuffer.position(4096);
        byteBuffer.put(byArray);
        byteBuffer.rewind();
        this.write(0L, byteBuffer);
    }

    private void write(long l, ByteBuffer byteBuffer) {
        try {
            this.fileStore.writeFully(l, byteBuffer);
        }
        catch (IllegalStateException illegalStateException) {
            this.closeImmediately();
            throw illegalStateException;
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.fileStore != null && !this.fileStore.isReadOnly()) {
            this.stopBackgroundThread();
            if (this.hasUnsavedChanges()) {
                this.commitAndSave();
            }
        }
        this.closeStore(true);
    }

    public void closeImmediately() {
        block2: {
            try {
                this.closeStore(false);
            }
            catch (Exception exception) {
                if (this.backgroundExceptionHandler == null) break block2;
                this.backgroundExceptionHandler.uncaughtException(null, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStore(boolean bl) {
        if (this.closed) {
            return;
        }
        this.stopBackgroundThread();
        this.closed = true;
        if (this.fileStore == null) {
            return;
        }
        MVStore mVStore = this;
        synchronized (mVStore) {
            if (bl) {
                this.shrinkFileIfPossible(0);
            }
            this.cache = null;
            for (MVMap<?, ?> mVMap : New.arrayList(this.maps.values())) {
                mVMap.close();
            }
            this.meta = null;
            this.chunks.clear();
            this.maps.clear();
            try {
                this.fileStore.close();
            }
            finally {
                this.fileStore = null;
            }
        }
    }

    private Chunk getChunk(long l) {
        int n = DataUtils.getPageChunkId(l);
        Chunk chunk = this.chunks.get(n);
        if (chunk == null) {
            if (!Thread.holdsLock(this)) {
                throw DataUtils.newIllegalStateException(3, "Unsynchronized metadata read", new Object[0]);
            }
            String string = (String)this.meta.get(Chunk.getMetaKey(n));
            if (string == null) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} not found", n);
            }
            chunk = Chunk.fromString(string);
            if (chunk.block == Long.MAX_VALUE) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} is invalid", n);
            }
            this.chunks.put(chunk.id, chunk);
        }
        return chunk;
    }

    private void setWriteVersion(long l) {
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            mVMap.setWriteVersion(l);
        }
        this.meta.setWriteVersion(l);
    }

    public long commit() {
        if (this.fileStore != null) {
            return this.commitAndSave();
        }
        long l = ++this.currentVersion;
        this.setWriteVersion(l);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long commitAndSave() {
        if (this.closed) {
            return this.currentVersion;
        }
        if (this.fileStore == null) {
            throw DataUtils.newIllegalStateException(2, "This is an in-memory store", new Object[0]);
        }
        if (this.currentStoreVersion >= 0L) {
            return this.currentVersion;
        }
        if (!this.hasUnsavedChanges()) {
            return this.currentVersion;
        }
        if (this.fileStore.isReadOnly()) {
            throw DataUtils.newIllegalStateException(2, "This store is read-only", new Object[0]);
        }
        try {
            this.currentStoreVersion = this.currentVersion;
            this.currentStoreThread = Thread.currentThread();
            long l = this.storeNow();
            return l;
        }
        finally {
            this.currentStoreVersion = -1L;
            this.currentStoreThread = null;
        }
    }

    private long storeNow() {
        long l;
        long l2;
        Object object;
        int n;
        long l3;
        int n2 = this.unsavedPageCount;
        long l4 = this.currentStoreVersion;
        long l5 = ++this.currentVersion;
        this.setWriteVersion(l5);
        this.lastCommitTime = l3 = this.getTime();
        this.retainChunk = null;
        if (this.lastChunk == null) {
            n = 0;
        } else {
            n = this.lastChunk.id;
            this.meta.put(Chunk.getMetaKey(n), this.lastChunk.asString());
            l3 = Math.max(this.lastChunk.time, l3);
        }
        int n3 = n;
        while (this.chunks.containsKey(n3 = (n3 + 1) % 0x3FFFFFF)) {
        }
        Chunk chunk = new Chunk(n3);
        chunk.pageCount = Integer.MAX_VALUE;
        chunk.pageCountLive = Integer.MAX_VALUE;
        chunk.maxLen = Long.MAX_VALUE;
        chunk.maxLenLive = Long.MAX_VALUE;
        chunk.metaRootPos = Long.MAX_VALUE;
        chunk.block = Long.MAX_VALUE;
        chunk.len = Integer.MAX_VALUE;
        chunk.time = l3;
        chunk.version = l5;
        chunk.mapId = this.lastMapId;
        chunk.next = Long.MAX_VALUE;
        this.chunks.put(chunk.id, chunk);
        this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
        this.meta.remove(Chunk.getMetaKey(chunk.id));
        ArrayList<MVMap<?, ?>> arrayList = New.arrayList(this.maps.values());
        ArrayList arrayList2 = New.arrayList();
        for (MVMap<?, ?> object22 : arrayList) {
            object22.setWriteVersion(l5);
            long l6 = object22.getVersion();
            if (object22.getCreateVersion() > l4 || l6 < 0L || l6 < this.lastStoredVersion) continue;
            object22.waitUntilWritten(l4);
            MVMap mVMap = object22.openVersion(l4);
            if (mVMap.getRoot().getPos() != 0L) continue;
            arrayList2.add(mVMap);
        }
        for (MVMap<Object, Object> mVMap : arrayList2) {
            Page page = mVMap.getRoot();
            object = "root." + Long.toHexString(mVMap.getId());
            if (page.getTotalCount() == 0L) {
                this.meta.put((String)object, "0");
                continue;
            }
            this.meta.put((String)object, Long.toHexString(Long.MAX_VALUE));
        }
        Set<Chunk> set = this.applyFreedSpace(l4, l3);
        WriteBuffer writeBuffer = this.getWriteBuffer();
        chunk.writeChunkHeader(writeBuffer, 0);
        int n4 = writeBuffer.position();
        chunk.pageCount = 0;
        chunk.pageCountLive = 0;
        chunk.maxLen = 0L;
        chunk.maxLenLive = 0L;
        for (MVMap mVMap : arrayList2) {
            Page page = mVMap.getRoot();
            if (page.getTotalCount() <= 0L) continue;
            page.writeUnsavedRecursive(chunk, writeBuffer);
            l2 = page.getPos();
            String string = "root." + Long.toHexString(mVMap.getId());
            this.meta.put(string, Long.toHexString(l2));
        }
        this.meta.setWriteVersion(l5);
        object = this.meta.getRoot();
        ((Page)object).writeUnsavedRecursive(chunk, writeBuffer);
        int n5 = writeBuffer.position();
        int n6 = MathUtils.roundUpInt(n5 + 128, 4096);
        writeBuffer.limit(n6);
        l2 = this.getFileLengthInUse();
        long l7 = this.reuseSpace ? this.fileStore.allocate(n6) : l2;
        boolean bl = l7 + (long)n6 >= this.fileStore.size();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Chunk chunk2 = (Chunk)iterator.next();
            long l8 = chunk2.block * 4096L;
            int n7 = chunk2.len * 4096;
            this.fileStore.free(l8, n7);
        }
        if (!this.reuseSpace) {
            this.fileStore.markUsed(l2, n6);
        }
        chunk.block = l7 / 4096L;
        chunk.len = n6 / 4096;
        chunk.metaRootPos = ((Page)object).getPos();
        if (this.reuseSpace) {
            int n8 = chunk.len;
            l = this.fileStore.allocate(n8 * 4096);
            this.fileStore.free(l, n8 * 4096);
            chunk.next = l / 4096L;
        } else {
            chunk.next = 0L;
        }
        writeBuffer.position(0);
        chunk.writeChunkHeader(writeBuffer, n4);
        this.revertTemp(l4);
        writeBuffer.position(writeBuffer.limit() - 128);
        writeBuffer.put(chunk.getFooterBytes());
        writeBuffer.position(0);
        this.write(l7, writeBuffer.getBuffer());
        this.releaseWriteBuffer(writeBuffer);
        boolean bl2 = false;
        if (!bl) {
            if (this.lastChunk == null) {
                bl2 = true;
            } else if (this.lastChunk.next != chunk.block) {
                bl2 = true;
            } else {
                l = DataUtils.readHexLong(this.fileHeader, "version", 0L);
                if (this.lastChunk.version - l > 20L) {
                    bl2 = true;
                } else {
                    int n9 = DataUtils.readHexInt(this.fileHeader, "chunk", 0);
                    while (true) {
                        Chunk chunk3;
                        if ((chunk3 = this.chunks.get(n9)) == null) {
                            bl2 = true;
                            break;
                        }
                        if (n9 == this.lastChunk.id) break;
                        ++n9;
                    }
                }
            }
        }
        this.lastChunk = chunk;
        if (bl2) {
            this.writeFileHeader();
        }
        if (!bl) {
            this.shrinkFileIfPossible(1);
        }
        for (MVMap mVMap : arrayList2) {
            Page page = mVMap.getRoot();
            if (page.getTotalCount() <= 0L) continue;
            page.writeEnd();
        }
        ((Page)object).writeEnd();
        this.unsavedPageCount = Math.max(0, this.unsavedPageCount - n2);
        this.metaChanged = false;
        this.lastStoredVersion = l4;
        return l5;
    }

    private WriteBuffer getWriteBuffer() {
        WriteBuffer writeBuffer;
        if (this.writeBuffer != null) {
            writeBuffer = this.writeBuffer;
            writeBuffer.clear();
        } else {
            writeBuffer = new WriteBuffer();
        }
        return writeBuffer;
    }

    private void releaseWriteBuffer(WriteBuffer writeBuffer) {
        if (writeBuffer.capacity() <= 0x400000) {
            this.writeBuffer = writeBuffer;
        }
    }

    private boolean canOverwriteChunk(Chunk chunk, long l) {
        if (chunk.time + (long)this.retentionTime > l) {
            return false;
        }
        Chunk chunk2 = this.retainChunk;
        return chunk2 == null || chunk.version <= chunk2.version;
    }

    private long getTime() {
        return System.currentTimeMillis() - this.creationTime;
    }

    private Set<Chunk> applyFreedSpace(long l, long l2) {
        ArrayList<Chunk> arrayList;
        HashSet<Chunk> hashSet = New.hashSet();
        do {
            arrayList = New.arrayList();
            Iterator<Map.Entry<Long, HashMap<Integer, Chunk>>> iterator = this.freedPageSpace.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, HashMap<Integer, Chunk>> entry = iterator.next();
                long l3 = (Long)entry.getKey();
                if (l3 > l) continue;
                HashMap hashMap = (HashMap)entry.getValue();
                for (Chunk chunk : hashMap.values()) {
                    Chunk chunk2 = this.chunks.get(chunk.id);
                    if (chunk2 == null) continue;
                    chunk2.maxLenLive += chunk.maxLenLive;
                    chunk2.pageCountLive += chunk.pageCountLive;
                    if (chunk2.pageCountLive < 0) {
                        throw DataUtils.newIllegalStateException(3, "Corrupt page count {0}", chunk2.pageCountLive);
                    }
                    if (chunk2.maxLenLive < 0L) {
                        throw DataUtils.newIllegalStateException(3, "Corrupt max length {0}", chunk2.maxLenLive);
                    }
                    if (chunk2.pageCount == 0 && chunk2.maxLenLive > 0L) {
                        throw DataUtils.newIllegalStateException(3, "Corrupt max length {0}", chunk2.maxLenLive);
                    }
                    arrayList.add(chunk2);
                }
                iterator.remove();
            }
            for (Chunk chunk : arrayList) {
                if (chunk.maxLenLive == 0L) {
                    if (this.canOverwriteChunk(chunk, l2)) {
                        hashSet.add(chunk);
                        this.chunks.remove(chunk.id);
                        this.meta.remove(Chunk.getMetaKey(chunk.id));
                        continue;
                    }
                    this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
                    this.registerFreePage(l + 1L, chunk.id, 0L, 0);
                    continue;
                }
                this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
            }
        } while (arrayList.size() != 0);
        return hashSet;
    }

    private void shrinkFileIfPossible(int n) {
        long l;
        long l2 = this.getFileLengthInUse();
        if (l2 >= (l = this.fileStore.size())) {
            return;
        }
        if (n > 0 && l - l2 < 4096L) {
            return;
        }
        int n2 = (int)(100L - l2 * 100L / l);
        if (n2 < n) {
            return;
        }
        this.fileStore.truncate(l2);
    }

    private long getFileLengthInUse() {
        long l = 8192L;
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.len == Integer.MAX_VALUE) continue;
            long l2 = (chunk.block + (long)chunk.len) * 4096L;
            l = Math.max(l, l2);
        }
        return l;
    }

    public boolean hasUnsavedChanges() {
        this.checkOpen();
        if (this.metaChanged) {
            return true;
        }
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            long l;
            if (mVMap.isClosed() || (l = mVMap.getVersion()) < 0L || l <= this.lastStoredVersion) continue;
            return true;
        }
        return false;
    }

    private Chunk readChunkHeader(long l) {
        long l2 = l * 4096L;
        ByteBuffer byteBuffer = this.fileStore.readFully(l2, 1024);
        return Chunk.readChunkHeader(byteBuffer, l2);
    }

    public synchronized boolean compactMoveChunks() {
        this.checkOpen();
        if (this.lastChunk == null) {
            return false;
        }
        int n = this.retentionTime;
        this.retentionTime = 0;
        long l = this.getTime();
        ArrayList<Chunk> arrayList = New.arrayList();
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.maxLenLive != 0L || !this.canOverwriteChunk(chunk, l)) continue;
            arrayList.add(chunk);
        }
        for (Chunk chunk : arrayList) {
            this.chunks.remove(chunk.id);
            this.markMetaChanged();
            this.meta.remove(Chunk.getMetaKey(chunk.id));
            long l2 = chunk.block * 4096L;
            int n2 = chunk.len * 4096;
            this.fileStore.free(l2, n2);
        }
        if (this.fileStore.getFillRate() == 100) {
            return false;
        }
        long l3 = this.fileStore.getFirstFree() / 4096L;
        ArrayList arrayList2 = New.arrayList();
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.block <= l3) continue;
            arrayList2.add(chunk);
        }
        for (Chunk chunk : arrayList2) {
            Object object = this.getWriteBuffer();
            long l4 = chunk.block * 4096L;
            int n3 = chunk.len * 4096;
            ((WriteBuffer)object).limit(n3);
            ByteBuffer byteBuffer = this.fileStore.readFully(l4, n3);
            Chunk.readChunkHeader(byteBuffer, l4);
            int n4 = byteBuffer.position();
            ((WriteBuffer)object).position(n4);
            ((WriteBuffer)object).put(byteBuffer);
            long l5 = this.getFileLengthInUse();
            this.fileStore.markUsed(l5, n3);
            this.fileStore.free(l4, n3);
            chunk.block = l5 / 4096L;
            chunk.next = 0L;
            ((WriteBuffer)object).position(0);
            chunk.writeChunkHeader((WriteBuffer)object, n4);
            ((WriteBuffer)object).position(n3 - 128);
            ((WriteBuffer)object).put(this.lastChunk.getFooterBytes());
            ((WriteBuffer)object).position(0);
            this.write(l5, ((WriteBuffer)object).getBuffer());
            this.releaseWriteBuffer((WriteBuffer)object);
            this.markMetaChanged();
            this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
        }
        boolean bl = this.reuseSpace;
        this.reuseSpace = false;
        this.commitAndSave();
        this.sync();
        this.reuseSpace = true;
        for (Object object : arrayList2) {
            if (!this.chunks.containsKey(((Chunk)object).id)) continue;
            WriteBuffer writeBuffer = this.getWriteBuffer();
            long l6 = ((Chunk)object).block * 4096L;
            int n5 = ((Chunk)object).len * 4096;
            writeBuffer.limit(n5);
            ByteBuffer byteBuffer = this.fileStore.readFully(l6, n5);
            Chunk.readChunkHeader(byteBuffer, 0L);
            int n6 = byteBuffer.position();
            writeBuffer.position(n6);
            writeBuffer.put(byteBuffer);
            long l7 = this.fileStore.allocate(n5);
            this.fileStore.free(l6, n5);
            writeBuffer.position(0);
            ((Chunk)object).block = l7 / 4096L;
            ((Chunk)object).writeChunkHeader(writeBuffer, n6);
            writeBuffer.position(n5 - 128);
            writeBuffer.put(this.lastChunk.getFooterBytes());
            writeBuffer.position(0);
            this.write(l7, writeBuffer.getBuffer());
            this.releaseWriteBuffer(writeBuffer);
            this.markMetaChanged();
            this.meta.put(Chunk.getMetaKey(((Chunk)object).id), ((Chunk)object).asString());
        }
        this.commitAndSave();
        this.sync();
        this.shrinkFileIfPossible(0);
        this.reuseSpace = bl;
        this.retentionTime = n;
        return true;
    }

    public void sync() {
        this.fileStore.sync();
    }

    public synchronized boolean compact(int n, int n2) {
        int n3;
        this.checkOpen();
        if (this.lastChunk == null) {
            return false;
        }
        long l = 0L;
        long l2 = 0L;
        for (Chunk chunk : this.chunks.values()) {
            l += chunk.maxLen;
            l2 += chunk.maxLenLive;
        }
        if (l <= 0L) {
            l = 1L;
        }
        if ((n3 = (int)(100L * l2 / l)) >= n) {
            return false;
        }
        long l3 = this.getTime();
        ArrayList<Chunk> arrayList = New.arrayList();
        Chunk chunk = this.chunks.get(this.lastChunk.id);
        for (Chunk chunk2 : this.chunks.values()) {
            if (!this.canOverwriteChunk(chunk2, l3)) continue;
            long l4 = chunk.version - chunk2.version + 1L;
            chunk2.collectPriority = (int)((long)chunk2.getFillRate() / l4);
            arrayList.add(chunk2);
        }
        if (arrayList.size() == 0) {
            return false;
        }
        Collections.sort(arrayList, new Comparator<Chunk>(){

            @Override
            public int compare(Chunk chunk, Chunk chunk2) {
                return new Integer(chunk.collectPriority).compareTo(chunk2.collectPriority);
            }
        });
        long l5 = 0L;
        Chunk iterator2 = null;
        for (Chunk iterator3 : arrayList) {
            long l4 = iterator3.maxLen - iterator3.maxLenLive;
            if (iterator2 != null && l5 > (long)n2) break;
            l5 += l4;
            iterator2 = iterator3;
        }
        if (l5 < (long)n2) {
            return false;
        }
        boolean bl = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Chunk chunk2 = (Chunk)iterator.next();
            if (iterator2 == chunk2) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            iterator.remove();
        }
        for (Chunk chunk2 : arrayList) {
            this.copyLive(chunk2, arrayList);
        }
        this.commitAndSave();
        return true;
    }

    private void copyLive(Chunk chunk, ArrayList<Chunk> arrayList) {
        long l = chunk.block * 4096L;
        int n = chunk.len * 4096;
        ByteBuffer byteBuffer = this.fileStore.readFully(l, n);
        Chunk.readChunkHeader(byteBuffer, l);
        int n2 = chunk.pageCount;
        this.markMetaChanged();
        while (n2-- > 0) {
            int n3 = byteBuffer.position();
            int n4 = byteBuffer.getInt();
            if (n4 <= 0) {
                throw DataUtils.newIllegalStateException(6, "Page length {0}", n4);
            }
            byteBuffer.getShort();
            int n5 = DataUtils.readVarInt(byteBuffer);
            MVMap<?, ?> mVMap = this.getMap(n5);
            if (mVMap == null) {
                byteBuffer.position(n3 + n4);
                continue;
            }
            byteBuffer.position(n3);
            Page page = new Page(mVMap, 0L);
            page.read(byteBuffer, chunk.id, byteBuffer.position(), n);
            for (int i = 0; i < page.getKeyCount(); ++i) {
                Chunk chunk2;
                Object object = page.getKey(i);
                Page page2 = mVMap.getPage(object);
                if (page2 == null || page2.getPos() == 0L || !arrayList.contains(chunk2 = this.getChunk(page2.getPos()))) continue;
                Object obj = mVMap.remove(object);
                mVMap.put(object, obj);
            }
        }
    }

    private MVMap<?, ?> getMap(int n) {
        if (n == 0) {
            return this.meta;
        }
        return this.maps.get(n);
    }

    Page readPage(MVMap<?, ?> mVMap, long l) {
        Page page;
        if (l == 0L) {
            throw DataUtils.newIllegalStateException(6, "Position 0", new Object[0]);
        }
        Page page2 = page = this.cache == null ? null : this.cache.get(l);
        if (page == null) {
            Chunk chunk = this.getChunk(l);
            long l2 = chunk.block * 4096L;
            if ((l2 += (long)DataUtils.getPageOffset(l)) < 0L) {
                throw DataUtils.newIllegalStateException(6, "Negative position {0}", l2);
            }
            page = Page.read(this.fileStore, mVMap, l, l2, this.fileStore.size());
            this.cachePage(l, page, page.getMemory());
        }
        return page;
    }

    void removePage(MVMap<?, ?> mVMap, long l, int n) {
        if (l == 0L) {
            int n2 = 1 + n / this.pageSplitSize;
            this.unsavedPageCount = Math.max(0, this.unsavedPageCount - n2);
            return;
        }
        if (this.cache != null) {
            this.cache.remove(l);
        }
        Chunk chunk = this.getChunk(l);
        long l2 = this.currentVersion;
        if (mVMap == this.meta && this.currentStoreVersion >= 0L && Thread.currentThread() == this.currentStoreThread) {
            l2 = this.currentStoreVersion;
        }
        this.registerFreePage(l2, chunk.id, DataUtils.getPageMaxLength(l), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerFreePage(long l, int n, long l2, int n2) {
        HashMap<Integer, Chunk> hashMap;
        HashMap<Integer, Chunk> hashMap2 = this.freedPageSpace.get(l);
        if (hashMap2 == null) {
            hashMap2 = New.hashMap();
            hashMap = this.freedPageSpace.putIfAbsent(l, hashMap2);
            if (hashMap != null) {
                hashMap2 = hashMap;
            }
        }
        hashMap = hashMap2;
        synchronized (hashMap) {
            Chunk chunk = hashMap2.get(n);
            if (chunk == null) {
                chunk = new Chunk(n);
                hashMap2.put(n, chunk);
            }
            chunk.maxLenLive -= l2;
            chunk.pageCountLive -= n2;
        }
    }

    Compressor getCompressorFast() {
        if (this.compressorFast == null) {
            this.compressorFast = new CompressLZF();
        }
        return this.compressorFast;
    }

    Compressor getCompressorHigh() {
        if (this.compressorHigh == null) {
            this.compressorHigh = new CompressDeflate();
        }
        return this.compressorHigh;
    }

    int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getPageSplitSize() {
        return this.pageSplitSize;
    }

    public boolean getReuseSpace() {
        return this.reuseSpace;
    }

    public void setReuseSpace(boolean bl) {
        this.reuseSpace = bl;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int n) {
        this.retentionTime = n;
    }

    public void setVersionsToKeep(int n) {
        this.versionsToKeep = n;
    }

    public long getVersionsToKeep() {
        return this.versionsToKeep;
    }

    long getOldestVersionToKeep() {
        long l = this.currentVersion;
        if (this.fileStore == null) {
            return l - (long)this.versionsToKeep + 1L;
        }
        long l2 = this.currentStoreVersion;
        if (l2 > -1L) {
            l = Math.min(l, l2);
        }
        return l;
    }

    private boolean isKnownVersion(long l) {
        String string;
        if (l > this.currentVersion || l < 0L) {
            return false;
        }
        if (l == this.currentVersion || this.chunks.size() == 0) {
            return true;
        }
        Chunk chunk = this.getChunkForVersion(l);
        if (chunk == null) {
            return false;
        }
        MVMap<String, String> mVMap = this.getMetaMap(l);
        if (mVMap == null) {
            return false;
        }
        Iterator<String> iterator = mVMap.keyIterator("chunk.");
        while (iterator.hasNext() && (string = iterator.next()).startsWith("chunk.")) {
            if (this.meta.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    void registerUnsavedPage(int n) {
        int n2 = 1 + n / this.pageSplitSize;
        this.unsavedPageCount += n2;
        int n3 = this.unsavedPageCount;
        if (n3 > this.autoCommitPageCount && this.autoCommitPageCount > 0) {
            this.saveNeeded = true;
        }
    }

    void beforeWrite() {
        if (this.saveNeeded) {
            this.saveNeeded = false;
            this.commitAndSave();
        }
    }

    public int getStoreVersion() {
        this.checkOpen();
        String string = (String)this.meta.get("setting.storeVersion");
        return string == null ? 0 : DataUtils.parseHexInt(string);
    }

    public synchronized void setStoreVersion(int n) {
        this.checkOpen();
        this.markMetaChanged();
        this.meta.put("setting.storeVersion", Integer.toHexString(n));
    }

    public void rollback() {
        this.rollbackTo(this.currentVersion);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void rollbackTo(long l) {
        int n;
        void var4_8;
        this.checkOpen();
        if (l == 0L) {
            for (MVMap<?, ?> mVMap : this.maps.values()) {
                mVMap.close();
            }
            this.meta.clear();
            this.chunks.clear();
            if (this.fileStore != null) {
                this.fileStore.clear();
            }
            this.maps.clear();
            this.freedPageSpace.clear();
            this.currentVersion = l;
            this.setWriteVersion(l);
            this.metaChanged = false;
            return;
        }
        DataUtils.checkArgument(this.isKnownVersion(l), "Unknown version {0}", l);
        for (MVMap<?, ?> object2 : this.maps.values()) {
            object2.rollbackTo(l);
        }
        for (long i = this.currentVersion; i >= l && this.freedPageSpace.size() != 0; --i) {
            this.freedPageSpace.remove(i);
        }
        this.meta.rollbackTo(l);
        this.metaChanged = false;
        boolean bl = false;
        Object var4_7 = null;
        Chunk chunk = this.lastChunk;
        while (chunk != null && chunk.version >= l) {
            Chunk chunk2 = chunk;
            chunk = this.chunks.get(chunk.id - 1);
        }
        Chunk chunk3 = this.lastChunk;
        if (var4_8 != null && chunk3.version > var4_8.version) {
            this.revertTemp(l);
            bl = true;
            while ((chunk3 = this.lastChunk) != null && chunk3.version > var4_8.version) {
                this.chunks.remove(this.lastChunk.id);
                long l2 = chunk3.block * 4096L;
                n = chunk3.len * 4096;
                this.fileStore.free(l2, n);
                WriteBuffer writeBuffer = this.getWriteBuffer();
                writeBuffer.limit(n);
                Arrays.fill(writeBuffer.getBuffer().array(), (byte)0);
                this.write(l2, writeBuffer.getBuffer());
                this.releaseWriteBuffer(writeBuffer);
                this.lastChunk = this.chunks.get(this.lastChunk.id - 1);
            }
            this.writeFileHeader();
            this.readFileHeader();
        }
        for (MVMap<?, ?> mVMap : New.arrayList(this.maps.values())) {
            n = mVMap.getId();
            if (mVMap.getCreateVersion() >= l) {
                mVMap.close();
                this.maps.remove(n);
                continue;
            }
            if (!bl) continue;
            mVMap.setRootPos(MVStore.getRootPos(this.meta, n), -1L);
        }
        if (this.lastChunk != null && (chunk = this.chunks.get(this.lastChunk.id - 1)) != null) {
            this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
        }
        this.currentVersion = l;
        this.setWriteVersion(l);
    }

    private static long getRootPos(MVMap<String, String> mVMap, int n) {
        String string = mVMap.get("root." + Integer.toHexString(n));
        return string == null ? 0L : DataUtils.parseHexLong(string);
    }

    private void revertTemp(long l) {
        Iterator<Object> iterator = this.freedPageSpace.keySet().iterator();
        while (iterator.hasNext()) {
            long l2 = (Long)iterator.next();
            if (l2 > l) continue;
            iterator.remove();
        }
        for (MVMap mVMap : this.maps.values()) {
            mVMap.removeUnusedOldVersions();
        }
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public Map<String, Object> getStoreHeader() {
        return this.fileHeader;
    }

    private void checkOpen() {
        if (this.closed) {
            throw DataUtils.newIllegalStateException(4, "This store is closed", new Object[0]);
        }
    }

    public synchronized void renameMap(MVMap<?, ?> mVMap, String string) {
        this.checkOpen();
        DataUtils.checkArgument(mVMap != this.meta, "Renaming the meta map is not allowed", new Object[0]);
        int n = mVMap.getId();
        String string2 = this.getMapName(n);
        if (string2.equals(string)) {
            return;
        }
        DataUtils.checkArgument(!this.meta.containsKey("name." + string), "A map named {0} already exists", string);
        this.markMetaChanged();
        String string3 = Integer.toHexString(n);
        this.meta.remove("name." + string2);
        this.meta.put("map." + string3, mVMap.asString(string));
        this.meta.put("name." + string, string3);
    }

    public synchronized void removeMap(MVMap<?, ?> mVMap) {
        this.checkOpen();
        DataUtils.checkArgument(mVMap != this.meta, "Removing the meta map is not allowed", new Object[0]);
        mVMap.clear();
        int n = mVMap.getId();
        String string = this.getMapName(n);
        this.markMetaChanged();
        String string2 = Integer.toHexString(n);
        this.meta.remove("map." + string2);
        this.meta.remove("name." + string);
        this.meta.remove("root." + string2);
        this.maps.remove(n);
    }

    public synchronized String getMapName(int n) {
        String string = (String)this.meta.get("map." + Integer.toHexString(n));
        return string == null ? null : DataUtils.parseMap(string).get("name");
    }

    void commitInBackground() {
        block5: {
            if (this.unsavedPageCount == 0 || this.closed) {
                return;
            }
            long l = this.getTime();
            if (l <= this.lastCommitTime + (long)this.autoCommitDelay) {
                return;
            }
            if (!this.hasUnsavedChanges()) {
                return;
            }
            try {
                this.commitAndSave();
            }
            catch (Exception exception) {
                if (this.backgroundExceptionHandler == null) break block5;
                this.backgroundExceptionHandler.uncaughtException(null, exception);
            }
        }
    }

    public void setCacheSize(int n) {
        if (this.cache != null) {
            this.cache.setMaxMemory((long)n * 1024L * 1024L);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundThread() {
        BackgroundWriterThread backgroundWriterThread = this.backgroundWriterThread;
        if (backgroundWriterThread == null) {
            return;
        }
        this.backgroundWriterThread = null;
        if (Thread.currentThread() == backgroundWriterThread) {
            return;
        }
        Object object = backgroundWriterThread.sync;
        synchronized (object) {
            backgroundWriterThread.sync.notifyAll();
        }
        try {
            backgroundWriterThread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAutoCommitDelay(int n) {
        if (this.autoCommitDelay == n) {
            return;
        }
        this.autoCommitDelay = n;
        if (this.fileStore == null) {
            return;
        }
        this.stopBackgroundThread();
        if (n > 0) {
            int n2 = Math.max(1, n / 10);
            BackgroundWriterThread backgroundWriterThread = new BackgroundWriterThread(this, n2, this.fileStore.toString());
            backgroundWriterThread.start();
            this.backgroundWriterThread = backgroundWriterThread;
        }
    }

    public int getAutoCommitDelay() {
        return this.autoCommitDelay;
    }

    public int getAutoCommitPageCount() {
        return this.autoCommitPageCount;
    }

    public int getUnsavedPageCount() {
        return this.unsavedPageCount;
    }

    void cachePage(long l, Page page, int n) {
        if (this.cache != null) {
            this.cache.put(l, page, n);
        }
    }

    public int getCacheSizeUsed() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getUsedMemory() / 1024L / 1024L);
    }

    public int getCacheSize() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getMaxMemory() / 1024L / 1024L);
    }

    public CacheLongKeyLIRS<Page> getCache() {
        return this.cache;
    }

    public static class Builder {
        private final HashMap<String, Object> config = New.hashMap();

        private Builder set(String string, Object object) {
            this.config.put(string, object);
            return this;
        }

        public Builder autoCommitDisabled() {
            this.set("autoCommitBufferSize", 0);
            return this.set("autoCommitDelay", 0);
        }

        public Builder autoCommitBufferSize(int n) {
            return this.set("autoCommitBufferSize", n);
        }

        public Builder fileName(String string) {
            return this.set("fileName", string);
        }

        public Builder encryptionKey(char[] cArray) {
            return this.set("encryptionKey", cArray);
        }

        public Builder readOnly() {
            return this.set("readOnly", 1);
        }

        public Builder cacheSize(int n) {
            return this.set("cacheSize", n);
        }

        public Builder compress() {
            return this.set("compress", 1);
        }

        public Builder compressHigh() {
            return this.set("compress", 2);
        }

        public Builder pageSplitSize(int n) {
            return this.set("pageSplitSize", n);
        }

        public Builder backgroundExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            return this.set("backgroundExceptionHandler", uncaughtExceptionHandler);
        }

        public Builder fileStore(FileStore fileStore) {
            return this.set("fileStore", fileStore);
        }

        public MVStore open() {
            return new MVStore(this.config);
        }

        public String toString() {
            return DataUtils.appendMap(new StringBuilder(), this.config).toString();
        }

        public static Builder fromString(String string) {
            HashMap<String, String> hashMap = DataUtils.parseMap(string);
            Builder builder = new Builder();
            builder.config.putAll(hashMap);
            return builder;
        }
    }

    private static class BackgroundWriterThread
    extends Thread {
        public final Object sync = new Object();
        private final MVStore store;
        private final int sleep;

        BackgroundWriterThread(MVStore mVStore, int n, String string) {
            super("MVStore background writer " + string);
            this.store = mVStore;
            this.sleep = n;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BackgroundWriterThread backgroundWriterThread;
            while ((backgroundWriterThread = this.store.backgroundWriterThread) != null) {
                Object object = this.sync;
                synchronized (object) {
                    try {
                        this.sync.wait(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                }
                this.store.commitInBackground();
            }
        }
    }
}

