/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.mvstore.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.glowroot.shaded.h2.command.ddl.Analyze;
import org.glowroot.shaded.h2.command.ddl.CreateTableData;
import org.glowroot.shaded.h2.constraint.Constraint;
import org.glowroot.shaded.h2.constraint.ConstraintReferential;
import org.glowroot.shaded.h2.engine.Database;
import org.glowroot.shaded.h2.engine.Session;
import org.glowroot.shaded.h2.engine.SysProperties;
import org.glowroot.shaded.h2.index.BaseIndex;
import org.glowroot.shaded.h2.index.Cursor;
import org.glowroot.shaded.h2.index.Index;
import org.glowroot.shaded.h2.index.IndexType;
import org.glowroot.shaded.h2.index.MultiVersionIndex;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.message.Trace;
import org.glowroot.shaded.h2.mvstore.db.MVDelegateIndex;
import org.glowroot.shaded.h2.mvstore.db.MVIndex;
import org.glowroot.shaded.h2.mvstore.db.MVPrimaryIndex;
import org.glowroot.shaded.h2.mvstore.db.MVSecondaryIndex;
import org.glowroot.shaded.h2.mvstore.db.MVSpatialIndex;
import org.glowroot.shaded.h2.mvstore.db.MVTableEngine;
import org.glowroot.shaded.h2.mvstore.db.TransactionStore;
import org.glowroot.shaded.h2.result.Row;
import org.glowroot.shaded.h2.schema.SchemaObject;
import org.glowroot.shaded.h2.table.Column;
import org.glowroot.shaded.h2.table.IndexColumn;
import org.glowroot.shaded.h2.table.RegularTable;
import org.glowroot.shaded.h2.table.Table;
import org.glowroot.shaded.h2.table.TableBase;
import org.glowroot.shaded.h2.util.MathUtils;
import org.glowroot.shaded.h2.util.New;
import org.glowroot.shaded.h2.value.DataType;

public class MVTable
extends TableBase {
    private MVPrimaryIndex primaryIndex;
    private ArrayList<Index> indexes = New.arrayList();
    private long lastModificationId;
    private volatile Session lockExclusive;
    private HashSet<Session> lockShared = New.hashSet();
    private final Trace traceLock;
    private int changesSinceAnalyze;
    private int nextAnalyze;
    private boolean containsLargeObject;
    private Column rowIdColumn;
    private final TransactionStore store;
    private boolean waitForLock;

    public MVTable(CreateTableData createTableData, MVTableEngine.Store store) {
        super(createTableData);
        this.nextAnalyze = this.database.getSettings().analyzeAuto;
        this.store = store.getTransactionStore();
        this.isHidden = createTableData.isHidden;
        for (Column column : this.getColumns()) {
            if (!DataType.isLargeObject(column.getType())) continue;
            this.containsLargeObject = true;
        }
        this.traceLock = this.database.getTrace("lock");
    }

    void init(Session session) {
        this.primaryIndex = new MVPrimaryIndex(session.getDatabase(), this, this.getId(), IndexColumn.wrap(this.getColumns()), IndexType.createScan(true));
        this.indexes.add(this.primaryIndex);
    }

    public String getMapName() {
        return this.primaryIndex.getMapName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock(Session session, boolean bl, boolean bl2) {
        int n = this.database.getLockMode();
        if (n == 0) {
            return;
        }
        if (!bl2 && this.database.isMultiVersion()) {
            if (bl) {
                bl = false;
            } else if (this.lockExclusive == null) {
                return;
            }
        }
        if (this.lockExclusive == session) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            try {
                this.doLock(session, n, bl);
            }
            finally {
                session.setWaitForLock(null, null);
            }
        }
    }

    private void doLock(Session session, int n, boolean bl) {
        this.traceLock(session, bl, "requesting for");
        long l = 0L;
        boolean bl2 = false;
        while (this.lockExclusive != session) {
            if (bl) {
                if (this.lockExclusive == null) {
                    if (this.lockShared.isEmpty()) {
                        this.traceLock(session, bl, "added for");
                        session.addLock(this);
                        this.lockExclusive = session;
                        return;
                    }
                    if (this.lockShared.size() == 1 && this.lockShared.contains(session)) {
                        this.traceLock(session, bl, "add (upgraded) for ");
                        this.lockExclusive = session;
                        return;
                    }
                }
            } else if (this.lockExclusive == null) {
                if (n == 3 && !this.database.isMultiThreaded() && !this.database.isMultiVersion()) {
                    return;
                }
                if (!this.lockShared.contains(session)) {
                    this.traceLock(session, bl, "ok");
                    session.addLock(this);
                    this.lockShared.add(session);
                }
                return;
            }
            session.setWaitForLock(this, Thread.currentThread());
            if (bl2) {
                ArrayList<Session> arrayList = this.checkDeadlock(session, null, null);
                if (arrayList != null) {
                    throw DbException.get(40001, MVTable.getDeadlockDetails(arrayList));
                }
            } else {
                bl2 = true;
            }
            long l2 = System.currentTimeMillis();
            if (l == 0L) {
                l = l2 + (long)session.getLockTimeout();
            } else if (l2 >= l) {
                this.traceLock(session, bl, "timeout after " + session.getLockTimeout());
                throw DbException.get(50200, this.getName());
            }
            try {
                long l3;
                this.traceLock(session, bl, "waiting for");
                if (this.database.getLockMode() == 2) {
                    for (int i = 0; i < 20; ++i) {
                        long l4 = Runtime.getRuntime().freeMemory();
                        System.gc();
                        long l5 = Runtime.getRuntime().freeMemory();
                        if (l4 == l5) break;
                    }
                }
                if ((l3 = Math.min(100L, l - l2)) == 0L) {
                    l3 = 1L;
                }
                this.waitForLock = true;
                this.database.wait(l3);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    private static String getDeadlockDetails(ArrayList<Session> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Session session : arrayList) {
            Table table = session.getWaitForLock();
            Thread thread = session.getWaitForLockThread();
            stringBuilder.append("\nSession ").append(session.toString()).append(" on thread ").append(thread.getName()).append(" is waiting to lock ").append(table.toString()).append(" while locking ");
            int n = 0;
            for (Table table2 : session.getLocks()) {
                if (n++ > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(table2.toString());
                if (!(table2 instanceof RegularTable)) continue;
                if (((MVTable)table2).lockExclusive == session) {
                    stringBuilder.append(" (exclusive)");
                    continue;
                }
                stringBuilder.append(" (shared)");
            }
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Session> checkDeadlock(Session session, Session session2, Set<Session> set) {
        Class<RegularTable> clazz = RegularTable.class;
        synchronized (RegularTable.class) {
            if (session2 == null) {
                session2 = session;
                set = New.hashSet();
            } else {
                if (session2 == session) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return New.arrayList();
                }
                if (set.contains(session)) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return null;
                }
            }
            set.add(session);
            ArrayList<Session> arrayList = null;
            Object object = this.lockShared.iterator();
            while (object.hasNext()) {
                Table table;
                Session session3 = object.next();
                if (session3 == session || (table = session3.getWaitForLock()) == null || (arrayList = table.checkDeadlock(session3, session2, set)) == null) continue;
                arrayList.add(session);
                break;
            }
            if (arrayList == null && this.lockExclusive != null && (object = this.lockExclusive.getWaitForLock()) != null && (arrayList = ((Table)object).checkDeadlock(this.lockExclusive, session2, set)) != null) {
                arrayList.add(session);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return arrayList;
        }
    }

    private void traceLock(Session session, boolean bl, String string) {
        if (this.traceLock.isDebugEnabled()) {
            this.traceLock.debug("{0} {1} {2} {3}", session.getId(), bl ? "exclusive write lock" : "shared read lock", string, this.getName());
        }
    }

    @Override
    public boolean isLockedExclusively() {
        return this.lockExclusive != null;
    }

    @Override
    public boolean isLockedExclusivelyBy(Session session) {
        return this.lockExclusive == session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Session session) {
        if (this.database != null) {
            this.traceLock(session, this.lockExclusive == session, "unlock");
            if (this.lockExclusive == session) {
                this.lockExclusive = null;
            }
            if (this.lockShared.size() > 0) {
                this.lockShared.remove(session);
            }
            Database database = this.database;
            synchronized (database) {
                if (this.database.getSessionCount() > 1 && this.waitForLock) {
                    this.database.notifyAll();
                }
            }
        }
    }

    @Override
    public boolean canTruncate() {
        ArrayList<Constraint> arrayList;
        if (this.getCheckForeignKeyConstraints() && this.database.getReferentialIntegrity() && (arrayList = this.getConstraints()) != null) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ConstraintReferential constraintReferential;
                Constraint constraint = arrayList.get(i);
                if (!constraint.getConstraintType().equals("REFERENTIAL") || (constraintReferential = (ConstraintReferential)constraint).getRefTable() != this) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public Row getRow(Session session, long l) {
        return this.primaryIndex.getRow(session, l);
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, boolean bl, String string2) {
        BaseIndex baseIndex;
        boolean bl2;
        if (indexType.isPrimaryKey()) {
            for (IndexColumn indexColumn : indexColumnArray) {
                Column column = indexColumn.column;
                if (column.isNullable()) {
                    throw DbException.get(90023, column.getName());
                }
                column.setPrimaryKey(true);
            }
        }
        boolean bl3 = bl2 = this.isTemporary() && !this.isGlobalTemporary();
        if (!bl2) {
            this.database.lockMeta(session);
        }
        int n2 = this.getMainIndexColumn(indexType, indexColumnArray);
        if (this.database.isStarting()) {
            if (this.store.store.hasMap("index." + n)) {
                n2 = -1;
            }
        } else if (this.primaryIndex.getRowCountMax() != 0L) {
            n2 = -1;
        }
        if (n2 != -1) {
            this.primaryIndex.setMainIndexColumn(n2);
            baseIndex = new MVDelegateIndex(this, n, string, this.primaryIndex, indexType);
        } else {
            baseIndex = indexType.isSpatial() ? new MVSpatialIndex(session.getDatabase(), this, n, string, indexColumnArray, indexType) : new MVSecondaryIndex(session.getDatabase(), this, n, string, indexColumnArray, indexType);
        }
        if (baseIndex.needRebuild()) {
            this.rebuildIndex(session, (MVIndex)((Object)baseIndex), string);
        }
        baseIndex.setTemporary(this.isTemporary());
        if (baseIndex.getCreateSQL() != null) {
            baseIndex.setComment(string2);
            if (bl2) {
                session.addLocalTempTableIndex(baseIndex);
            } else {
                this.database.addSchemaObject(session, baseIndex);
            }
        }
        this.indexes.add(baseIndex);
        this.setModified();
        return baseIndex;
    }

    private void rebuildIndex(Session session, MVIndex mVIndex, String string) {
        try {
            if (session.getDatabase().getMvStore() == null) {
                this.rebuildIndexBuffered(session, mVIndex);
            } else {
                this.rebuildIndexBlockMerge(session, mVIndex);
            }
        }
        catch (DbException dbException) {
            this.getSchema().freeUniqueName(string);
            try {
                mVIndex.remove(session);
            }
            catch (DbException dbException2) {
                this.trace.error(dbException2, "could not remove index");
                throw dbException2;
            }
            throw dbException;
        }
    }

    private void rebuildIndexBlockMerge(Session session, MVIndex mVIndex) {
        Object object;
        long l;
        if (mVIndex instanceof MVSpatialIndex) {
            this.rebuildIndexBuffered(session, mVIndex);
        }
        Index index = this.getScanIndex(session);
        long l2 = l = index.getRowCount(session);
        Cursor cursor = index.find(session, null, null);
        long l3 = 0L;
        MVTableEngine.Store store = session.getDatabase().getMvStore();
        int n = 5000;
        ArrayList<Row> arrayList = New.arrayList(n);
        String string = this.getName() + ":" + mVIndex.getName();
        int n2 = MathUtils.convertLongToInt(l2);
        ArrayList<String> arrayList2 = New.arrayList();
        while (cursor.next()) {
            object = cursor.get();
            arrayList.add((Row)object);
            this.database.setProgress(1, string, MathUtils.convertLongToInt(l3++), n2);
            if (arrayList.size() >= n) {
                MVTable.sortRows(arrayList, mVIndex);
                String string2 = store.nextTemporaryMapName();
                mVIndex.addRowsToBuffer(arrayList, string2);
                arrayList2.add(string2);
                arrayList.clear();
            }
            --l;
        }
        MVTable.sortRows(arrayList, mVIndex);
        if (arrayList2.size() > 0) {
            object = store.nextTemporaryMapName();
            mVIndex.addRowsToBuffer(arrayList, (String)object);
            arrayList2.add((String)object);
            arrayList.clear();
            mVIndex.addBufferedRows(arrayList2);
        } else {
            MVTable.addRowsToIndex(session, arrayList, mVIndex);
        }
        if (SysProperties.CHECK && l != 0L) {
            DbException.throwInternalError("rowcount remaining=" + l + " " + this.getName());
        }
    }

    private void rebuildIndexBuffered(Session session, Index index) {
        long l;
        Index index2 = this.getScanIndex(session);
        long l2 = l = index2.getRowCount(session);
        Cursor cursor = index2.find(session, null, null);
        long l3 = 0L;
        int n = (int)Math.min(l2, 10000L);
        ArrayList<Row> arrayList = New.arrayList(n);
        String string = this.getName() + ":" + index.getName();
        int n2 = MathUtils.convertLongToInt(l2);
        while (cursor.next()) {
            Row row = cursor.get();
            arrayList.add(row);
            this.database.setProgress(1, string, MathUtils.convertLongToInt(l3++), n2);
            if (arrayList.size() >= n) {
                MVTable.addRowsToIndex(session, arrayList, index);
            }
            --l;
        }
        MVTable.addRowsToIndex(session, arrayList, index);
        if (SysProperties.CHECK && l != 0L) {
            DbException.throwInternalError("rowcount remaining=" + l + " " + this.getName());
        }
    }

    private int getMainIndexColumn(IndexType indexType, IndexColumn[] indexColumnArray) {
        if (this.primaryIndex.getMainIndexColumn() != -1) {
            return -1;
        }
        if (!indexType.isPrimaryKey() || indexColumnArray.length != 1) {
            return -1;
        }
        IndexColumn indexColumn = indexColumnArray[0];
        if (indexColumn.sortType != 0) {
            return -1;
        }
        switch (indexColumn.column.getType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                return -1;
            }
        }
        return indexColumn.column.getColumnId();
    }

    private static void addRowsToIndex(Session session, ArrayList<Row> arrayList, Index index) {
        MVTable.sortRows(arrayList, index);
        for (Row row : arrayList) {
            index.add(session, row);
        }
        arrayList.clear();
    }

    private static void sortRows(ArrayList<Row> arrayList, final Index index) {
        Collections.sort(arrayList, new Comparator<Row>(){

            @Override
            public int compare(Row row, Row row2) {
                return index.compareRows(row, row2);
            }
        });
    }

    @Override
    public void removeRow(Session session, Row row) {
        this.lastModificationId = this.database.getNextModificationDataId();
        TransactionStore.Transaction transaction = this.getTransaction(session);
        long l = transaction.setSavepoint();
        try {
            for (int i = this.indexes.size() - 1; i >= 0; --i) {
                Index index = this.indexes.get(i);
                index.remove(session, row);
            }
        }
        catch (Throwable throwable) {
            transaction.rollbackToSavepoint(l);
            throw DbException.convert(throwable);
        }
        this.analyzeIfRequired(session);
    }

    @Override
    public void truncate(Session session) {
        this.lastModificationId = this.database.getNextModificationDataId();
        for (int i = this.indexes.size() - 1; i >= 0; --i) {
            Index index = this.indexes.get(i);
            index.truncate(session);
        }
        this.changesSinceAnalyze = 0;
    }

    @Override
    public void addRow(Session session, Row row) {
        this.lastModificationId = this.database.getNextModificationDataId();
        TransactionStore.Transaction transaction = this.getTransaction(session);
        long l = transaction.setSavepoint();
        try {
            int n = this.indexes.size();
            for (int i = 0; i < n; ++i) {
                Index index = this.indexes.get(i);
                index.add(session, row);
            }
        }
        catch (Throwable throwable) {
            transaction.rollbackToSavepoint(l);
            DbException dbException = DbException.convert(throwable);
            if (dbException.getErrorCode() == 23505) {
                for (int i = 0; i < this.indexes.size(); ++i) {
                    MultiVersionIndex multiVersionIndex;
                    Index index = this.indexes.get(i);
                    if (!index.getIndexType().isUnique() || !(index instanceof MultiVersionIndex) || !(multiVersionIndex = (MultiVersionIndex)index).isUncommittedFromOtherSession(session, row)) continue;
                    throw DbException.get(90131, index.getName());
                }
            }
            throw dbException;
        }
        this.analyzeIfRequired(session);
    }

    private void analyzeIfRequired(Session session) {
        if (this.nextAnalyze == 0 || this.nextAnalyze > this.changesSinceAnalyze++) {
            return;
        }
        this.changesSinceAnalyze = 0;
        int n = 2 * this.nextAnalyze;
        if (n > 0) {
            this.nextAnalyze = n;
        }
        int n2 = session.getDatabase().getSettings().analyzeSample / 10;
        Analyze.analyzeTable(session, this, n2, false);
    }

    @Override
    public void checkSupportAlter() {
    }

    @Override
    public String getTableType() {
        return "TABLE";
    }

    @Override
    public Index getScanIndex(Session session) {
        return this.primaryIndex;
    }

    @Override
    public Index getUniqueIndex() {
        return this.primaryIndex;
    }

    @Override
    public ArrayList<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public long getMaxDataModificationId() {
        return this.lastModificationId;
    }

    public boolean getContainsLargeObject() {
        return this.containsLargeObject;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        if (this.containsLargeObject) {
            this.truncate(session);
            this.database.getLobStorage().removeAllForTable(this.getId());
            this.database.lockMeta(session);
        }
        this.database.getMvStore().removeTable(this);
        super.removeChildrenAndResources(session);
        while (this.indexes.size() > 1) {
            Index index = this.indexes.get(1);
            if (index.getName() == null) continue;
            this.database.removeSchemaObject(session, index);
        }
        if (SysProperties.CHECK) {
            for (SchemaObject schemaObject : this.database.getAllSchemaObjects(1)) {
                Index index = (Index)schemaObject;
                if (index.getTable() != this) continue;
                DbException.throwInternalError("index not dropped: " + index.getName());
            }
        }
        this.primaryIndex.remove(session);
        this.database.removeMeta(session, this.getId());
        this.primaryIndex = null;
        this.close(session);
        this.invalidate();
    }

    @Override
    public long getRowCount(Session session) {
        return this.primaryIndex.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation() {
        return this.primaryIndex.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.primaryIndex.getDiskSpaceUsed();
    }

    @Override
    public void checkRename() {
    }

    TransactionStore.Transaction getTransaction(Session session) {
        if (session == null) {
            return this.store.begin();
        }
        return session.getTransaction();
    }

    @Override
    public Column getRowIdColumn() {
        if (this.rowIdColumn == null) {
            this.rowIdColumn = new Column("_ROWID_", 5);
            this.rowIdColumn.setTable(this, -1);
        }
        return this.rowIdColumn;
    }

    @Override
    public String toString() {
        return this.getSQL();
    }

    @Override
    public boolean isMVStore() {
        return true;
    }

    public void commit() {
        if (this.database != null) {
            this.lastModificationId = this.database.getNextModificationDataId();
        }
    }
}

