/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.store.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.glowroot.shaded.h2.engine.SysProperties;
import org.glowroot.shaded.h2.store.fs.FileBase;

class FileDisk
extends FileBase {
    private final RandomAccessFile file;
    private final String name;

    FileDisk(String string, String string2) throws FileNotFoundException {
        this.file = new RandomAccessFile(string, string2);
        this.name = string;
    }

    @Override
    public void force(boolean bl) throws IOException {
        String string = SysProperties.SYNC_METHOD;
        if (!"".equals(string)) {
            if ("sync".equals(string)) {
                this.file.getFD().sync();
            } else if ("force".equals(string)) {
                this.file.getChannel().force(true);
            } else if ("forceFalse".equals(string)) {
                this.file.getChannel().force(false);
            } else {
                this.file.getFD().sync();
            }
        }
    }

    @Override
    public FileChannel truncate(long l) throws IOException {
        if (l < this.file.length()) {
            this.file.setLength(l);
        }
        return this;
    }

    @Override
    public synchronized FileLock tryLock(long l, long l2, boolean bl) throws IOException {
        return this.file.getChannel().tryLock(l, l2, bl);
    }

    @Override
    public void implCloseChannel() throws IOException {
        this.file.close();
    }

    @Override
    public long position() throws IOException {
        return this.file.getFilePointer();
    }

    @Override
    public long size() throws IOException {
        return this.file.length();
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int n = this.file.read(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        if (n > 0) {
            byteBuffer.position(byteBuffer.position() + n);
        }
        return n;
    }

    @Override
    public FileChannel position(long l) throws IOException {
        this.file.seek(l);
        return this;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        this.file.write(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), n);
        byteBuffer.position(byteBuffer.position() + n);
        return n;
    }

    public String toString() {
        return this.name;
    }
}

