/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.h2.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import org.glowroot.shaded.h2.engine.SysProperties;
import org.glowroot.shaded.h2.message.DbException;
import org.glowroot.shaded.h2.store.fs.FileUtils;
import org.glowroot.shaded.h2.util.IOUtils;
import org.glowroot.shaded.h2.util.New;

public class TempFileDeleter {
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final HashMap<PhantomReference<?>, String> refMap = New.hashMap();

    private TempFileDeleter() {
    }

    public static TempFileDeleter getInstance() {
        return new TempFileDeleter();
    }

    public synchronized Reference<?> addFile(String string, Object object) {
        IOUtils.trace("TempFileDeleter.addFile", string, object);
        PhantomReference<Object> phantomReference = new PhantomReference<Object>(object, this.queue);
        this.refMap.put(phantomReference, string);
        this.deleteUnused();
        return phantomReference;
    }

    public synchronized void deleteFile(Reference<?> reference, String string) {
        String string2;
        if (reference != null && (string2 = this.refMap.remove(reference)) != null) {
            if (SysProperties.CHECK && string != null && !string2.equals(string)) {
                DbException.throwInternalError("f2:" + string2 + " f:" + string);
            }
            string = string2;
        }
        if (string != null && FileUtils.exists(string)) {
            try {
                IOUtils.trace("TempFileDeleter.deleteFile", string, null);
                FileUtils.tryDelete(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void deleteAll() {
        for (String string : New.arrayList(this.refMap.values())) {
            this.deleteFile(null, string);
        }
        this.deleteUnused();
    }

    public void deleteUnused() {
        Reference<Object> reference;
        while (this.queue != null && (reference = this.queue.poll()) != null) {
            this.deleteFile(reference, null);
        }
    }

    public void stopAutoDelete(Reference<?> reference, String string) {
        IOUtils.trace("TempFileDeleter.stopAutoDelete", string, reference);
        if (reference != null) {
            String string2 = this.refMap.remove(reference);
            if (SysProperties.CHECK && (string2 == null || !string2.equals(string))) {
                DbException.throwInternalError("f2:" + string2 + " " + (string2 == null ? "" : string2) + " f:" + string);
            }
        }
        this.deleteUnused();
    }
}

