/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.javax.mail;

import org.glowroot.shaded.javax.mail.BodyPart;
import org.glowroot.shaded.javax.mail.Message;
import org.glowroot.shaded.javax.mail.MessagingException;
import org.glowroot.shaded.javax.mail.Multipart;
import org.glowroot.shaded.javax.mail.Part;
import org.glowroot.shaded.javax.mail.Session;

public class MessageContext {
    private Part part;

    public MessageContext(Part part) {
        this.part = part;
    }

    public Part getPart() {
        return this.part;
    }

    public Message getMessage() {
        try {
            return MessageContext.getMessage(this.part);
        }
        catch (MessagingException ex) {
            return null;
        }
    }

    private static Message getMessage(Part p) throws MessagingException {
        while (p != null) {
            if (p instanceof Message) {
                return (Message)p;
            }
            BodyPart bp = (BodyPart)p;
            Multipart mp = bp.getParent();
            if (mp == null) {
                return null;
            }
            p = mp.getParent();
        }
        return null;
    }

    public Session getSession() {
        Message msg = this.getMessage();
        return msg != null ? msg.getSession() : null;
    }
}

