/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.netty.handler.ssl;

import java.util.LinkedHashSet;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.eclipse.jetty.alpn.ALPN;
import org.glowroot.shaded.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import org.glowroot.shaded.netty.handler.ssl.JdkSslEngine;
import org.glowroot.shaded.netty.util.internal.ObjectUtil;
import org.glowroot.shaded.netty.util.internal.PlatformDependent;

final class JdkAlpnSslEngine
extends JdkSslEngine {
    private static boolean available;

    static boolean isAvailable() {
        JdkAlpnSslEngine.updateAvailability();
        return available;
    }

    private static void updateAvailability() {
        if (available) {
            return;
        }
        try {
            Class.forName("sun.security.ssl.ALPNExtension", true, null);
            available = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    JdkAlpnSslEngine(SSLEngine engine, final JdkApplicationProtocolNegotiator applicationNegotiator, boolean server) {
        super(engine);
        ObjectUtil.checkNotNull(applicationNegotiator, "applicationNegotiator");
        if (server) {
            final JdkApplicationProtocolNegotiator.ProtocolSelector protocolSelector = ObjectUtil.checkNotNull(applicationNegotiator.protocolSelectorFactory().newSelector(this, new LinkedHashSet<String>(applicationNegotiator.protocols())), "protocolSelector");
            ALPN.put((SSLEngine)engine, (ALPN.Provider)new ALPN.ServerProvider(){

                public String select(List<String> protocols) {
                    try {
                        return protocolSelector.select(protocols);
                    }
                    catch (Throwable t) {
                        PlatformDependent.throwException(t);
                        return null;
                    }
                }

                public void unsupported() {
                    protocolSelector.unsupported();
                }
            });
        } else {
            final JdkApplicationProtocolNegotiator.ProtocolSelectionListener protocolListener = ObjectUtil.checkNotNull(applicationNegotiator.protocolListenerFactory().newListener(this, applicationNegotiator.protocols()), "protocolListener");
            ALPN.put((SSLEngine)engine, (ALPN.Provider)new ALPN.ClientProvider(){

                public List<String> protocols() {
                    return applicationNegotiator.protocols();
                }

                public void selected(String protocol) {
                    try {
                        protocolListener.selected(protocol);
                    }
                    catch (Throwable t) {
                        PlatformDependent.throwException(t);
                    }
                }

                public void unsupported() {
                    protocolListener.unsupported();
                }
            });
        }
    }

    @Override
    public void closeInbound() throws SSLException {
        ALPN.remove((SSLEngine)this.getWrappedEngine());
        super.closeInbound();
    }

    @Override
    public void closeOutbound() {
        ALPN.remove((SSLEngine)this.getWrappedEngine());
        super.closeOutbound();
    }
}

