/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.ning.compress.lzf.parallel;

import java.util.concurrent.Callable;
import org.glowroot.shaded.ning.compress.lzf.ChunkEncoder;
import org.glowroot.shaded.ning.compress.lzf.LZFChunk;
import org.glowroot.shaded.ning.compress.lzf.parallel.BlockManager;
import org.glowroot.shaded.ning.compress.lzf.util.ChunkEncoderFactory;

class CompressTask
implements Callable<LZFChunk> {
    private static final ThreadLocal<ChunkEncoder> ENCODER = new ThreadLocal<ChunkEncoder>(){

        @Override
        protected ChunkEncoder initialValue() {
            return ChunkEncoderFactory.optimalInstance();
        }
    };
    protected byte[] data;
    protected int offset;
    protected int length;
    protected BlockManager blockManager;

    public CompressTask(byte[] input, int offset, int length, BlockManager blockManager) {
        this.data = input;
        this.offset = offset;
        this.length = length;
        this.blockManager = blockManager;
    }

    public CompressTask(byte[] input, BlockManager blockManager) {
        this(input, 0, input.length, blockManager);
    }

    @Override
    public LZFChunk call() {
        if (this.data != null) {
            LZFChunk lzfChunk = ENCODER.get().encodeChunk(this.data, this.offset, this.length);
            this.blockManager.releaseBlockToPool(this.data);
            return lzfChunk;
        }
        ENCODER.remove();
        return null;
    }
}

