/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.ning.compress.lzf.parallel;

import java.io.OutputStream;
import java.util.concurrent.Future;
import org.glowroot.shaded.ning.compress.lzf.LZFChunk;
import org.glowroot.shaded.ning.compress.lzf.parallel.PLZFOutputStream;

class WriteTask
implements Runnable {
    private final OutputStream output;
    private final Future<LZFChunk> lzfFuture;
    private final PLZFOutputStream caller;

    public WriteTask(OutputStream output, Future<LZFChunk> lzfFuture, PLZFOutputStream caller) {
        this.output = output;
        this.lzfFuture = lzfFuture;
        this.caller = caller;
    }

    @Override
    public void run() {
        try {
            for (LZFChunk lzfChunk = this.lzfFuture.get(); lzfChunk != null; lzfChunk = lzfChunk.next()) {
                this.output.write(lzfChunk.getData());
            }
        }
        catch (Exception e) {
            this.caller.writeException = e;
        }
    }
}

