/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.qos.logback.classic;

import org.glowroot.shaded.qos.logback.classic.Logger;
import org.glowroot.shaded.qos.logback.classic.LoggerContext;
import org.glowroot.shaded.qos.logback.classic.encoder.PatternLayoutEncoder;
import org.glowroot.shaded.qos.logback.classic.spi.ILoggingEvent;
import org.glowroot.shaded.qos.logback.core.Appender;
import org.glowroot.shaded.qos.logback.core.ConsoleAppender;
import org.glowroot.shaded.qos.logback.core.status.InfoStatus;
import org.glowroot.shaded.qos.logback.core.status.StatusManager;
import org.glowroot.shaded.slf4j.LoggerFactory;

public class BasicConfigurator {
    static final BasicConfigurator hiddenSingleton = new BasicConfigurator();

    private BasicConfigurator() {
    }

    public static void configure(LoggerContext lc) {
        StatusManager sm = lc.getStatusManager();
        if (sm != null) {
            sm.add(new InfoStatus("Setting up default configuration.", lc));
        }
        ConsoleAppender<ILoggingEvent> ca = new ConsoleAppender<ILoggingEvent>();
        ca.setContext(lc);
        ca.setName("console");
        PatternLayoutEncoder pl = new PatternLayoutEncoder();
        pl.setContext(lc);
        pl.setPattern("%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n");
        pl.start();
        ca.setEncoder(pl);
        ca.start();
        Logger rootLogger = lc.getLogger("ROOT");
        rootLogger.addAppender((Appender<ILoggingEvent>)ca);
    }

    public static void configureDefaultContext() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        BasicConfigurator.configure(lc);
    }
}

