/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.qos.logback.classic.util;

import java.lang.reflect.Method;
import java.util.Iterator;
import org.glowroot.shaded.qos.logback.core.util.Loader;

public class EnvUtil {
    static ClassLoader testServiceLoaderClassLoader = null;
    private static final Method serviceLoaderLoadMethod;
    private static final Method serviceLoaderIteratorMethod;

    public static boolean isGroovyAvailable() {
        ClassLoader classLoader = Loader.getClassLoaderOfClass(EnvUtil.class);
        try {
            Class<?> bindingClass = classLoader.loadClass("groovy.lang.Binding");
            return bindingClass != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isServiceLoaderAvailable() {
        return serviceLoaderLoadMethod != null && serviceLoaderIteratorMethod != null;
    }

    private static ClassLoader getServiceLoaderClassLoader() {
        return testServiceLoaderClassLoader == null ? Loader.getClassLoaderOfClass(EnvUtil.class) : testServiceLoaderClassLoader;
    }

    public static <T> T loadFromServiceLoader(Class<T> c) {
        if (EnvUtil.isServiceLoaderAvailable()) {
            Iterator it;
            Object loader;
            try {
                loader = serviceLoaderLoadMethod.invoke(null, c, EnvUtil.getServiceLoaderClassLoader());
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot invoke java.util.ServiceLoader#load()", e);
            }
            try {
                it = (Iterator)serviceLoaderIteratorMethod.invoke(loader, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot invoke java.util.ServiceLoader#iterator()", e);
            }
            if (it.hasNext()) {
                return (T)it.next();
            }
        }
        return null;
    }

    static {
        Method tLoadMethod = null;
        Method tIteratorMethod = null;
        try {
            Class<?> clazz = Class.forName("java.util.ServiceLoader");
            tLoadMethod = clazz.getMethod("load", Class.class, ClassLoader.class);
            tIteratorMethod = clazz.getMethod("iterator", new Class[0]);
        }
        catch (ClassNotFoundException ce) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        serviceLoaderLoadMethod = tLoadMethod;
        serviceLoaderIteratorMethod = tIteratorMethod;
    }
}

