/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.shaded.qos.logback.core.rolling.helper;

import java.io.File;
import java.util.Date;
import org.glowroot.shaded.qos.logback.core.rolling.helper.DefaultArchiveRemover;
import org.glowroot.shaded.qos.logback.core.rolling.helper.FileNamePattern;
import org.glowroot.shaded.qos.logback.core.rolling.helper.RollingCalendar;

public class TimeBasedArchiveRemover
extends DefaultArchiveRemover {
    public TimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rc) {
        super(fileNamePattern, rc);
    }

    @Override
    protected void cleanByPeriodOffset(Date now, int periodOffset) {
        Date fileLastModified;
        Date date2delete = this.rc.getRelativeDate(now, periodOffset);
        String filename = this.fileNamePattern.convert(date2delete);
        File file2Delete = new File(filename);
        if (file2Delete.exists() && file2Delete.isFile() && (fileLastModified = this.rc.getRelativeDate(new Date(file2Delete.lastModified()), -1)).compareTo(date2delete) <= 0) {
            this.addInfo("deleting " + file2Delete);
            file2Delete.delete();
            if (this.parentClean) {
                this.removeFolderIfEmpty(file2Delete.getParentFile());
            }
        }
    }

    public String toString() {
        return "c.q.l.core.rolling.helper.TimeBasedArchiveRemover";
    }
}

