/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.glowroot.config.ConfigService;
import org.glowroot.config.UserRecordingConfig;
import org.glowroot.transaction.UserProfileRunnable;
import org.glowroot.transaction.model.Transaction;

class UserProfileScheduler {
    private final ScheduledExecutorService scheduledExecutor;
    private final ConfigService configService;

    UserProfileScheduler(ScheduledExecutorService scheduledExecutor, ConfigService configService) {
        this.scheduledExecutor = scheduledExecutor;
        this.configService = configService;
    }

    void maybeScheduleUserProfiling(Transaction transaction, String user) {
        UserRecordingConfig userRecordingConfig = this.configService.getUserRecordingConfig();
        if (!userRecordingConfig.enabled()) {
            return;
        }
        if (!user.equalsIgnoreCase(userRecordingConfig.user())) {
            return;
        }
        int intervalMillis = userRecordingConfig.profileIntervalMillis();
        UserProfileRunnable userProfileRunnable = new UserProfileRunnable(transaction, this.configService);
        long initialDelay = Math.max(0L, (long)intervalMillis - TimeUnit.NANOSECONDS.toMillis(transaction.getDuration()));
        userProfileRunnable.scheduleWithFixedDelay(this.scheduledExecutor, initialDelay, intervalMillis, TimeUnit.MILLISECONDS);
        transaction.setUserProfileRunnable(userProfileRunnable);
    }
}

