/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction;

import org.glowroot.api.PluginServices;
import org.glowroot.api.TimerName;
import org.glowroot.api.weaving.Pointcut;
import org.glowroot.config.ConfigService;
import org.glowroot.transaction.TimerNameCache;
import org.glowroot.transaction.TransactionRegistry;
import org.glowroot.transaction.model.TimerImpl;
import org.glowroot.transaction.model.Transaction;
import org.glowroot.weaving.WeavingTimerService;

class WeavingTimerServiceImpl
implements WeavingTimerService {
    private final TransactionRegistry transactionRegistry;
    private final TimerName timerName;
    private volatile boolean enabled;

    WeavingTimerServiceImpl(TransactionRegistry transactionRegistry, final ConfigService configService, TimerNameCache timerNameCache) {
        this.transactionRegistry = transactionRegistry;
        configService.addConfigListener(new PluginServices.ConfigListener(){

            @Override
            public void onChange() {
                WeavingTimerServiceImpl.this.enabled = configService.getAdvancedConfig().weavingTimer();
            }
        });
        this.timerName = timerNameCache.getName(OnlyForTheTimerName.class);
    }

    @Override
    public WeavingTimerService.WeavingTimer start() {
        if (!this.enabled) {
            return NopWeavingTimer.INSTANCE;
        }
        Transaction transaction = this.transactionRegistry.getCurrentTransaction();
        if (transaction == null) {
            return NopWeavingTimer.INSTANCE;
        }
        TimerImpl currentTimer = transaction.getCurrentTimer();
        if (currentTimer == null) {
            return NopWeavingTimer.INSTANCE;
        }
        final TimerImpl timer = currentTimer.startNestedTimer(this.timerName);
        return new WeavingTimerService.WeavingTimer(){

            @Override
            public void stop() {
                timer.stop();
            }
        };
    }

    @Pointcut(className="", methodName="", methodParameterTypes={}, timerName="glowroot weaving")
    private static class OnlyForTheTimerName {
        private OnlyForTheTimerName() {
        }
    }

    private static class NopWeavingTimer
    implements WeavingTimerService.WeavingTimer {
        private static final NopWeavingTimer INSTANCE = new NopWeavingTimer();

        private NopWeavingTimer() {
        }

        @Override
        public void stop() {
        }
    }
}

