/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import org.glowroot.transaction.model.GcInfoComponent;

@ParametersAreNonnullByDefault
@Immutable
public final class GcInfo
extends GcInfoComponent.GcInfoBase {
    private final String name;
    private final long collectionCount;
    private final long collectionTime;

    private GcInfo(Builder builder) {
        this.name = builder.name;
        this.collectionCount = builder.collectionCount;
        this.collectionTime = builder.collectionTime;
    }

    private GcInfo(GcInfo original, String name, long collectionCount, long collectionTime) {
        this.name = name;
        this.collectionCount = collectionCount;
        this.collectionTime = collectionTime;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="collectionCount")
    public long collectionCount() {
        return this.collectionCount;
    }

    @Override
    @JsonProperty(value="collectionTime")
    public long collectionTime() {
        return this.collectionTime;
    }

    public final GcInfo withName(String value) {
        if (this.name == value) {
            return this;
        }
        String newValue = Preconditions.checkNotNull(value);
        return new GcInfo(this, newValue, this.collectionCount, this.collectionTime);
    }

    public final GcInfo withCollectionCount(long value) {
        if (this.collectionCount == value) {
            return this;
        }
        long newValue = value;
        return new GcInfo(this, this.name, newValue, this.collectionTime);
    }

    public final GcInfo withCollectionTime(long value) {
        if (this.collectionTime == value) {
            return this;
        }
        long newValue = value;
        return new GcInfo(this, this.name, this.collectionCount, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof GcInfo && this.equalTo((GcInfo)another);
    }

    private boolean equalTo(GcInfo another) {
        return this.name.equals(another.name) && this.collectionCount == another.collectionCount && this.collectionTime == another.collectionTime;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.name.hashCode();
        h = h * 17 + Longs.hashCode(this.collectionCount);
        h = h * 17 + Longs.hashCode(this.collectionTime);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("GcInfo").add("name", this.name).add("collectionCount", this.collectionCount).add("collectionTime", this.collectionTime).toString();
    }

    @JsonCreator
    public static GcInfo fromAllAttributes(@JsonProperty(value="name") @Nullable String name, @JsonProperty(value="collectionCount") @Nullable Long collectionCount, @JsonProperty(value="collectionTime") @Nullable Long collectionTime) {
        Builder builder = GcInfo.builder();
        if (name != null) {
            builder.name(name);
        }
        if (collectionCount != null) {
            builder.collectionCount(collectionCount);
        }
        if (collectionTime != null) {
            builder.collectionTime(collectionTime);
        }
        return builder.build();
    }

    public static GcInfo copyOf(GcInfoComponent.GcInfoBase instance) {
        if (instance instanceof GcInfo) {
            return (GcInfo)instance;
        }
        return GcInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 7L;
        private static final long INITIALIZED_BIT_NAME = 1L;
        private static final long INITIALIZED_BIT_COLLECTION_COUNT = 2L;
        private static final long INITIALIZED_BIT_COLLECTION_TIME = 4L;
        private long initializedBitset;
        @Nullable
        private String name;
        private long collectionCount;
        private long collectionTime;

        private Builder() {
        }

        public final Builder from(GcInfoComponent.GcInfoBase instance) {
            Preconditions.checkNotNull(instance);
            this.name(instance.name());
            this.collectionCount(instance.collectionCount());
            this.collectionTime(instance.collectionTime());
            return this;
        }

        public final Builder name(String name) {
            this.name = Preconditions.checkNotNull(name);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder collectionCount(long collectionCount) {
            this.collectionCount = collectionCount;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder collectionTime(long collectionTime) {
            this.collectionTime = collectionTime;
            this.initializedBitset |= 4L;
            return this;
        }

        public GcInfo build() {
            this.checkRequiredAttributes();
            return new GcInfo(this);
        }

        private boolean nameIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean collectionCountIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private boolean collectionTimeIsSet() {
            return (this.initializedBitset & 4L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 7L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.collectionCountIsSet()) {
                attributes.add("collectionCount");
            }
            if (!this.collectionTimeIsSet()) {
                attributes.add("collectionTime");
            }
            return "Cannot build GcInfo, some of required attributes are not set " + attributes;
        }
    }
}

