/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.shaded.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.collect.Maps;
import org.glowroot.shaded.google.common.collect.Sets;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.model.GcInfo;
import org.glowroot.transaction.model.GcSnapshot;
import org.immutables.value.Value;

class GcInfoComponent {
    private static final Logger logger = LoggerFactory.getLogger(GcInfoComponent.class);
    private final Map<String, GcSnapshot> startingSnapshots;
    @GuardedBy(value="lock")
    @MonotonicNonNull
    private volatile List<GcInfo> completedGcInfos;
    private final Object lock = new Object();

    GcInfoComponent() {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        this.startingSnapshots = Maps.newHashMap();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            GcSnapshot info = GcSnapshot.builder().collectionCount(gcBean.getCollectionCount()).collectionTime(gcBean.getCollectionTime()).build();
            this.startingSnapshots.put(gcBean.getName(), info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onComplete() {
        Object object = this.lock;
        synchronized (object) {
            this.completedGcInfos = this.getGcInfos();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<GcInfo> getGcInfos() {
        Object object = this.lock;
        synchronized (object) {
            if (this.completedGcInfos == null) {
                return this.getGcInfosInternal();
            }
            return this.completedGcInfos;
        }
    }

    private List<GcInfo> getGcInfosInternal() {
        HashSet<String> unmatchedNames = Sets.newHashSet(this.startingSnapshots.keySet());
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        ArrayList<GcInfo> gcInfos = Lists.newArrayList();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            String name = gcBean.getName();
            GcSnapshot gcSnapshot = this.startingSnapshots.get(name);
            if (gcSnapshot == null) {
                logger.warn("garbage collector bean {} did not exist at start of trace", (Object)name);
                continue;
            }
            unmatchedNames.remove(name);
            long collectionCountEnd = gcBean.getCollectionCount();
            long collectionTimeEnd = gcBean.getCollectionTime();
            if (collectionCountEnd == gcSnapshot.collectionCount()) continue;
            gcInfos.add(GcInfo.builder().name(name).collectionCount(collectionCountEnd - gcSnapshot.collectionCount()).collectionTime(collectionTimeEnd - gcSnapshot.collectionTime()).build());
        }
        for (String unmatchedName : unmatchedNames) {
            logger.warn("garbage collector bean {} did not exist at end of trace", (Object)unmatchedName);
        }
        return gcInfos;
    }

    @JsonSerialize
    @Value.Immutable
    public static abstract class GcInfoBase {
        abstract String name();

        abstract long collectionCount();

        abstract long collectionTime();
    }

    @Value.Immutable
    static abstract class GcSnapshotBase {
        GcSnapshotBase() {
        }

        abstract long collectionCount();

        abstract long collectionTime();
    }
}

