/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nullable;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.fasterxml.jackson.core.JsonParser;
import org.glowroot.shaded.fasterxml.jackson.core.JsonToken;
import org.glowroot.shaded.fasterxml.jackson.core.SerializableString;
import org.glowroot.shaded.fasterxml.jackson.core.io.SerializedString;
import org.glowroot.shaded.fasterxml.jackson.databind.DeserializationContext;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonDeserializer;
import org.glowroot.shaded.fasterxml.jackson.databind.JsonSerializer;
import org.glowroot.shaded.fasterxml.jackson.databind.SerializerProvider;
import org.glowroot.shaded.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.glowroot.shaded.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.transaction.model.MatchedNodePair;
import org.glowroot.transaction.model.Traverser;
import org.immutables.value.Value;

@JsonSerialize(using=Serializer.class)
@JsonDeserialize(using=Deserializer.class)
public class ProfileNode {
    @Nullable
    private final String stackTraceElement;
    @Nullable
    private final String leafThreadState;
    private int sampleCount;
    private List<String> timerNames = Lists.newArrayList();
    private final List<ProfileNode> childNodes = Lists.newArrayListWithCapacity(2);
    private boolean ellipsed;

    public static ProfileNode createSyntheticRoot() {
        return new ProfileNode(null, null);
    }

    public static ProfileNode create(String stackTraceElement, @Nullable String leafThreadState) {
        return new ProfileNode(stackTraceElement, leafThreadState);
    }

    private ProfileNode(@Nullable String stackTraceElement, @Nullable String leafThreadState) {
        this.stackTraceElement = stackTraceElement;
        this.leafThreadState = leafThreadState;
    }

    public void addChildNode(ProfileNode node) {
        this.childNodes.add(node);
    }

    public void setTimerNames(List<String> timerNames) {
        this.timerNames = ImmutableList.copyOf(timerNames);
    }

    public void incrementSampleCount(int num) {
        this.sampleCount += num;
    }

    public void setEllipsed() {
        this.ellipsed = true;
    }

    @Nullable
    public String getStackTraceElement() {
        return this.stackTraceElement;
    }

    @Nullable
    public String getLeafThreadState() {
        return this.leafThreadState;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public List<String> getTimerNames() {
        return this.timerNames;
    }

    public List<ProfileNode> getChildNodes() {
        return this.childNodes;
    }

    public boolean isEllipsed() {
        return this.ellipsed;
    }

    public void mergeMatchedNode(ProfileNode anotherSyntheticRootNode) {
        Preconditions.checkState(this.stackTraceElement == null);
        ProfileNode.merge(this, anotherSyntheticRootNode);
    }

    private static void merge(ProfileNode leftRootNode, ProfileNode rightRootNode) {
        ArrayDeque<MatchedNodePair> stack = new ArrayDeque<MatchedNodePair>();
        stack.add(MatchedNodePair.of(leftRootNode, rightRootNode));
        while (!stack.isEmpty()) {
            MatchedNodePair matchedPair = (MatchedNodePair)stack.pop();
            ProfileNode leftNode = matchedPair.leftNode();
            ProfileNode rightNode = matchedPair.rightNode();
            ProfileNode.mergeNodeShallow(leftNode, rightNode);
            for (ProfileNode rightChildNode : rightNode.getChildNodes()) {
                ProfileNode matchingLeftChildNode = ProfileNode.findMatch(leftNode.childNodes, rightChildNode);
                if (matchingLeftChildNode == null) {
                    leftNode.addChildNode(rightChildNode);
                    continue;
                }
                stack.push(MatchedNodePair.of(matchingLeftChildNode, rightChildNode));
            }
        }
    }

    @Nullable
    private static ProfileNode findMatch(List<ProfileNode> leftChildNodes, ProfileNode rightChildNode) {
        for (ProfileNode leftChildNode : leftChildNodes) {
            if (!ProfileNode.matches(leftChildNode, rightChildNode)) continue;
            return leftChildNode;
        }
        return null;
    }

    private static void mergeNodeShallow(ProfileNode leftNode, ProfileNode rightNode) {
        leftNode.incrementSampleCount(rightNode.getSampleCount());
        List<String> timerNames = rightNode.getTimerNames();
        if (timerNames.size() > leftNode.timerNames.size()) {
            leftNode.timerNames = timerNames;
        }
    }

    private static boolean matches(ProfileNode leftNode, ProfileNode rightNode) {
        return Objects.equal(leftNode.getStackTraceElement(), rightNode.getStackTraceElement()) && Objects.equal(leftNode.getLeafThreadState(), rightNode.getLeafThreadState());
    }

    @Value.Immutable
    static abstract class MatchedNodePairBase {
        MatchedNodePairBase() {
        }

        abstract ProfileNode leftNode();

        abstract ProfileNode rightNode();
    }

    private static class ProfileReader {
        private static final SerializableString stackTraceElementName = new SerializedString("stackTraceElement");
        private final JsonParser parser;
        private final Deque<ProfileNode> stack = new ArrayDeque<ProfileNode>();

        private ProfileReader(JsonParser parser) {
            this.parser = parser;
        }

        public ProfileNode read() throws IOException {
            ProfileNode rootNode = null;
            while (true) {
                JsonToken token;
                if ((token = this.parser.getCurrentToken()) == JsonToken.END_ARRAY) {
                    Preconditions.checkState(this.parser.nextToken() == JsonToken.END_OBJECT);
                    this.stack.pop();
                    if (this.stack.isEmpty()) break;
                    this.parser.nextToken();
                    continue;
                }
                Preconditions.checkState(token == JsonToken.START_OBJECT);
                ProfileNode node = this.readNodeFields();
                ProfileNode parentNode = this.stack.peek();
                if (parentNode == null) {
                    rootNode = node;
                } else {
                    parentNode.addChildNode(node);
                }
                token = this.parser.getCurrentToken();
                if (token == JsonToken.FIELD_NAME && this.parser.getText().equals("childNodes")) {
                    Preconditions.checkState(this.parser.nextToken() == JsonToken.START_ARRAY);
                    this.parser.nextToken();
                    this.stack.push(node);
                    continue;
                }
                Preconditions.checkState(token == JsonToken.END_OBJECT);
                if (this.stack.isEmpty()) break;
                this.parser.nextToken();
            }
            Preconditions.checkNotNull(rootNode);
            return rootNode;
        }

        private ProfileNode readNodeFields() throws IOException {
            Preconditions.checkState(this.parser.nextFieldName(stackTraceElementName));
            String stackTraceElement = this.parser.nextTextValue();
            String leafThreadState = null;
            JsonToken token = this.parser.nextToken();
            if (token == JsonToken.FIELD_NAME && this.parser.getText().equals("leafThreadState")) {
                leafThreadState = this.parser.nextTextValue();
                token = this.parser.nextToken();
            }
            ProfileNode node = new ProfileNode(stackTraceElement, leafThreadState);
            if (token == JsonToken.FIELD_NAME && this.parser.getText().equals("sampleCount")) {
                node.sampleCount = this.parser.nextIntValue(0);
                token = this.parser.nextToken();
            }
            if (token == JsonToken.FIELD_NAME && this.parser.getText().equals("timerNames")) {
                Preconditions.checkState(this.parser.nextToken() == JsonToken.START_ARRAY);
                ArrayList<String> timerNames = Lists.newArrayList();
                while (this.parser.nextToken() != JsonToken.END_ARRAY) {
                    timerNames.add(this.parser.getText());
                }
                node.setTimerNames(timerNames);
                token = this.parser.nextToken();
            }
            return node;
        }
    }

    private static class ProfileWriter
    extends Traverser<ProfileNode> {
        private final JsonGenerator jg;

        private ProfileWriter(ProfileNode rootNode, JsonGenerator jg) throws IOException {
            super(rootNode);
            this.jg = jg;
        }

        private void write() throws IOException {
            this.traverse();
        }

        @Override
        List<ProfileNode> visit(ProfileNode node) throws IOException {
            List<ProfileNode> childNodes;
            boolean ellipsed;
            this.jg.writeStartObject();
            this.jg.writeStringField("stackTraceElement", node.getStackTraceElement());
            String leafThreadState = node.getLeafThreadState();
            if (leafThreadState != null) {
                this.jg.writeStringField("leafThreadState", leafThreadState);
            }
            this.jg.writeNumberField("sampleCount", node.getSampleCount());
            List<String> timerNames = node.getTimerNames();
            if (!timerNames.isEmpty()) {
                this.jg.writeArrayFieldStart("timerNames");
                for (String timerName : timerNames) {
                    this.jg.writeString(timerName);
                }
                this.jg.writeEndArray();
            }
            if (ellipsed = node.isEllipsed()) {
                this.jg.writeBooleanField("ellipsed", ellipsed);
            }
            if (!(childNodes = node.getChildNodes()).isEmpty()) {
                this.jg.writeArrayFieldStart("childNodes");
            }
            return childNodes;
        }

        @Override
        void revisitAfterChildren(ProfileNode node) throws IOException {
            List<ProfileNode> childNodes = node.getChildNodes();
            if (!childNodes.isEmpty()) {
                this.jg.writeEndArray();
            }
            this.jg.writeEndObject();
        }
    }

    static class Deserializer
    extends JsonDeserializer<ProfileNode> {
        Deserializer() {
        }

        @Override
        public ProfileNode deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return new ProfileReader(p).read();
        }
    }

    static class Serializer
    extends JsonSerializer<ProfileNode> {
        Serializer() {
        }

        @Override
        public void serialize(ProfileNode value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            new ProfileWriter(value, gen).write();
        }
    }
}

