/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.transaction.model.ThreadInfoComponent;

@ParametersAreNonnullByDefault
@Immutable
public final class ThreadInfoData
extends ThreadInfoComponent.ThreadInfoDataBase {
    @Nullable
    private final Long threadCpuTime;
    @Nullable
    private final Long threadBlockedTime;
    @Nullable
    private final Long threadWaitedTime;
    @Nullable
    private final Long threadAllocatedBytes;

    private ThreadInfoData(Builder builder) {
        this.threadCpuTime = builder.threadCpuTime;
        this.threadBlockedTime = builder.threadBlockedTime;
        this.threadWaitedTime = builder.threadWaitedTime;
        this.threadAllocatedBytes = builder.threadAllocatedBytes;
    }

    private ThreadInfoData(ThreadInfoData original, @Nullable Long threadCpuTime, @Nullable Long threadBlockedTime, @Nullable Long threadWaitedTime, @Nullable Long threadAllocatedBytes) {
        this.threadCpuTime = threadCpuTime;
        this.threadBlockedTime = threadBlockedTime;
        this.threadWaitedTime = threadWaitedTime;
        this.threadAllocatedBytes = threadAllocatedBytes;
    }

    @Override
    @Nullable
    public Long threadCpuTime() {
        return this.threadCpuTime;
    }

    @Override
    @Nullable
    public Long threadBlockedTime() {
        return this.threadBlockedTime;
    }

    @Override
    @Nullable
    public Long threadWaitedTime() {
        return this.threadWaitedTime;
    }

    @Override
    @Nullable
    public Long threadAllocatedBytes() {
        return this.threadAllocatedBytes;
    }

    public final ThreadInfoData withThreadCpuTime(@Nullable Long value) {
        if (this.threadCpuTime == value) {
            return this;
        }
        Long newValue = value;
        return new ThreadInfoData(this, newValue, this.threadBlockedTime, this.threadWaitedTime, this.threadAllocatedBytes);
    }

    public final ThreadInfoData withThreadBlockedTime(@Nullable Long value) {
        if (this.threadBlockedTime == value) {
            return this;
        }
        Long newValue = value;
        return new ThreadInfoData(this, this.threadCpuTime, newValue, this.threadWaitedTime, this.threadAllocatedBytes);
    }

    public final ThreadInfoData withThreadWaitedTime(@Nullable Long value) {
        if (this.threadWaitedTime == value) {
            return this;
        }
        Long newValue = value;
        return new ThreadInfoData(this, this.threadCpuTime, this.threadBlockedTime, newValue, this.threadAllocatedBytes);
    }

    public final ThreadInfoData withThreadAllocatedBytes(@Nullable Long value) {
        if (this.threadAllocatedBytes == value) {
            return this;
        }
        Long newValue = value;
        return new ThreadInfoData(this, this.threadCpuTime, this.threadBlockedTime, this.threadWaitedTime, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof ThreadInfoData && this.equalTo((ThreadInfoData)another);
    }

    private boolean equalTo(ThreadInfoData another) {
        return Objects.equal(this.threadCpuTime, another.threadCpuTime) && Objects.equal(this.threadBlockedTime, another.threadBlockedTime) && Objects.equal(this.threadWaitedTime, another.threadWaitedTime) && Objects.equal(this.threadAllocatedBytes, another.threadAllocatedBytes);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.threadCpuTime);
        h = h * 17 + Objects.hashCode(this.threadBlockedTime);
        h = h * 17 + Objects.hashCode(this.threadWaitedTime);
        h = h * 17 + Objects.hashCode(this.threadAllocatedBytes);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ThreadInfoData").add("threadCpuTime", this.threadCpuTime).add("threadBlockedTime", this.threadBlockedTime).add("threadWaitedTime", this.threadWaitedTime).add("threadAllocatedBytes", this.threadAllocatedBytes).toString();
    }

    public static ThreadInfoData copyOf(ThreadInfoComponent.ThreadInfoDataBase instance) {
        if (instance instanceof ThreadInfoData) {
            return (ThreadInfoData)instance;
        }
        return ThreadInfoData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Long threadCpuTime;
        @Nullable
        private Long threadBlockedTime;
        @Nullable
        private Long threadWaitedTime;
        @Nullable
        private Long threadAllocatedBytes;

        private Builder() {
        }

        public final Builder from(ThreadInfoComponent.ThreadInfoDataBase instance) {
            Long threadAllocatedBytesValue;
            Long threadWaitedTimeValue;
            Long threadBlockedTimeValue;
            Preconditions.checkNotNull(instance);
            Long threadCpuTimeValue = instance.threadCpuTime();
            if (threadCpuTimeValue != null) {
                this.threadCpuTime(threadCpuTimeValue);
            }
            if ((threadBlockedTimeValue = instance.threadBlockedTime()) != null) {
                this.threadBlockedTime(threadBlockedTimeValue);
            }
            if ((threadWaitedTimeValue = instance.threadWaitedTime()) != null) {
                this.threadWaitedTime(threadWaitedTimeValue);
            }
            if ((threadAllocatedBytesValue = instance.threadAllocatedBytes()) != null) {
                this.threadAllocatedBytes(threadAllocatedBytesValue);
            }
            return this;
        }

        public final Builder threadCpuTime(@Nullable Long threadCpuTime) {
            this.threadCpuTime = threadCpuTime;
            return this;
        }

        public final Builder threadBlockedTime(@Nullable Long threadBlockedTime) {
            this.threadBlockedTime = threadBlockedTime;
            return this;
        }

        public final Builder threadWaitedTime(@Nullable Long threadWaitedTime) {
            this.threadWaitedTime = threadWaitedTime;
            return this;
        }

        public final Builder threadAllocatedBytes(@Nullable Long threadAllocatedBytes) {
            this.threadAllocatedBytes = threadAllocatedBytes;
            return this;
        }

        public ThreadInfoData build() {
            return new ThreadInfoData(this);
        }
    }
}

