/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.glowroot.api.Timer;
import org.glowroot.api.TimerName;
import org.glowroot.common.Tickers;
import org.glowroot.shaded.fasterxml.jackson.core.JsonGenerator;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.model.NestedTimerMap;
import org.glowroot.transaction.model.TimerNameImpl;
import org.glowroot.transaction.model.Transaction;

public class TimerImpl
implements Timer {
    private static final Logger logger = LoggerFactory.getLogger(TimerImpl.class);
    private static final Ticker ticker = Tickers.getTicker();
    private final Transaction transaction;
    @Nullable
    private final TimerImpl parent;
    private final TimerNameImpl timerName;
    private long total;
    private long count;
    private long startTick;
    private int selfNestingLevel;
    @MonotonicNonNull
    private NestedTimerMap nestedTimers;
    @MonotonicNonNull
    private volatile List<TimerImpl> threadSafeNestedTimers;

    public static TimerImpl createRootTimer(Transaction transaction, TimerNameImpl timerName) {
        return new TimerImpl(transaction, null, timerName);
    }

    private TimerImpl(Transaction transaction, @Nullable TimerImpl parent, TimerNameImpl timerName) {
        this.timerName = timerName;
        this.parent = parent;
        this.transaction = transaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeValue(JsonGenerator jg) throws IOException {
        boolean active;
        jg.writeStartObject();
        jg.writeStringField("name", this.timerName.name());
        if (this.timerName.extended()) {
            jg.writeBooleanField("extended", true);
        }
        boolean bl = active = this.selfNestingLevel > 0;
        if (active) {
            long theTotal = this.total;
            long theStartTick = this.startTick;
            long curr = ticker.read() - theStartTick;
            if (theTotal == 0L) {
                jg.writeNumberField("total", curr);
                jg.writeNumberField("count", 1);
                jg.writeBooleanField("active", true);
            } else {
                jg.writeNumberField("total", theTotal + curr);
                jg.writeNumberField("count", this.count + 1L);
                jg.writeBooleanField("active", true);
            }
        } else {
            jg.writeNumberField("total", this.total);
            jg.writeNumberField("count", this.count);
        }
        if (this.threadSafeNestedTimers != null) {
            ImmutableList<TimerImpl> copyOfNestedTimers;
            List<TimerImpl> list = this.threadSafeNestedTimers;
            synchronized (list) {
                copyOfNestedTimers = ImmutableList.copyOf(this.threadSafeNestedTimers);
            }
            jg.writeArrayFieldStart("nestedTimers");
            for (TimerImpl nestedTimer : copyOfNestedTimers) {
                nestedTimer.writeValue(jg);
            }
            jg.writeEndArray();
        }
        jg.writeEndObject();
    }

    @Override
    public void stop() {
        if (--this.selfNestingLevel == 0) {
            this.endInternal(ticker.read());
        }
    }

    public void end(long endTick) {
        if (--this.selfNestingLevel == 0) {
            this.endInternal(endTick);
        }
    }

    public TimerNameImpl getTimerName() {
        return this.timerName;
    }

    public String getName() {
        return this.timerName.name();
    }

    public boolean isExtended() {
        return this.timerName.extended();
    }

    public long getTotal() {
        return this.total;
    }

    public long getCount() {
        return this.count;
    }

    public List<TimerImpl> getNestedTimers() {
        if (this.threadSafeNestedTimers == null) {
            return ImmutableList.of();
        }
        return this.threadSafeNestedTimers;
    }

    public TimerImpl startNestedTimer(TimerName timerName) {
        if (this.timerName == timerName) {
            ++this.selfNestingLevel;
            return this;
        }
        long nestedTimerStartTick = ticker.read();
        return this.startNestedTimerInternal(timerName, nestedTimerStartTick);
    }

    public TimerImpl startNestedTimer(TimerName timerName, long startTick) {
        if (this.timerName == timerName) {
            ++this.selfNestingLevel;
            return this;
        }
        return this.startNestedTimerInternal(timerName, startTick);
    }

    public TimerImpl extend() {
        TimerImpl currentTimer = this.transaction.getCurrentTimer();
        if (currentTimer == null) {
            logger.warn("extend() transaction currentTimer is null");
            return this;
        }
        if (currentTimer == this.parent) {
            --this.count;
            this.start(ticker.read());
            return this;
        }
        if (currentTimer == this) {
            ++this.selfNestingLevel;
            return this;
        }
        TimerNameImpl extendedTimer = this.timerName.extendedTimer();
        if (extendedTimer == null) {
            logger.warn("extend() should only be accessible to non-extended timers");
            return this;
        }
        return currentTimer.startNestedTimer(extendedTimer);
    }

    public TimerImpl extend(long startTick) {
        TimerImpl currentTimer = this.transaction.getCurrentTimer();
        if (currentTimer == null) {
            logger.warn("extend() transaction currentTimer is null");
            return this;
        }
        if (currentTimer == this.parent) {
            --this.count;
            this.start(startTick);
            return this;
        }
        if (currentTimer == this) {
            ++this.selfNestingLevel;
            return this;
        }
        TimerNameImpl extendedTimer = this.timerName.extendedTimer();
        if (extendedTimer == null) {
            logger.warn("extend() should only be accessible to non-extended timers");
            return this;
        }
        return currentTimer.startNestedTimer(extendedTimer);
    }

    void start(long startTick) {
        this.startTick = startTick;
        ++this.selfNestingLevel;
        this.transaction.setCurrentTimer(this);
    }

    Transaction getTransaction() {
        return this.transaction;
    }

    private void endInternal(long endTick) {
        this.total += endTick - this.startTick;
        ++this.count;
        this.transaction.setCurrentTimer(this.parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerImpl startNestedTimerInternal(TimerName timerName, long nestedTimerStartTick) {
        TimerNameImpl timerNameImpl;
        TimerImpl nestedTimer;
        if (this.nestedTimers == null) {
            this.nestedTimers = new NestedTimerMap();
        }
        if ((nestedTimer = this.nestedTimers.get(timerNameImpl = (TimerNameImpl)timerName)) != null) {
            nestedTimer.start(nestedTimerStartTick);
            return nestedTimer;
        }
        nestedTimer = new TimerImpl(this.transaction, this, timerNameImpl);
        nestedTimer.start(nestedTimerStartTick);
        this.nestedTimers.put(timerNameImpl, nestedTimer);
        if (this.threadSafeNestedTimers == null) {
            this.threadSafeNestedTimers = Lists.newArrayList();
        }
        List<TimerImpl> list = this.threadSafeNestedTimers;
        synchronized (list) {
            this.threadSafeNestedTimers.add(nestedTimer);
        }
        return nestedTimer;
    }
}

