/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.glowroot.api.ErrorMessage;
import org.glowroot.api.MessageSupplier;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.base.Ticker;
import org.glowroot.shaded.slf4j.Logger;
import org.glowroot.shaded.slf4j.LoggerFactory;
import org.glowroot.transaction.model.QueryData;
import org.glowroot.transaction.model.TimerImpl;
import org.glowroot.transaction.model.TraceEntryImpl;

class TraceEntryComponent
implements Iterable<TraceEntryImpl> {
    private static final Logger logger = LoggerFactory.getLogger(TraceEntryComponent.class);
    private final long startTick;
    private boolean completed;
    private long endTick;
    private final TraceEntryImpl rootEntry;
    @Nullable
    private TraceEntryImpl activeEntry;
    private TraceEntryImpl tailEntry;
    private int entryCount;
    private boolean entryLimitExceeded;
    private final Ticker ticker;

    TraceEntryComponent(MessageSupplier messageSupplier, TimerImpl timer, long startTick, Ticker ticker) {
        this.startTick = startTick;
        this.ticker = ticker;
        this.activeEntry = this.rootEntry = new TraceEntryImpl(null, messageSupplier, null, 0L, startTick, -1, timer);
        this.tailEntry = this.rootEntry;
    }

    TraceEntryImpl getRootEntry() {
        return this.rootEntry;
    }

    @Override
    public Iterator<TraceEntryImpl> iterator() {
        return new TraceEntryIterator(this.rootEntry);
    }

    int getEntryCount() {
        return this.entryCount;
    }

    long getStartTick() {
        return this.startTick;
    }

    boolean isCompleted() {
        return this.completed;
    }

    long getEndTick() {
        return this.endTick;
    }

    long getDuration() {
        return this.completed ? this.endTick - this.startTick : this.ticker.read() - this.startTick;
    }

    TraceEntryImpl pushEntry(long startTick, MessageSupplier messageSupplier, @Nullable QueryData queryData, long queryExecutionCount, TimerImpl timer) {
        TraceEntryImpl entry = this.createEntry(startTick, messageSupplier, queryData, queryExecutionCount, null, timer, false);
        this.tailEntry.setNextTraceEntry(entry);
        this.tailEntry = entry;
        this.activeEntry = entry;
        ++this.entryCount;
        return entry;
    }

    void popEntry(TraceEntryImpl entry, long endTick) {
        this.popEntrySafe(entry);
        if (this.activeEntry == null) {
            this.endTick = endTick;
            this.completed = true;
        }
    }

    TraceEntryImpl addEntry(long startTick, long endTick, @Nullable MessageSupplier messageSupplier, @Nullable ErrorMessage errorMessage, boolean limitBypassed) {
        TraceEntryImpl entry = this.createEntry(startTick, messageSupplier, null, 1L, errorMessage, null, limitBypassed);
        this.tailEntry.setNextTraceEntry(entry);
        this.tailEntry = entry;
        ++this.entryCount;
        entry.setEndTick(endTick);
        return entry;
    }

    void addEntryLimitExceededMarkerIfNeeded() {
        if (this.entryLimitExceeded) {
            return;
        }
        this.entryLimitExceeded = true;
        TraceEntryImpl entry = TraceEntryImpl.getLimitExceededMarker();
        this.tailEntry.setNextTraceEntry(entry);
        this.tailEntry = entry;
        ++this.entryCount;
    }

    private TraceEntryImpl createEntry(long startTick, @Nullable MessageSupplier messageSupplier, @Nullable QueryData queryData, long queryExecutionCount, @Nullable ErrorMessage errorMessage, @Nullable TimerImpl timer, boolean limitBypassed) {
        int nestingLevel;
        if (this.entryLimitExceeded && !limitBypassed) {
            this.entryLimitExceeded = false;
            TraceEntryImpl entry = TraceEntryImpl.getLimitExtendedMarker();
            this.tailEntry.setNextTraceEntry(entry);
            this.tailEntry = entry;
            ++this.entryCount;
        }
        if (this.entryLimitExceeded && limitBypassed) {
            nestingLevel = 1;
        } else {
            Preconditions.checkNotNull(this.activeEntry);
            nestingLevel = this.activeEntry.getNestingLevel() + 1;
        }
        TraceEntryImpl entry = new TraceEntryImpl(this.activeEntry, messageSupplier, queryData, queryExecutionCount, startTick, nestingLevel, timer);
        entry.setErrorMessage(errorMessage);
        return entry;
    }

    private void popEntrySafe(TraceEntryImpl entry) {
        if (this.activeEntry == null) {
            logger.error("entry stack is empty, cannot pop entry: {}", (Object)entry);
            return;
        }
        if (this.activeEntry == entry) {
            this.activeEntry = this.activeEntry.getParentTraceEntry();
        } else {
            this.popEntryBailout(entry);
        }
    }

    private void popEntryBailout(TraceEntryImpl expectingEntry) {
        logger.error("found entry {} at top of stack when expecting entry {}", (Object)this.activeEntry, (Object)expectingEntry);
        while (this.activeEntry != null && this.activeEntry != expectingEntry) {
            this.activeEntry = this.activeEntry.getParentTraceEntry();
        }
        if (this.activeEntry != null) {
            this.activeEntry = this.activeEntry.getParentTraceEntry();
        } else {
            logger.error("popped entire stack, never found entry: {}", (Object)expectingEntry);
        }
    }

    private static class TraceEntryIterator
    implements Iterator<TraceEntryImpl> {
        private TraceEntryImpl curr;

        private TraceEntryIterator(TraceEntryImpl rootEntry) {
            this.curr = rootEntry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TraceEntryImpl next() {
            TraceEntryImpl next = this.curr.getNextTraceEntry();
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.curr = next;
            return this.curr;
        }

        @Override
        public boolean hasNext() {
            return this.curr.getNextTraceEntry() != null;
        }
    }
}

