/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.transaction.model;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.glowroot.shaded.google.common.collect.Lists;

abstract class Traverser<T> {
    private static final Object ALREADY_TRAVERSED_MARKER = new Object();
    private final Deque<Object> stack = new ArrayDeque<Object>();

    Traverser(T root) {
        this.stack.push(root);
    }

    void traverse() throws IOException {
        while (!this.stack.isEmpty()) {
            Object popped = this.stack.pop();
            if (popped == ALREADY_TRAVERSED_MARKER) {
                this.revisitAfterChildren(this.stack.pop());
                continue;
            }
            Object unprocessed = popped;
            List<Object> childNodes = this.visit(unprocessed);
            if (childNodes.isEmpty()) {
                this.revisitAfterChildren(unprocessed);
                continue;
            }
            this.stack.push(unprocessed);
            this.stack.push(ALREADY_TRAVERSED_MARKER);
            for (Object childNode : Lists.reverse(childNodes)) {
                this.stack.push(childNode);
            }
        }
    }

    abstract List<T> visit(T var1) throws IOException;

    abstract void revisitAfterChildren(T var1) throws IOException;
}

