/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.weaving.AdviceBase;
import org.glowroot.weaving.ParameterKind;

@ParametersAreNonnullByDefault
@Immutable
final class AdviceParameter
extends AdviceBase.AdviceParameterBase {
    private final ParameterKind kind;
    private final Type type;

    private AdviceParameter(Builder builder) {
        this.kind = builder.kind;
        this.type = builder.type;
    }

    private AdviceParameter(AdviceParameter original, ParameterKind kind, Type type) {
        this.kind = kind;
        this.type = type;
    }

    @Override
    public ParameterKind kind() {
        return this.kind;
    }

    @Override
    public Type type() {
        return this.type;
    }

    public final AdviceParameter withKind(ParameterKind value) {
        if (this.kind == value) {
            return this;
        }
        ParameterKind newValue = Preconditions.checkNotNull(value);
        return new AdviceParameter(this, newValue, this.type);
    }

    public final AdviceParameter withType(Type value) {
        if (this.type == value) {
            return this;
        }
        Type newValue = Preconditions.checkNotNull(value);
        return new AdviceParameter(this, this.kind, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof AdviceParameter && this.equalTo((AdviceParameter)another);
    }

    private boolean equalTo(AdviceParameter another) {
        return this.kind.equals((Object)another.kind) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.kind.hashCode();
        h = h * 17 + this.type.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AdviceParameter").add("kind", (Object)this.kind).add("type", this.type).toString();
    }

    static AdviceParameter copyOf(AdviceBase.AdviceParameterBase instance) {
        if (instance instanceof AdviceParameter) {
            return (AdviceParameter)instance;
        }
        return AdviceParameter.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_KIND = 1L;
        private static final long INITIALIZED_BIT_TYPE = 2L;
        private long initializedBitset;
        @Nullable
        private ParameterKind kind;
        @Nullable
        private Type type;

        private Builder() {
        }

        public final Builder from(AdviceBase.AdviceParameterBase instance) {
            Preconditions.checkNotNull(instance);
            this.kind(instance.kind());
            this.type(instance.type());
            return this;
        }

        public final Builder kind(ParameterKind kind) {
            this.kind = Preconditions.checkNotNull(kind);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder type(Type type) {
            this.type = Preconditions.checkNotNull(type);
            this.initializedBitset |= 2L;
            return this;
        }

        public AdviceParameter build() {
            this.checkRequiredAttributes();
            return new AdviceParameter(this);
        }

        private boolean kindIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean typeIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.kindIsSet()) {
                attributes.add("kind");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build AdviceParameter, some of required attributes are not set " + attributes;
        }
    }
}

