/*
 * Decompiled with CFR 0.152.
 */
package org.glowroot.weaving;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.ImmutableSet;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.objectweb.asm.Type;
import org.glowroot.weaving.WeavingClassVisitor;

@ParametersAreNonnullByDefault
@Immutable
final class MethodMetaGroup
extends WeavingClassVisitor.MethodMetaGroupBase {
    private final Type returnType;
    private final ImmutableList<Type> parameterTypes;
    private final int uniqueNum;
    private final ImmutableSet<Type> methodMetaTypes;

    private MethodMetaGroup(Builder builder) {
        this.returnType = builder.returnType;
        this.parameterTypes = builder.parameterTypesBuilder.build();
        this.uniqueNum = builder.uniqueNum;
        this.methodMetaTypes = builder.methodMetaTypesBuilder.build();
    }

    private MethodMetaGroup(MethodMetaGroup original, Type returnType, ImmutableList<Type> parameterTypes, int uniqueNum, ImmutableSet<Type> methodMetaTypes) {
        this.returnType = returnType;
        this.parameterTypes = parameterTypes;
        this.uniqueNum = uniqueNum;
        this.methodMetaTypes = methodMetaTypes;
    }

    @Override
    public Type returnType() {
        return this.returnType;
    }

    @Override
    public ImmutableList<Type> parameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public int uniqueNum() {
        return this.uniqueNum;
    }

    @Override
    public ImmutableSet<Type> methodMetaTypes() {
        return this.methodMetaTypes;
    }

    public final MethodMetaGroup withReturnType(Type value) {
        if (this.returnType == value) {
            return this;
        }
        Type newValue = Preconditions.checkNotNull(value);
        return new MethodMetaGroup(this, newValue, this.parameterTypes, this.uniqueNum, this.methodMetaTypes);
    }

    public final MethodMetaGroup withParameterTypes(Type ... elements) {
        ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
        return new MethodMetaGroup(this, this.returnType, newValue, this.uniqueNum, this.methodMetaTypes);
    }

    public final MethodMetaGroup withParameterTypes(Iterable<? extends Type> elements) {
        if (this.parameterTypes == elements) {
            return this;
        }
        ImmutableList<Type> newValue = ImmutableList.copyOf(elements);
        return new MethodMetaGroup(this, this.returnType, newValue, this.uniqueNum, this.methodMetaTypes);
    }

    public final MethodMetaGroup withUniqueNum(int value) {
        if (this.uniqueNum == value) {
            return this;
        }
        int newValue = value;
        return new MethodMetaGroup(this, this.returnType, this.parameterTypes, newValue, this.methodMetaTypes);
    }

    public final MethodMetaGroup withMethodMetaTypes(Type ... elements) {
        ImmutableSet<Type> newValue = ImmutableSet.copyOf(elements);
        return new MethodMetaGroup(this, this.returnType, this.parameterTypes, this.uniqueNum, newValue);
    }

    public final MethodMetaGroup withMethodMetaTypes(Iterable<? extends Type> elements) {
        if (this.methodMetaTypes == elements) {
            return this;
        }
        ImmutableSet<Type> newValue = ImmutableSet.copyOf(elements);
        return new MethodMetaGroup(this, this.returnType, this.parameterTypes, this.uniqueNum, newValue);
    }

    public boolean equals(@Nullable Object another) {
        return this == another || another instanceof MethodMetaGroup && this.equalTo((MethodMetaGroup)another);
    }

    private boolean equalTo(MethodMetaGroup another) {
        return this.returnType.equals(another.returnType) && this.parameterTypes.equals(another.parameterTypes) && this.uniqueNum == another.uniqueNum && this.methodMetaTypes.equals(another.methodMetaTypes);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.returnType.hashCode();
        h = h * 17 + this.parameterTypes.hashCode();
        h = h * 17 + this.uniqueNum;
        h = h * 17 + this.methodMetaTypes.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper("MethodMetaGroup").add("returnType", this.returnType).add("parameterTypes", this.parameterTypes).add("uniqueNum", this.uniqueNum).add("methodMetaTypes", this.methodMetaTypes).toString();
    }

    static MethodMetaGroup copyOf(WeavingClassVisitor.MethodMetaGroupBase instance) {
        if (instance instanceof MethodMetaGroup) {
            return (MethodMetaGroup)instance;
        }
        return MethodMetaGroup.builder().from(instance).build();
    }

    static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    static final class Builder {
        private static final long INITIALIZED_BITSET_ALL = 3L;
        private static final long INITIALIZED_BIT_RETURN_TYPE = 1L;
        private static final long INITIALIZED_BIT_UNIQUE_NUM = 2L;
        private long initializedBitset;
        @Nullable
        private Type returnType;
        private ImmutableList.Builder<Type> parameterTypesBuilder = ImmutableList.builder();
        private int uniqueNum;
        private ImmutableSet.Builder<Type> methodMetaTypesBuilder = ImmutableSet.builder();

        private Builder() {
        }

        public final Builder from(WeavingClassVisitor.MethodMetaGroupBase instance) {
            Preconditions.checkNotNull(instance);
            this.returnType(instance.returnType());
            this.addAllParameterTypes(instance.parameterTypes());
            this.uniqueNum(instance.uniqueNum());
            this.addAllMethodMetaTypes(instance.methodMetaTypes());
            return this;
        }

        public final Builder returnType(Type returnType) {
            this.returnType = Preconditions.checkNotNull(returnType);
            this.initializedBitset |= 1L;
            return this;
        }

        public final Builder addParameterTypes(Type element) {
            this.parameterTypesBuilder.add((Object)element);
            return this;
        }

        public final Builder addParameterTypes(Type ... elements) {
            this.parameterTypesBuilder.add(elements);
            return this;
        }

        public final Builder parameterTypes(Iterable<? extends Type> elements) {
            this.parameterTypesBuilder = ImmutableList.builder();
            return this.addAllParameterTypes(elements);
        }

        public final Builder addAllParameterTypes(Iterable<? extends Type> elements) {
            this.parameterTypesBuilder.addAll(elements);
            return this;
        }

        public final Builder uniqueNum(int uniqueNum) {
            this.uniqueNum = uniqueNum;
            this.initializedBitset |= 2L;
            return this;
        }

        public final Builder addMethodMetaTypes(Type element) {
            this.methodMetaTypesBuilder.add((Object)element);
            return this;
        }

        public final Builder addMethodMetaTypes(Type ... elements) {
            this.methodMetaTypesBuilder.add(elements);
            return this;
        }

        public final Builder methodMetaTypes(Iterable<? extends Type> elements) {
            this.methodMetaTypesBuilder = ImmutableSet.builder();
            return this.addAllMethodMetaTypes(elements);
        }

        public final Builder addAllMethodMetaTypes(Iterable<? extends Type> elements) {
            this.methodMetaTypesBuilder.addAll(elements);
            return this;
        }

        public MethodMetaGroup build() {
            this.checkRequiredAttributes();
            return new MethodMetaGroup(this);
        }

        private boolean returnTypeIsSet() {
            return (this.initializedBitset & 1L) != 0L;
        }

        private boolean uniqueNumIsSet() {
            return (this.initializedBitset & 2L) != 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initializedBitset != 3L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = Lists.newArrayList();
            if (!this.returnTypeIsSet()) {
                attributes.add("returnType");
            }
            if (!this.uniqueNumIsSet()) {
                attributes.add("uniqueNum");
            }
            return "Cannot build MethodMetaGroup, some of required attributes are not set " + attributes;
        }
    }
}

