package org.glowroot.collector;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ErrorSummaryBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ErrorSummary.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ErrorSummaryBase"})
@Immutable
public final class ErrorSummary extends ErrorSummaryBase {
  private final @Nullable String transactionName;
  private final long errorCount;
  private final long transactionCount;

  private ErrorSummary(@Nullable String transactionName, long errorCount, long transactionCount) {
    this.transactionName = transactionName;
    this.errorCount = errorCount;
    this.transactionCount = transactionCount;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionName} attribute
   */
  @JsonProperty("transactionName")
  @Override
  public String transactionName() {
    return transactionName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code errorCount} attribute
   */
  @JsonProperty("errorCount")
  @Override
  public long errorCount() {
    return errorCount;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionCount} attribute
   */
  @JsonProperty("transactionCount")
  @Override
  public long transactionCount() {
    return transactionCount;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorSummaryBase#transactionName() transactionName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionName, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final ErrorSummary withTransactionName(@Nullable String value) {
    if (this.transactionName == value) {
      return this;
    }
    @Nullable String newValue = value;
    return new ErrorSummary(newValue, this.errorCount, this.transactionCount);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorSummaryBase#errorCount() errorCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for errorCount
   * @return modified copy of the {@code this} object
   */
  public final ErrorSummary withErrorCount(long value) {
    if (this.errorCount == value) {
      return this;
    }
    long newValue = value;
    return new ErrorSummary(this.transactionName, newValue, this.transactionCount);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorSummaryBase#transactionCount() transactionCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionCount
   * @return modified copy of the {@code this} object
   */
  public final ErrorSummary withTransactionCount(long value) {
    if (this.transactionCount == value) {
      return this;
    }
    long newValue = value;
    return new ErrorSummary(this.transactionName, this.errorCount, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ErrorSummary} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ErrorSummary && equalTo((ErrorSummary) another));
  }
  
  private boolean equalTo(ErrorSummary another) {
    return Objects.equal(transactionName, another.transactionName)
        && errorCount == another.errorCount
        && transactionCount == another.transactionCount;
  }
  
  /**
   * Computes hash code from attributes: {@code transactionName}, {@code errorCount}, {@code transactionCount}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(transactionName);
    h = h * 17 + Longs.hashCode(errorCount);
    h = h * 17 + Longs.hashCode(transactionCount);
    return h;
  }
  
  /**
   * Prints immutable value {@code ErrorSummary{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ErrorSummary")
        .add("transactionName", transactionName)
        .add("errorCount", errorCount)
        .add("transactionCount", transactionCount)
        .toString();
  }
  
  @JsonCreator
  public static ErrorSummary fromAllAttributes(
      @JsonProperty("transactionName") @Nullable String transactionName,
      @JsonProperty("errorCount") @Nullable Long errorCount,
      @JsonProperty("transactionCount") @Nullable Long transactionCount) {
    ErrorSummary.Builder builder = ErrorSummary.builder();
    if (transactionName != null) {
      builder.transactionName(transactionName);
    }
    if (errorCount != null) {
      builder.errorCount(errorCount);
    }
    if (transactionCount != null) {
      builder.transactionCount(transactionCount);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ErrorSummaryBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable ErrorSummary instance
   */
  public static ErrorSummary copyOf(ErrorSummaryBase instance) {
    if (instance instanceof ErrorSummary) {
      return (ErrorSummary) instance;
    }
    return ErrorSummary.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.collector.ErrorSummary}.
   * @return new ErrorSummary builder
   */
  public static ErrorSummary.Builder builder() {
    return new ErrorSummary.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.collector.ErrorSummary}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_ERROR_COUNT = 0x1L;
    private static final long INITIALIZED_BIT_TRANSACTION_COUNT = 0x2L;
    private long initializedBitset;
  
    private @Nullable String transactionName;
    private long errorCount;
    private long transactionCount;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link ErrorSummaryBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(ErrorSummaryBase instance) {
      Preconditions.checkNotNull(instance);
      @Nullable String transactionNameValue = instance.transactionName();
      if (transactionNameValue != null) {
        transactionName(transactionNameValue);
      }
      errorCount(instance.errorCount());
      transactionCount(instance.transactionCount());
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorSummaryBase#transactionName() transactionName}.
     * @param transactionName value for transactionName, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionName(@Nullable String transactionName) {
      this.transactionName = transactionName;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorSummaryBase#errorCount() errorCount}.
     * @param errorCount value for errorCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder errorCount(long errorCount) {
      this.errorCount = errorCount;
      initializedBitset |= INITIALIZED_BIT_ERROR_COUNT;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorSummaryBase#transactionCount() transactionCount}.
     * @param transactionCount value for transactionCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionCount(long transactionCount) {
      this.transactionCount = transactionCount;
      initializedBitset |= INITIALIZED_BIT_TRANSACTION_COUNT;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.collector.ErrorSummary}.
     * @return immutable instance of ErrorSummary
     */
    public ErrorSummary build() {
      checkRequiredAttributes();
      return new ErrorSummary(transactionName, errorCount, transactionCount);
    }
  
    private boolean errorCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ERROR_COUNT) != 0;
    }
  
    private boolean transactionCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRANSACTION_COUNT) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!errorCountIsSet()) {
        attributes.add("errorCount");
      }
      if (!transactionCountIsSet()) {
        attributes.add("transactionCount");
      }
      return "Cannot build ErrorSummary, some of required attributes are not set " + attributes;
    }
  }
}
