package org.glowroot.collector;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Doubles;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link GaugePointBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code GaugePoint.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "GaugePointBase"})
@Immutable
public final class GaugePoint extends GaugePointBase {
  private final String gaugeName;
  private final @Nullable Boolean everIncreasing;
  private final long captureTime;
  private final double value;

  private GaugePoint(
      String gaugeName,
      @Nullable Boolean everIncreasing,
      long captureTime,
      double value) {
    this.gaugeName = gaugeName;
    this.everIncreasing = everIncreasing;
    this.captureTime = captureTime;
    this.value = value;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code gaugeName} attribute
   */
  @Override
  public String gaugeName() {
    return gaugeName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code everIncreasing} attribute
   */
  @Override
  public Boolean everIncreasing() {
    return everIncreasing;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code captureTime} attribute
   */
  @Override
  public long captureTime() {
    return captureTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code value} attribute
   */
  @Override
  public double value() {
    return value;
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugePointBase#gaugeName() gaugeName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for gaugeName
   * @return modified copy of the {@code this} object
   */
  public final GaugePoint withGaugeName(String value) {
    if (this.gaugeName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new GaugePoint(newValue, this.everIncreasing, this.captureTime, this.value);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugePointBase#everIncreasing() everIncreasing}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for everIncreasing, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final GaugePoint withEverIncreasing(@Nullable Boolean value) {
    if (this.everIncreasing == value) {
      return this;
    }
    @Nullable Boolean newValue = value;
    return new GaugePoint(this.gaugeName, newValue, this.captureTime, this.value);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugePointBase#captureTime() captureTime}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for captureTime
   * @return modified copy of the {@code this} object
   */
  public final GaugePoint withCaptureTime(long value) {
    if (this.captureTime == value) {
      return this;
    }
    long newValue = value;
    return new GaugePoint(this.gaugeName, this.everIncreasing, newValue, this.value);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugePointBase#value() value}.
   * @param value new value for value
   * @return modified copy of the {@code this} object
   */
  public final GaugePoint withValue(double value) {
    double newValue = value;
    return new GaugePoint(this.gaugeName, this.everIncreasing, this.captureTime, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code GaugePoint} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof GaugePoint && equalTo((GaugePoint) another));
  }
  
  private boolean equalTo(GaugePoint another) {
    return gaugeName.equals(another.gaugeName)
        && Objects.equal(everIncreasing, another.everIncreasing)
        && captureTime == another.captureTime
        && Double.doubleToLongBits(value) == Double.doubleToLongBits(another.value);
  }
  
  /**
   * Computes hash code from attributes: {@code gaugeName}, {@code everIncreasing}, {@code captureTime}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + gaugeName.hashCode();
    h = h * 17 + Objects.hashCode(everIncreasing);
    h = h * 17 + Longs.hashCode(captureTime);
    h = h * 17 + Doubles.hashCode(value);
    return h;
  }
  
  /**
   * Prints immutable value {@code GaugePoint{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GaugePoint")
        .add("gaugeName", gaugeName)
        .add("everIncreasing", everIncreasing)
        .add("captureTime", captureTime)
        .add("value", value)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link GaugePointBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable GaugePoint instance
   */
  public static GaugePoint copyOf(GaugePointBase instance) {
    if (instance instanceof GaugePoint) {
      return (GaugePoint) instance;
    }
    return GaugePoint.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.collector.GaugePoint}.
   * @return new GaugePoint builder
   */
  public static GaugePoint.Builder builder() {
    return new GaugePoint.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.collector.GaugePoint}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_GAUGE_NAME = 0x1L;
    private static final long INITIALIZED_BIT_CAPTURE_TIME = 0x2L;
    private static final long INITIALIZED_BIT_VALUE = 0x4L;
    private long initializedBitset;
  
    private @Nullable String gaugeName;
    private @Nullable Boolean everIncreasing;
    private long captureTime;
    private double value;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link GaugePointBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(GaugePointBase instance) {
      Preconditions.checkNotNull(instance);
      gaugeName(instance.gaugeName());
      @Nullable Boolean everIncreasingValue = instance.everIncreasing();
      if (everIncreasingValue != null) {
        everIncreasing(everIncreasingValue);
      }
      captureTime(instance.captureTime());
      value(instance.value());
      return this;
    }
  
    /**
     * Initializes value for {@link GaugePointBase#gaugeName() gaugeName}.
     * @param gaugeName value for gaugeName
     * @return {@code this} builder for chained invocation
     */
    public final Builder gaugeName(String gaugeName) {
      this.gaugeName = Preconditions.checkNotNull(gaugeName);
      initializedBitset |= INITIALIZED_BIT_GAUGE_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link GaugePointBase#everIncreasing() everIncreasing}.
     * @param everIncreasing value for everIncreasing, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder everIncreasing(@Nullable Boolean everIncreasing) {
      this.everIncreasing = everIncreasing;
      return this;
    }
  
    /**
     * Initializes value for {@link GaugePointBase#captureTime() captureTime}.
     * @param captureTime value for captureTime
     * @return {@code this} builder for chained invocation
     */
    public final Builder captureTime(long captureTime) {
      this.captureTime = captureTime;
      initializedBitset |= INITIALIZED_BIT_CAPTURE_TIME;
      return this;
    }
  
    /**
     * Initializes value for {@link GaugePointBase#value() value}.
     * @param value value for value
     * @return {@code this} builder for chained invocation
     */
    public final Builder value(double value) {
      this.value = value;
      initializedBitset |= INITIALIZED_BIT_VALUE;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.collector.GaugePoint}.
     * @return immutable instance of GaugePoint
     */
    public GaugePoint build() {
      checkRequiredAttributes();
      return new GaugePoint(gaugeName, everIncreasing, captureTime, value);
    }
  
    private boolean gaugeNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_GAUGE_NAME) != 0;
    }
  
    private boolean captureTimeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CAPTURE_TIME) != 0;
    }
  
    private boolean valueIsSet() {
      return (initializedBitset & INITIALIZED_BIT_VALUE) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!gaugeNameIsSet()) {
        attributes.add("gaugeName");
      }
      if (!captureTimeIsSet()) {
        attributes.add("captureTime");
      }
      if (!valueIsSet()) {
        attributes.add("value");
      }
      return "Cannot build GaugePoint, some of required attributes are not set " + attributes;
    }
  }
}
