package org.glowroot.collector;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonRawValue;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.io.CharSource;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link QueryAggregateBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code QueryAggregate.builder()}.
 * Use static factory method to create immutable instances:
 * {@code QueryAggregate.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "QueryAggregateBase"})
@Immutable
public final class QueryAggregate extends QueryAggregateBase {
  private final long captureTime;
  private final CharSource queries;

  private QueryAggregate(long captureTime, CharSource queries) {
    this.captureTime = captureTime;
    this.queries = queries;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code captureTime} attribute
   */
  @Override
  public long captureTime() {
    return captureTime;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code queries} attribute
   */
  @JsonRawValue
  @Override
  public CharSource queries() {
    return queries;
  }
  
  /**
   * Copy current immutable object by setting value for {@link QueryAggregateBase#captureTime() captureTime}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for captureTime
   * @return modified copy of the {@code this} object
   */
  public final QueryAggregate withCaptureTime(long value) {
    if (this.captureTime == value) {
      return this;
    }
    long newValue = value;
    return new QueryAggregate(newValue, this.queries);
  }
  
  /**
   * Copy current immutable object by setting value for {@link QueryAggregateBase#queries() queries}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for queries
   * @return modified copy of the {@code this} object
   */
  public final QueryAggregate withQueries(CharSource value) {
    if (this.queries == value) {
      return this;
    }
    CharSource newValue = Preconditions.checkNotNull(value);
    return new QueryAggregate(this.captureTime, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code QueryAggregate} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof QueryAggregate && equalTo((QueryAggregate) another));
  }
  
  private boolean equalTo(QueryAggregate another) {
    return captureTime == another.captureTime
        && queries.equals(another.queries);
  }
  
  /**
   * Computes hash code from attributes: {@code captureTime}, {@code queries}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(captureTime);
    h = h * 17 + queries.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code QueryAggregate{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("QueryAggregate")
        .add("captureTime", captureTime)
        .add("queries", queries)
        .toString();
  }

  /**
   * Construct new immutable {@code QueryAggregate} instance.
   * @param captureTime value for {@code captureTime}
   * @param queries value for {@code queries}
   * @return immutable QueryAggregate instance
   */
  public static org.glowroot.collector.QueryAggregate of(long captureTime, CharSource queries) {
    return new QueryAggregate(captureTime, queries);
  }
  
  /**
   * Creates immutable copy of {@link QueryAggregateBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable QueryAggregate instance
   */
  public static QueryAggregate copyOf(QueryAggregateBase instance) {
    if (instance instanceof QueryAggregate) {
      return (QueryAggregate) instance;
    }
    return QueryAggregate.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.collector.QueryAggregate}.
   * @return new QueryAggregate builder
   */
  public static QueryAggregate.Builder builder() {
    return new QueryAggregate.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.collector.QueryAggregate}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_CAPTURE_TIME = 0x1L;
    private static final long INITIALIZED_BIT_QUERIES = 0x2L;
    private long initializedBitset;
  
    private long captureTime;
    private @Nullable CharSource queries;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link QueryAggregateBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(QueryAggregateBase instance) {
      Preconditions.checkNotNull(instance);
      captureTime(instance.captureTime());
      queries(instance.queries());
      return this;
    }
  
    /**
     * Initializes value for {@link QueryAggregateBase#captureTime() captureTime}.
     * @param captureTime value for captureTime
     * @return {@code this} builder for chained invocation
     */
    public final Builder captureTime(long captureTime) {
      this.captureTime = captureTime;
      initializedBitset |= INITIALIZED_BIT_CAPTURE_TIME;
      return this;
    }
  
    /**
     * Initializes value for {@link QueryAggregateBase#queries() queries}.
     * @param queries value for queries
     * @return {@code this} builder for chained invocation
     */
    public final Builder queries(CharSource queries) {
      this.queries = Preconditions.checkNotNull(queries);
      initializedBitset |= INITIALIZED_BIT_QUERIES;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.collector.QueryAggregate}.
     * @return immutable instance of QueryAggregate
     */
    public QueryAggregate build() {
      checkRequiredAttributes();
      return new QueryAggregate(captureTime, queries);
    }
  
    private boolean captureTimeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_CAPTURE_TIME) != 0;
    }
  
    private boolean queriesIsSet() {
      return (initializedBitset & INITIALIZED_BIT_QUERIES) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!captureTimeIsSet()) {
        attributes.add("captureTime");
      }
      if (!queriesIsSet()) {
        attributes.add("queries");
      }
      return "Cannot build QueryAggregate, some of required attributes are not set " + attributes;
    }
  }
}
