package org.glowroot.config;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Doubles;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AlertConfigBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code AlertConfig.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AlertConfigBase"})
@Immutable
public final class AlertConfig extends AlertConfigBase {
  private final String transactionType;
  private final double percentile;
  private final int timePeriodMinutes;
  private final int thresholdMillis;
  private final int minTransactionCount;
  private final ImmutableList<String> emailAddresses;
  private final String version;

  private AlertConfig(
      String transactionType,
      double percentile,
      int timePeriodMinutes,
      int thresholdMillis,
      int minTransactionCount,
      ImmutableList<String> emailAddresses) {
    this.transactionType = transactionType;
    this.percentile = percentile;
    this.timePeriodMinutes = timePeriodMinutes;
    this.thresholdMillis = thresholdMillis;
    this.minTransactionCount = minTransactionCount;
    this.emailAddresses = emailAddresses;
    this.version = Preconditions.checkNotNull(super.version());
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionType} attribute
   */
  @JsonProperty("transactionType")
  @Override
  public String transactionType() {
    return transactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code percentile} attribute
   */
  @JsonProperty("percentile")
  @Override
  public double percentile() {
    return percentile;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code timePeriodMinutes} attribute
   */
  @JsonProperty("timePeriodMinutes")
  @Override
  public int timePeriodMinutes() {
    return timePeriodMinutes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code thresholdMillis} attribute
   */
  @JsonProperty("thresholdMillis")
  @Override
  public int thresholdMillis() {
    return thresholdMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code minTransactionCount} attribute
   */
  @JsonProperty("minTransactionCount")
  @Override
  public int minTransactionCount() {
    return minTransactionCount;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code emailAddresses} attribute
   */
  @JsonProperty("emailAddresses")
  @Override
  public ImmutableList<String> emailAddresses() {
    return emailAddresses;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code version} attribute
   */
  @JsonIgnore
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link AlertConfigBase#transactionType() transactionType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionType
   * @return modified copy of the {@code this} object
   */
  public final AlertConfig withTransactionType(String value) {
    if (this.transactionType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new AlertConfig(
        newValue,
        this.percentile,
        this.timePeriodMinutes,
        this.thresholdMillis,
        this.minTransactionCount,
        this.emailAddresses);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AlertConfigBase#percentile() percentile}.
   * @param value new value for percentile
   * @return modified copy of the {@code this} object
   */
  public final AlertConfig withPercentile(double value) {
    double newValue = value;
    return new AlertConfig(
        this.transactionType,
        newValue,
        this.timePeriodMinutes,
        this.thresholdMillis,
        this.minTransactionCount,
        this.emailAddresses);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AlertConfigBase#timePeriodMinutes() timePeriodMinutes}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for timePeriodMinutes
   * @return modified copy of the {@code this} object
   */
  public final AlertConfig withTimePeriodMinutes(int value) {
    if (this.timePeriodMinutes == value) {
      return this;
    }
    int newValue = value;
    return new AlertConfig(
        this.transactionType,
        this.percentile,
        newValue,
        this.thresholdMillis,
        this.minTransactionCount,
        this.emailAddresses);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AlertConfigBase#thresholdMillis() thresholdMillis}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for thresholdMillis
   * @return modified copy of the {@code this} object
   */
  public final AlertConfig withThresholdMillis(int value) {
    if (this.thresholdMillis == value) {
      return this;
    }
    int newValue = value;
    return new AlertConfig(
        this.transactionType,
        this.percentile,
        this.timePeriodMinutes,
        newValue,
        this.minTransactionCount,
        this.emailAddresses);
  }
  
  /**
   * Copy current immutable object by setting value for {@link AlertConfigBase#minTransactionCount() minTransactionCount}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for minTransactionCount
   * @return modified copy of the {@code this} object
   */
  public final AlertConfig withMinTransactionCount(int value) {
    if (this.minTransactionCount == value) {
      return this;
    }
    int newValue = value;
    return new AlertConfig(
        this.transactionType,
        this.percentile,
        this.timePeriodMinutes,
        this.thresholdMillis,
        newValue,
        this.emailAddresses);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AlertConfigBase#emailAddresses() emailAddresses}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final AlertConfig withEmailAddresses(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new AlertConfig(
        this.transactionType,
        this.percentile,
        this.timePeriodMinutes,
        this.thresholdMillis,
        this.minTransactionCount,
        newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link AlertConfigBase#emailAddresses() emailAddresses}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of emailAddresses elements to set
   * @return modified copy of {@code this} object
   */
  public final AlertConfig withEmailAddresses(Iterable<String> elements) {
    if (this.emailAddresses == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new AlertConfig(
        this.transactionType,
        this.percentile,
        this.timePeriodMinutes,
        this.thresholdMillis,
        this.minTransactionCount,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code AlertConfig} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof AlertConfig && equalTo((AlertConfig) another));
  }
  
  private boolean equalTo(AlertConfig another) {
    return transactionType.equals(another.transactionType)
        && Double.doubleToLongBits(percentile) == Double.doubleToLongBits(another.percentile)
        && timePeriodMinutes == another.timePeriodMinutes
        && thresholdMillis == another.thresholdMillis
        && minTransactionCount == another.minTransactionCount
        && emailAddresses.equals(another.emailAddresses)
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code transactionType}, {@code percentile}, {@code timePeriodMinutes}, {@code thresholdMillis}, {@code minTransactionCount}, {@code emailAddresses}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + transactionType.hashCode();
    h = h * 17 + Doubles.hashCode(percentile);
    h = h * 17 + timePeriodMinutes;
    h = h * 17 + thresholdMillis;
    h = h * 17 + minTransactionCount;
    h = h * 17 + emailAddresses.hashCode();
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code AlertConfig{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AlertConfig")
        .add("transactionType", transactionType)
        .add("percentile", percentile)
        .add("timePeriodMinutes", timePeriodMinutes)
        .add("thresholdMillis", thresholdMillis)
        .add("minTransactionCount", minTransactionCount)
        .add("emailAddresses", emailAddresses)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static AlertConfig fromAllAttributes(
      @JsonProperty("transactionType") @Nullable String transactionType,
      @JsonProperty("percentile") @Nullable java.lang.Double percentile,
      @JsonProperty("timePeriodMinutes") @Nullable Integer timePeriodMinutes,
      @JsonProperty("thresholdMillis") @Nullable Integer thresholdMillis,
      @JsonProperty("minTransactionCount") @Nullable Integer minTransactionCount,
      @JsonProperty("emailAddresses") @Nullable ImmutableList<String> emailAddresses) {
    AlertConfig.Builder builder = AlertConfig.builder();
    if (transactionType != null) {
      builder.transactionType(transactionType);
    }
    if (percentile != null) {
      builder.percentile(percentile);
    }
    if (timePeriodMinutes != null) {
      builder.timePeriodMinutes(timePeriodMinutes);
    }
    if (thresholdMillis != null) {
      builder.thresholdMillis(thresholdMillis);
    }
    if (minTransactionCount != null) {
      builder.minTransactionCount(minTransactionCount);
    }
    if (emailAddresses != null) {
      builder.addAllEmailAddresses(emailAddresses);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link AlertConfigBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable AlertConfig instance
   */
  public static AlertConfig copyOf(AlertConfigBase instance) {
    if (instance instanceof AlertConfig) {
      return (AlertConfig) instance;
    }
    return AlertConfig.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.AlertConfig}.
   * @return new AlertConfig builder
   */
  public static AlertConfig.Builder builder() {
    return new AlertConfig.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.AlertConfig}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1f;
    private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 0x1L;
    private static final long INITIALIZED_BIT_PERCENTILE = 0x2L;
    private static final long INITIALIZED_BIT_TIME_PERIOD_MINUTES = 0x4L;
    private static final long INITIALIZED_BIT_THRESHOLD_MILLIS = 0x8L;
    private static final long INITIALIZED_BIT_MIN_TRANSACTION_COUNT = 0x10L;
    private long initializedBitset;
  
    private @Nullable String transactionType;
    private double percentile;
    private int timePeriodMinutes;
    private int thresholdMillis;
    private int minTransactionCount;
    private ImmutableList.Builder<String> emailAddressesBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link AlertConfigBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(AlertConfigBase instance) {
      Preconditions.checkNotNull(instance);
      transactionType(instance.transactionType());
      percentile(instance.percentile());
      timePeriodMinutes(instance.timePeriodMinutes());
      thresholdMillis(instance.thresholdMillis());
      minTransactionCount(instance.minTransactionCount());
      addAllEmailAddresses(instance.emailAddresses());
      return this;
    }
  
    /**
     * Initializes value for {@link AlertConfigBase#transactionType() transactionType}.
     * @param transactionType value for transactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionType(String transactionType) {
      this.transactionType = Preconditions.checkNotNull(transactionType);
      initializedBitset |= INITIALIZED_BIT_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link AlertConfigBase#percentile() percentile}.
     * @param percentile value for percentile
     * @return {@code this} builder for chained invocation
     */
    public final Builder percentile(double percentile) {
      this.percentile = percentile;
      initializedBitset |= INITIALIZED_BIT_PERCENTILE;
      return this;
    }
  
    /**
     * Initializes value for {@link AlertConfigBase#timePeriodMinutes() timePeriodMinutes}.
     * @param timePeriodMinutes value for timePeriodMinutes
     * @return {@code this} builder for chained invocation
     */
    public final Builder timePeriodMinutes(int timePeriodMinutes) {
      this.timePeriodMinutes = timePeriodMinutes;
      initializedBitset |= INITIALIZED_BIT_TIME_PERIOD_MINUTES;
      return this;
    }
  
    /**
     * Initializes value for {@link AlertConfigBase#thresholdMillis() thresholdMillis}.
     * @param thresholdMillis value for thresholdMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder thresholdMillis(int thresholdMillis) {
      this.thresholdMillis = thresholdMillis;
      initializedBitset |= INITIALIZED_BIT_THRESHOLD_MILLIS;
      return this;
    }
  
    /**
     * Initializes value for {@link AlertConfigBase#minTransactionCount() minTransactionCount}.
     * @param minTransactionCount value for minTransactionCount
     * @return {@code this} builder for chained invocation
     */
    public final Builder minTransactionCount(int minTransactionCount) {
      this.minTransactionCount = minTransactionCount;
      initializedBitset |= INITIALIZED_BIT_MIN_TRANSACTION_COUNT;
      return this;
    }
  
    /**
     * Adds one element to {@link AlertConfigBase#emailAddresses() emailAddresses} list.
     * @param element emailAddresses element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addEmailAddresses(String element) {
      emailAddressesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link AlertConfigBase#emailAddresses() emailAddresses} list.
     * @param elements array of emailAddresses elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addEmailAddresses(String... elements) {
      emailAddressesBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link AlertConfigBase#emailAddresses() emailAddresses} list.
     * @param elements iterable of emailAddresses elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder emailAddresses(Iterable<String> elements) {
      emailAddressesBuilder = ImmutableList.builder();
      return addAllEmailAddresses(elements);
    }
  
    /**
     * Adds elements to {@link AlertConfigBase#emailAddresses() emailAddresses} list.
     * @param elements iterable of emailAddresses elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllEmailAddresses(Iterable<String> elements) {
      emailAddressesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.AlertConfig}.
     * @return immutable instance of AlertConfig
     */
    public AlertConfig build() {
      checkRequiredAttributes();
      return new AlertConfig(
        transactionType,
        percentile,
        timePeriodMinutes,
        thresholdMillis,
        minTransactionCount,
        emailAddressesBuilder.build());
    }
  
    private boolean transactionTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRANSACTION_TYPE) != 0;
    }
  
    private boolean percentileIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PERCENTILE) != 0;
    }
  
    private boolean timePeriodMinutesIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TIME_PERIOD_MINUTES) != 0;
    }
  
    private boolean thresholdMillisIsSet() {
      return (initializedBitset & INITIALIZED_BIT_THRESHOLD_MILLIS) != 0;
    }
  
    private boolean minTransactionCountIsSet() {
      return (initializedBitset & INITIALIZED_BIT_MIN_TRANSACTION_COUNT) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!transactionTypeIsSet()) {
        attributes.add("transactionType");
      }
      if (!percentileIsSet()) {
        attributes.add("percentile");
      }
      if (!timePeriodMinutesIsSet()) {
        attributes.add("timePeriodMinutes");
      }
      if (!thresholdMillisIsSet()) {
        attributes.add("thresholdMillis");
      }
      if (!minTransactionCountIsSet()) {
        attributes.add("minTransactionCount");
      }
      return "Cannot build AlertConfig, some of required attributes are not set " + attributes;
    }
  }
}
