package org.glowroot.config;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import java.io.File;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link PluginCacheBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code PluginCache.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "PluginCacheBase"})
@Immutable
final class PluginCache extends PluginCacheBase {
  private final ImmutableList<File> pluginJars;
  private final ImmutableList<PluginDescriptor> pluginDescriptors;

  private PluginCache(
      ImmutableList<File> pluginJars,
      ImmutableList<PluginDescriptor> pluginDescriptors) {
    this.pluginJars = pluginJars;
    this.pluginDescriptors = pluginDescriptors;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code pluginJars} attribute
   */
  @Override
  public ImmutableList<File> pluginJars() {
    return pluginJars;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code pluginDescriptors} attribute
   */
  @Override
  public ImmutableList<PluginDescriptor> pluginDescriptors() {
    return pluginDescriptors;
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link PluginCacheBase#pluginJars() pluginJars}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final PluginCache withPluginJars(File... elements) {
    ImmutableList<File> newValue = ImmutableList.copyOf(elements);
    return new PluginCache(newValue, this.pluginDescriptors);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link PluginCacheBase#pluginJars() pluginJars}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of pluginJars elements to set
   * @return modified copy of {@code this} object
   */
  public final PluginCache withPluginJars(Iterable<? extends File> elements) {
    if (this.pluginJars == elements) {
      return this;
    }
    ImmutableList<File> newValue = ImmutableList.copyOf(elements);
    return new PluginCache(newValue, this.pluginDescriptors);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link PluginCacheBase#pluginDescriptors() pluginDescriptors}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final PluginCache withPluginDescriptors(PluginDescriptor... elements) {
    ImmutableList<PluginDescriptor> newValue = ImmutableList.copyOf(elements);
    return new PluginCache(this.pluginJars, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link PluginCacheBase#pluginDescriptors() pluginDescriptors}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of pluginDescriptors elements to set
   * @return modified copy of {@code this} object
   */
  public final PluginCache withPluginDescriptors(Iterable<? extends PluginDescriptor> elements) {
    if (this.pluginDescriptors == elements) {
      return this;
    }
    ImmutableList<PluginDescriptor> newValue = ImmutableList.copyOf(elements);
    return new PluginCache(this.pluginJars, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code PluginCache} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof PluginCache && equalTo((PluginCache) another));
  }
  
  private boolean equalTo(PluginCache another) {
    return pluginJars.equals(another.pluginJars)
        && pluginDescriptors.equals(another.pluginDescriptors);
  }
  
  /**
   * Computes hash code from attributes: {@code pluginJars}, {@code pluginDescriptors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + pluginJars.hashCode();
    h = h * 17 + pluginDescriptors.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code PluginCache{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PluginCache")
        .add("pluginJars", pluginJars)
        .add("pluginDescriptors", pluginDescriptors)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link PluginCacheBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable PluginCache instance
   */
  static PluginCache copyOf(PluginCacheBase instance) {
    if (instance instanceof PluginCache) {
      return (PluginCache) instance;
    }
    return PluginCache.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.PluginCache}.
   * @return new PluginCache builder
   */
  static PluginCache.Builder builder() {
    return new PluginCache.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.PluginCache}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
  
    private ImmutableList.Builder<File> pluginJarsBuilder = ImmutableList.builder();
    private ImmutableList.Builder<PluginDescriptor> pluginDescriptorsBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link PluginCacheBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(PluginCacheBase instance) {
      Preconditions.checkNotNull(instance);
      addAllPluginJars(instance.pluginJars());
      addAllPluginDescriptors(instance.pluginDescriptors());
      return this;
    }
  
    /**
     * Adds one element to {@link PluginCacheBase#pluginJars() pluginJars} list.
     * @param element pluginJars element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addPluginJars(File element) {
      pluginJarsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link PluginCacheBase#pluginJars() pluginJars} list.
     * @param elements array of pluginJars elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addPluginJars(File... elements) {
      pluginJarsBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link PluginCacheBase#pluginJars() pluginJars} list.
     * @param elements iterable of pluginJars elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder pluginJars(Iterable<? extends File> elements) {
      pluginJarsBuilder = ImmutableList.builder();
      return addAllPluginJars(elements);
    }
  
    /**
     * Adds elements to {@link PluginCacheBase#pluginJars() pluginJars} list.
     * @param elements iterable of pluginJars elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllPluginJars(Iterable<? extends File> elements) {
      pluginJarsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link PluginCacheBase#pluginDescriptors() pluginDescriptors} list.
     * @param element pluginDescriptors element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addPluginDescriptors(PluginDescriptor element) {
      pluginDescriptorsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link PluginCacheBase#pluginDescriptors() pluginDescriptors} list.
     * @param elements array of pluginDescriptors elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addPluginDescriptors(PluginDescriptor... elements) {
      pluginDescriptorsBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link PluginCacheBase#pluginDescriptors() pluginDescriptors} list.
     * @param elements iterable of pluginDescriptors elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder pluginDescriptors(Iterable<? extends PluginDescriptor> elements) {
      pluginDescriptorsBuilder = ImmutableList.builder();
      return addAllPluginDescriptors(elements);
    }
  
    /**
     * Adds elements to {@link PluginCacheBase#pluginDescriptors() pluginDescriptors} list.
     * @param elements iterable of pluginDescriptors elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllPluginDescriptors(Iterable<? extends PluginDescriptor> elements) {
      pluginDescriptorsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.PluginCache}.
     * @return immutable instance of PluginCache
     */
    public org.glowroot.config.PluginCache build() {
      return new PluginCache(pluginJarsBuilder.build(), pluginDescriptorsBuilder.build());
    }
  }
}
