package org.glowroot.config;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link PluginDescriptorBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code PluginDescriptor.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "PluginDescriptorBase"})
@Immutable
public final class PluginDescriptor extends PluginDescriptorBase {
  private final String name;
  private final String id;
  private final ImmutableList<String> transactionTypes;
  private final ImmutableList<String> transactionCustomAttributes;
  private final ImmutableList<PropertyDescriptor> properties;
  private final ImmutableList<InstrumentationConfig> instrumentationConfigs;
  private final ImmutableList<String> aspects;

  private PluginDescriptor(
      String name,
      String id,
      ImmutableList<String> transactionTypes,
      ImmutableList<String> transactionCustomAttributes,
      ImmutableList<PropertyDescriptor> properties,
      ImmutableList<InstrumentationConfig> instrumentationConfigs,
      ImmutableList<String> aspects) {
    this.name = name;
    this.id = id;
    this.transactionTypes = transactionTypes;
    this.transactionCustomAttributes = transactionCustomAttributes;
    this.properties = properties;
    this.instrumentationConfigs = instrumentationConfigs;
    this.aspects = aspects;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String id() {
    return id;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionTypes} attribute
   */
  @JsonProperty("transactionTypes")
  @Override
  public ImmutableList<String> transactionTypes() {
    return transactionTypes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionCustomAttributes} attribute
   */
  @JsonProperty("transactionCustomAttributes")
  @Override
  public ImmutableList<String> transactionCustomAttributes() {
    return transactionCustomAttributes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code properties} attribute
   */
  @JsonProperty("properties")
  @Override
  public ImmutableList<PropertyDescriptor> properties() {
    return properties;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code instrumentationConfigs} attribute
   */
  @JsonProperty("instrumentation")
  @Override
  public ImmutableList<InstrumentationConfig> instrumentationConfigs() {
    return instrumentationConfigs;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code aspects} attribute
   */
  @JsonProperty("aspects")
  @Override
  public ImmutableList<String> aspects() {
    return aspects;
  }
  
  /**
   * Copy current immutable object by setting value for {@link PluginDescriptorBase#name() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final PluginDescriptor withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new PluginDescriptor(
        newValue,
        this.id,
        this.transactionTypes,
        this.transactionCustomAttributes,
        this.properties,
        this.instrumentationConfigs,
        this.aspects);
  }
  
  /**
   * Copy current immutable object by setting value for {@link PluginDescriptorBase#id() id}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for id
   * @return modified copy of the {@code this} object
   */
  public final PluginDescriptor withId(String value) {
    if (this.id == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new PluginDescriptor(
        this.name,
        newValue,
        this.transactionTypes,
        this.transactionCustomAttributes,
        this.properties,
        this.instrumentationConfigs,
        this.aspects);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link PluginDescriptorBase#transactionTypes() transactionTypes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final PluginDescriptor withTransactionTypes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new PluginDescriptor(
        this.name,
        this.id,
        newValue,
        this.transactionCustomAttributes,
        this.properties,
        this.instrumentationConfigs,
        this.aspects);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link PluginDescriptorBase#transactionTypes() transactionTypes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of transactionTypes elements to set
   * @return modified copy of {@code this} object
   */
  public final PluginDescriptor withTransactionTypes(Iterable<String> elements) {
    if (this.transactionTypes == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new PluginDescriptor(
        this.name,
        this.id,
        newValue,
        this.transactionCustomAttributes,
        this.properties,
        this.instrumentationConfigs,
        this.aspects);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link PluginDescriptorBase#transactionCustomAttributes() transactionCustomAttributes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final PluginDescriptor withTransactionCustomAttributes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new PluginDescriptor(
        this.name,
        this.id,
        this.transactionTypes,
        newValue,
        this.properties,
        this.instrumentationConfigs,
        this.aspects);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link PluginDescriptorBase#transactionCustomAttributes() transactionCustomAttributes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of transactionCustomAttributes elements to set
   * @return modified copy of {@code this} object
   */
  public final PluginDescriptor withTransactionCustomAttributes(Iterable<String> elements) {
    if (this.transactionCustomAttributes == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new PluginDescriptor(
        this.name,
        this.id,
        this.transactionTypes,
        newValue,
        this.properties,
        this.instrumentationConfigs,
        this.aspects);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link PluginDescriptorBase#properties() properties}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final PluginDescriptor withProperties(PropertyDescriptor... elements) {
    ImmutableList<PropertyDescriptor> newValue = ImmutableList.copyOf(elements);
    return new PluginDescriptor(
        this.name,
        this.id,
        this.transactionTypes,
        this.transactionCustomAttributes,
        newValue,
        this.instrumentationConfigs,
        this.aspects);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link PluginDescriptorBase#properties() properties}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of properties elements to set
   * @return modified copy of {@code this} object
   */
  public final PluginDescriptor withProperties(Iterable<? extends PropertyDescriptor> elements) {
    if (this.properties == elements) {
      return this;
    }
    ImmutableList<PropertyDescriptor> newValue = ImmutableList.copyOf(elements);
    return new PluginDescriptor(
        this.name,
        this.id,
        this.transactionTypes,
        this.transactionCustomAttributes,
        newValue,
        this.instrumentationConfigs,
        this.aspects);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link PluginDescriptorBase#instrumentationConfigs() instrumentationConfigs}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final PluginDescriptor withInstrumentationConfigs(InstrumentationConfig... elements) {
    ImmutableList<InstrumentationConfig> newValue = ImmutableList.copyOf(elements);
    return new PluginDescriptor(
        this.name,
        this.id,
        this.transactionTypes,
        this.transactionCustomAttributes,
        this.properties,
        newValue,
        this.aspects);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link PluginDescriptorBase#instrumentationConfigs() instrumentationConfigs}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of instrumentationConfigs elements to set
   * @return modified copy of {@code this} object
   */
  public final PluginDescriptor withInstrumentationConfigs(Iterable<? extends InstrumentationConfig> elements) {
    if (this.instrumentationConfigs == elements) {
      return this;
    }
    ImmutableList<InstrumentationConfig> newValue = ImmutableList.copyOf(elements);
    return new PluginDescriptor(
        this.name,
        this.id,
        this.transactionTypes,
        this.transactionCustomAttributes,
        this.properties,
        newValue,
        this.aspects);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link PluginDescriptorBase#aspects() aspects}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final PluginDescriptor withAspects(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new PluginDescriptor(
        this.name,
        this.id,
        this.transactionTypes,
        this.transactionCustomAttributes,
        this.properties,
        this.instrumentationConfigs,
        newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link PluginDescriptorBase#aspects() aspects}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of aspects elements to set
   * @return modified copy of {@code this} object
   */
  public final PluginDescriptor withAspects(Iterable<String> elements) {
    if (this.aspects == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new PluginDescriptor(
        this.name,
        this.id,
        this.transactionTypes,
        this.transactionCustomAttributes,
        this.properties,
        this.instrumentationConfigs,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code PluginDescriptor} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof PluginDescriptor && equalTo((PluginDescriptor) another));
  }
  
  private boolean equalTo(PluginDescriptor another) {
    return name.equals(another.name)
        && id.equals(another.id)
        && transactionTypes.equals(another.transactionTypes)
        && transactionCustomAttributes.equals(another.transactionCustomAttributes)
        && properties.equals(another.properties)
        && instrumentationConfigs.equals(another.instrumentationConfigs)
        && aspects.equals(another.aspects);
  }
  
  /**
   * Computes hash code from attributes: {@code name}, {@code id}, {@code transactionTypes}, {@code transactionCustomAttributes}, {@code properties}, {@code instrumentationConfigs}, {@code aspects}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + id.hashCode();
    h = h * 17 + transactionTypes.hashCode();
    h = h * 17 + transactionCustomAttributes.hashCode();
    h = h * 17 + properties.hashCode();
    h = h * 17 + instrumentationConfigs.hashCode();
    h = h * 17 + aspects.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code PluginDescriptor{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PluginDescriptor")
        .add("name", name)
        .add("id", id)
        .add("transactionTypes", transactionTypes)
        .add("transactionCustomAttributes", transactionCustomAttributes)
        .add("properties", properties)
        .add("instrumentationConfigs", instrumentationConfigs)
        .add("aspects", aspects)
        .toString();
  }
  
  @JsonCreator
  public static PluginDescriptor fromAllAttributes(
      @JsonProperty("name") @Nullable String name,
      @JsonProperty("id") @Nullable String id,
      @JsonProperty("transactionTypes") @Nullable ImmutableList<String> transactionTypes,
      @JsonProperty("transactionCustomAttributes") @Nullable ImmutableList<String> transactionCustomAttributes,
      @JsonProperty("properties") @Nullable ImmutableList<PropertyDescriptor> properties,
      @JsonProperty("instrumentation") @Nullable ImmutableList<InstrumentationConfig> instrumentationConfigs,
      @JsonProperty("aspects") @Nullable ImmutableList<String> aspects) {
    PluginDescriptor.Builder builder = PluginDescriptor.builder();
    if (name != null) {
      builder.name(name);
    }
    if (id != null) {
      builder.id(id);
    }
    if (transactionTypes != null) {
      builder.addAllTransactionTypes(transactionTypes);
    }
    if (transactionCustomAttributes != null) {
      builder.addAllTransactionCustomAttributes(transactionCustomAttributes);
    }
    if (properties != null) {
      builder.addAllProperties(properties);
    }
    if (instrumentationConfigs != null) {
      builder.addAllInstrumentationConfigs(instrumentationConfigs);
    }
    if (aspects != null) {
      builder.addAllAspects(aspects);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link PluginDescriptorBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable PluginDescriptor instance
   */
  public static PluginDescriptor copyOf(PluginDescriptorBase instance) {
    if (instance instanceof PluginDescriptor) {
      return (PluginDescriptor) instance;
    }
    return PluginDescriptor.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.PluginDescriptor}.
   * @return new PluginDescriptor builder
   */
  public static PluginDescriptor.Builder builder() {
    return new PluginDescriptor.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.PluginDescriptor}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_NAME = 0x1L;
    private static final long INITIALIZED_BIT_ID = 0x2L;
    private long initializedBitset;
  
    private @Nullable String name;
    private @Nullable String id;
    private ImmutableList.Builder<String> transactionTypesBuilder = ImmutableList.builder();
    private ImmutableList.Builder<String> transactionCustomAttributesBuilder = ImmutableList.builder();
    private ImmutableList.Builder<PropertyDescriptor> propertiesBuilder = ImmutableList.builder();
    private ImmutableList.Builder<InstrumentationConfig> instrumentationConfigsBuilder = ImmutableList.builder();
    private ImmutableList.Builder<String> aspectsBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link PluginDescriptorBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(PluginDescriptorBase instance) {
      Preconditions.checkNotNull(instance);
      name(instance.name());
      id(instance.id());
      addAllTransactionTypes(instance.transactionTypes());
      addAllTransactionCustomAttributes(instance.transactionCustomAttributes());
      addAllProperties(instance.properties());
      addAllInstrumentationConfigs(instance.instrumentationConfigs());
      addAllAspects(instance.aspects());
      return this;
    }
  
    /**
     * Initializes value for {@link PluginDescriptorBase#name() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link PluginDescriptorBase#id() id}.
     * @param id value for id
     * @return {@code this} builder for chained invocation
     */
    public final Builder id(String id) {
      this.id = Preconditions.checkNotNull(id);
      initializedBitset |= INITIALIZED_BIT_ID;
      return this;
    }
  
    /**
     * Adds one element to {@link PluginDescriptorBase#transactionTypes() transactionTypes} list.
     * @param element transactionTypes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTransactionTypes(String element) {
      transactionTypesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link PluginDescriptorBase#transactionTypes() transactionTypes} list.
     * @param elements array of transactionTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTransactionTypes(String... elements) {
      transactionTypesBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link PluginDescriptorBase#transactionTypes() transactionTypes} list.
     * @param elements iterable of transactionTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionTypes(Iterable<String> elements) {
      transactionTypesBuilder = ImmutableList.builder();
      return addAllTransactionTypes(elements);
    }
  
    /**
     * Adds elements to {@link PluginDescriptorBase#transactionTypes() transactionTypes} list.
     * @param elements iterable of transactionTypes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllTransactionTypes(Iterable<String> elements) {
      transactionTypesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link PluginDescriptorBase#transactionCustomAttributes() transactionCustomAttributes} list.
     * @param element transactionCustomAttributes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTransactionCustomAttributes(String element) {
      transactionCustomAttributesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link PluginDescriptorBase#transactionCustomAttributes() transactionCustomAttributes} list.
     * @param elements array of transactionCustomAttributes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addTransactionCustomAttributes(String... elements) {
      transactionCustomAttributesBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link PluginDescriptorBase#transactionCustomAttributes() transactionCustomAttributes} list.
     * @param elements iterable of transactionCustomAttributes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionCustomAttributes(Iterable<String> elements) {
      transactionCustomAttributesBuilder = ImmutableList.builder();
      return addAllTransactionCustomAttributes(elements);
    }
  
    /**
     * Adds elements to {@link PluginDescriptorBase#transactionCustomAttributes() transactionCustomAttributes} list.
     * @param elements iterable of transactionCustomAttributes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllTransactionCustomAttributes(Iterable<String> elements) {
      transactionCustomAttributesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link PluginDescriptorBase#properties() properties} list.
     * @param element properties element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addProperties(PropertyDescriptor element) {
      propertiesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link PluginDescriptorBase#properties() properties} list.
     * @param elements array of properties elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addProperties(PropertyDescriptor... elements) {
      propertiesBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link PluginDescriptorBase#properties() properties} list.
     * @param elements iterable of properties elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder properties(Iterable<? extends PropertyDescriptor> elements) {
      propertiesBuilder = ImmutableList.builder();
      return addAllProperties(elements);
    }
  
    /**
     * Adds elements to {@link PluginDescriptorBase#properties() properties} list.
     * @param elements iterable of properties elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllProperties(Iterable<? extends PropertyDescriptor> elements) {
      propertiesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link PluginDescriptorBase#instrumentationConfigs() instrumentationConfigs} list.
     * @param element instrumentationConfigs element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addInstrumentationConfigs(InstrumentationConfig element) {
      instrumentationConfigsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link PluginDescriptorBase#instrumentationConfigs() instrumentationConfigs} list.
     * @param elements array of instrumentationConfigs elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addInstrumentationConfigs(InstrumentationConfig... elements) {
      instrumentationConfigsBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link PluginDescriptorBase#instrumentationConfigs() instrumentationConfigs} list.
     * @param elements iterable of instrumentationConfigs elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder instrumentationConfigs(Iterable<? extends InstrumentationConfig> elements) {
      instrumentationConfigsBuilder = ImmutableList.builder();
      return addAllInstrumentationConfigs(elements);
    }
  
    /**
     * Adds elements to {@link PluginDescriptorBase#instrumentationConfigs() instrumentationConfigs} list.
     * @param elements iterable of instrumentationConfigs elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllInstrumentationConfigs(Iterable<? extends InstrumentationConfig> elements) {
      instrumentationConfigsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Adds one element to {@link PluginDescriptorBase#aspects() aspects} list.
     * @param element aspects element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAspects(String element) {
      aspectsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link PluginDescriptorBase#aspects() aspects} list.
     * @param elements array of aspects elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAspects(String... elements) {
      aspectsBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link PluginDescriptorBase#aspects() aspects} list.
     * @param elements iterable of aspects elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder aspects(Iterable<String> elements) {
      aspectsBuilder = ImmutableList.builder();
      return addAllAspects(elements);
    }
  
    /**
     * Adds elements to {@link PluginDescriptorBase#aspects() aspects} list.
     * @param elements iterable of aspects elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllAspects(Iterable<String> elements) {
      aspectsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.PluginDescriptor}.
     * @return immutable instance of PluginDescriptor
     */
    public PluginDescriptor build() {
      checkRequiredAttributes();
      return new PluginDescriptor(
        name,
        id,
        transactionTypesBuilder.build(),
        transactionCustomAttributesBuilder.build(),
        propertiesBuilder.build(),
        instrumentationConfigsBuilder.build(),
        aspectsBuilder.build());
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private boolean idIsSet() {
      return (initializedBitset & INITIALIZED_BIT_ID) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nameIsSet()) {
        attributes.add("name");
      }
      if (!idIsSet()) {
        attributes.add("id");
      }
      return "Cannot build PluginDescriptor, some of required attributes are not set " + attributes;
    }
  }
}
