package org.glowroot.config;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link PropertyDescriptorBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code PropertyDescriptor.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "PropertyDescriptorBase"})
@Immutable
public final class PropertyDescriptor extends PropertyDescriptorBase {
  private final String name;
  private final PropertyType type;
  private final @Nullable PropertyValue defaultValue;
  private final boolean hidden;
  private final String label;
  private final String checkboxLabel;
  private final String description;

  private PropertyDescriptor(PropertyDescriptor.Builder builder) {
    this.name = builder.name;
    this.type = builder.type;
    this.defaultValue = builder.defaultValue;
    this.label = builder.label;
    this.hidden = builder.hiddenIsSet()
        ? builder.hidden
        : super.hidden();
    this.checkboxLabel = builder.checkboxLabel != null
        ? builder.checkboxLabel
        : Preconditions.checkNotNull(super.checkboxLabel());
    this.description = builder.description != null
        ? builder.description
        : Preconditions.checkNotNull(super.description());
  }

  private PropertyDescriptor(
      String name,
      PropertyType type,
      @Nullable PropertyValue defaultValue,
      boolean hidden,
      String label,
      String checkboxLabel,
      String description) {
    this.name = name;
    this.type = type;
    this.defaultValue = defaultValue;
    this.hidden = hidden;
    this.label = label;
    this.checkboxLabel = checkboxLabel;
    this.description = description;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String name() {
    return name;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public PropertyType type() {
    return type;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code defaultValue} attribute
   */
  @JsonProperty("default")
  @Override
  public PropertyValue defaultValue() {
    return defaultValue;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code hidden} attribute
   */
  @JsonProperty("hidden")
  @Override
  public boolean hidden() {
    return hidden;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code label} attribute
   */
  @JsonProperty("label")
  @Override
  public String label() {
    return label;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code checkboxLabel} attribute
   */
  @JsonProperty("checkboxLabel")
  @Override
  public String checkboxLabel() {
    return checkboxLabel;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code description} attribute
   */
  @JsonProperty("description")
  @Override
  public String description() {
    return description;
  }
  
  /**
   * Copy current immutable object by setting value for {@link PropertyDescriptorBase#name() name}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for name
   * @return modified copy of the {@code this} object
   */
  public final PropertyDescriptor withName(String value) {
    if (this.name == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new PropertyDescriptor(
        newValue,
        this.type,
        this.defaultValue,
        this.hidden,
        this.label,
        this.checkboxLabel,
        this.description);
  }
  
  /**
   * Copy current immutable object by setting value for {@link PropertyDescriptorBase#type() type}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for type
   * @return modified copy of the {@code this} object
   */
  public final PropertyDescriptor withType(PropertyType value) {
    if (this.type == value) {
      return this;
    }
    PropertyType newValue = Preconditions.checkNotNull(value);
    return new PropertyDescriptor(
        this.name,
        newValue,
        this.defaultValue,
        this.hidden,
        this.label,
        this.checkboxLabel,
        this.description);
  }
  
  /**
   * Copy current immutable object by setting value for {@link PropertyDescriptorBase#defaultValue() defaultValue}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for defaultValue, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final PropertyDescriptor withDefaultValue(@Nullable PropertyValue value) {
    if (this.defaultValue == value) {
      return this;
    }
    @Nullable PropertyValue newValue = value;
    return new PropertyDescriptor(this.name, this.type, newValue, this.hidden, this.label, this.checkboxLabel, this.description);
  }
  
  /**
   * Copy current immutable object by setting value for {@link PropertyDescriptorBase#hidden() hidden}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for hidden
   * @return modified copy of the {@code this} object
   */
  public final PropertyDescriptor withHidden(boolean value) {
    if (this.hidden == value) {
      return this;
    }
    boolean newValue = value;
    return new PropertyDescriptor(this.name, this.type, this.defaultValue, newValue, this.label, this.checkboxLabel, this.description);
  }
  
  /**
   * Copy current immutable object by setting value for {@link PropertyDescriptorBase#label() label}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for label
   * @return modified copy of the {@code this} object
   */
  public final PropertyDescriptor withLabel(String value) {
    if (this.label == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new PropertyDescriptor(
        this.name,
        this.type,
        this.defaultValue,
        this.hidden,
        newValue,
        this.checkboxLabel,
        this.description);
  }
  
  /**
   * Copy current immutable object by setting value for {@link PropertyDescriptorBase#checkboxLabel() checkboxLabel}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for checkboxLabel
   * @return modified copy of the {@code this} object
   */
  public final PropertyDescriptor withCheckboxLabel(String value) {
    if (this.checkboxLabel == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new PropertyDescriptor(this.name, this.type, this.defaultValue, this.hidden, this.label, newValue, this.description);
  }
  
  /**
   * Copy current immutable object by setting value for {@link PropertyDescriptorBase#description() description}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for description
   * @return modified copy of the {@code this} object
   */
  public final PropertyDescriptor withDescription(String value) {
    if (this.description == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new PropertyDescriptor(this.name, this.type, this.defaultValue, this.hidden, this.label, this.checkboxLabel, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code PropertyDescriptor} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof PropertyDescriptor && equalTo((PropertyDescriptor) another));
  }
  
  private boolean equalTo(PropertyDescriptor another) {
    return name.equals(another.name)
        && type.equals(another.type)
        && Objects.equal(defaultValue, another.defaultValue)
        && hidden == another.hidden
        && label.equals(another.label)
        && checkboxLabel.equals(another.checkboxLabel)
        && description.equals(another.description);
  }
  
  /**
   * Computes hash code from attributes: {@code name}, {@code type}, {@code defaultValue}, {@code hidden}, {@code label}, {@code checkboxLabel}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + name.hashCode();
    h = h * 17 + type.hashCode();
    h = h * 17 + Objects.hashCode(defaultValue);
    h = h * 17 + Booleans.hashCode(hidden);
    h = h * 17 + label.hashCode();
    h = h * 17 + checkboxLabel.hashCode();
    h = h * 17 + description.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code PropertyDescriptor{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PropertyDescriptor")
        .add("name", name)
        .add("type", type)
        .add("defaultValue", defaultValue)
        .add("hidden", hidden)
        .add("label", label)
        .add("checkboxLabel", checkboxLabel)
        .add("description", description)
        .toString();
  }
  
  @JsonCreator
  public static PropertyDescriptor fromAllAttributes(
      @JsonProperty("name") @Nullable String name,
      @JsonProperty("type") @Nullable PropertyType type,
      @JsonProperty("default") @Nullable PropertyValue defaultValue,
      @JsonProperty("hidden") @Nullable Boolean hidden,
      @JsonProperty("label") @Nullable String label,
      @JsonProperty("checkboxLabel") @Nullable String checkboxLabel,
      @JsonProperty("description") @Nullable String description) {
    PropertyDescriptor.Builder builder = PropertyDescriptor.builder();
    if (name != null) {
      builder.name(name);
    }
    if (type != null) {
      builder.type(type);
    }
    if (defaultValue != null) {
      builder.defaultValue(defaultValue);
    }
    if (hidden != null) {
      builder.hidden(hidden);
    }
    if (label != null) {
      builder.label(label);
    }
    if (checkboxLabel != null) {
      builder.checkboxLabel(checkboxLabel);
    }
    if (description != null) {
      builder.description(description);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link PropertyDescriptorBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable PropertyDescriptor instance
   */
  public static PropertyDescriptor copyOf(PropertyDescriptorBase instance) {
    if (instance instanceof PropertyDescriptor) {
      return (PropertyDescriptor) instance;
    }
    return PropertyDescriptor.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.PropertyDescriptor}.
   * @return new PropertyDescriptor builder
   */
  public static PropertyDescriptor.Builder builder() {
    return new PropertyDescriptor.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.PropertyDescriptor}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x7;
    private static final long INITIALIZED_BIT_NAME = 0x1L;
    private static final long INITIALIZED_BIT_TYPE = 0x2L;
    private static final long INITIALIZED_BIT_LABEL = 0x4L;
    private static final long NONDEFAULT_BIT_HIDDEN = 0x1L;
    private long initializedBitset;
    private long nondefaultBitset;
  
    private @Nullable String name;
    private @Nullable PropertyType type;
    private @Nullable PropertyValue defaultValue;
    private boolean hidden;
    private @Nullable String label;
    private @Nullable String checkboxLabel;
    private @Nullable String description;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link PropertyDescriptorBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(PropertyDescriptorBase instance) {
      Preconditions.checkNotNull(instance);
      name(instance.name());
      type(instance.type());
      @Nullable PropertyValue defaultValueValue = instance.defaultValue();
      if (defaultValueValue != null) {
        defaultValue(defaultValueValue);
      }
      hidden(instance.hidden());
      label(instance.label());
      checkboxLabel(instance.checkboxLabel());
      description(instance.description());
      return this;
    }
  
    /**
     * Initializes value for {@link PropertyDescriptorBase#name() name}.
     * @param name value for name
     * @return {@code this} builder for chained invocation
     */
    public final Builder name(String name) {
      this.name = Preconditions.checkNotNull(name);
      initializedBitset |= INITIALIZED_BIT_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link PropertyDescriptorBase#type() type}.
     * @param type value for type
     * @return {@code this} builder for chained invocation
     */
    public final Builder type(PropertyType type) {
      this.type = Preconditions.checkNotNull(type);
      initializedBitset |= INITIALIZED_BIT_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link PropertyDescriptorBase#defaultValue() defaultValue}.
     * @param defaultValue value for defaultValue, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder defaultValue(@Nullable PropertyValue defaultValue) {
      this.defaultValue = defaultValue;
      return this;
    }
  
    /**
     * Initializes value for {@link PropertyDescriptorBase#hidden() hidden}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link PropertyDescriptorBase#hidden() hidden}.</em>
     * @param hidden value for hidden
     * @return {@code this} builder for chained invocation
     */
    public final Builder hidden(boolean hidden) {
      this.hidden = hidden;
      nondefaultBitset |= NONDEFAULT_BIT_HIDDEN;
      return this;
    }
  
    /**
     * Initializes value for {@link PropertyDescriptorBase#label() label}.
     * @param label value for label
     * @return {@code this} builder for chained invocation
     */
    public final Builder label(String label) {
      this.label = Preconditions.checkNotNull(label);
      initializedBitset |= INITIALIZED_BIT_LABEL;
      return this;
    }
  
    /**
     * Initializes value for {@link PropertyDescriptorBase#checkboxLabel() checkboxLabel}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link PropertyDescriptorBase#checkboxLabel() checkboxLabel}.</em>
     * @param checkboxLabel value for checkboxLabel
     * @return {@code this} builder for chained invocation
     */
    public final Builder checkboxLabel(String checkboxLabel) {
      this.checkboxLabel = Preconditions.checkNotNull(checkboxLabel);
      return this;
    }
  
    /**
     * Initializes value for {@link PropertyDescriptorBase#description() description}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link PropertyDescriptorBase#description() description}.</em>
     * @param description value for description
     * @return {@code this} builder for chained invocation
     */
    public final Builder description(String description) {
      this.description = Preconditions.checkNotNull(description);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.PropertyDescriptor}.
     * @return immutable instance of PropertyDescriptor
     */
    public PropertyDescriptor build() {
      checkRequiredAttributes();
      return new PropertyDescriptor(this);
    }
  
    private boolean hiddenIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_HIDDEN) != 0;
    }
  
    private boolean nameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_NAME) != 0;
    }
  
    private boolean typeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TYPE) != 0;
    }
  
    private boolean labelIsSet() {
      return (initializedBitset & INITIALIZED_BIT_LABEL) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!nameIsSet()) {
        attributes.add("name");
      }
      if (!typeIsSet()) {
        attributes.add("type");
      }
      if (!labelIsSet()) {
        attributes.add("label");
      }
      return "Cannot build PropertyDescriptor, some of required attributes are not set " + attributes;
    }
  }
}
