package org.glowroot.config;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Objects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableMap;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SmtpConfigBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code SmtpConfig.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SmtpConfigBase"})
@Immutable
public final class SmtpConfig extends SmtpConfigBase {
  private final String fromEmailAddress;
  private final String fromDisplayName;
  private final String host;
  private final @Nullable Integer port;
  private final boolean ssl;
  private final String username;
  private final String encryptedPassword;
  private final ImmutableMap<String, String> additionalProperties;
  private final String version;

  private SmtpConfig(SmtpConfig.Builder builder) {
    this.port = builder.port;
    this.additionalProperties = builder.additionalPropertiesBuilder.build();
    this.fromEmailAddress = builder.fromEmailAddress != null
        ? builder.fromEmailAddress
        : Preconditions.checkNotNull(super.fromEmailAddress());
    this.fromDisplayName = builder.fromDisplayName != null
        ? builder.fromDisplayName
        : Preconditions.checkNotNull(super.fromDisplayName());
    this.host = builder.host != null
        ? builder.host
        : Preconditions.checkNotNull(super.host());
    this.ssl = builder.sslIsSet()
        ? builder.ssl
        : super.ssl();
    this.username = builder.username != null
        ? builder.username
        : Preconditions.checkNotNull(super.username());
    this.encryptedPassword = builder.encryptedPassword != null
        ? builder.encryptedPassword
        : Preconditions.checkNotNull(super.encryptedPassword());
    this.version = Preconditions.checkNotNull(super.version());
  }

  private SmtpConfig(
      String fromEmailAddress,
      String fromDisplayName,
      String host,
      @Nullable Integer port,
      boolean ssl,
      String username,
      String encryptedPassword,
      ImmutableMap<String, String> additionalProperties) {
    this.fromEmailAddress = fromEmailAddress;
    this.fromDisplayName = fromDisplayName;
    this.host = host;
    this.port = port;
    this.ssl = ssl;
    this.username = username;
    this.encryptedPassword = encryptedPassword;
    this.additionalProperties = additionalProperties;
    this.version = Preconditions.checkNotNull(super.version());
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code fromEmailAddress} attribute
   */
  @JsonProperty("fromEmailAddress")
  @Override
  public String fromEmailAddress() {
    return fromEmailAddress;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code fromDisplayName} attribute
   */
  @JsonProperty("fromDisplayName")
  @Override
  public String fromDisplayName() {
    return fromDisplayName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code host} attribute
   */
  @JsonProperty("host")
  @Override
  public String host() {
    return host;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code port} attribute
   */
  @JsonProperty("port")
  @Override
  public Integer port() {
    return port;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code ssl} attribute
   */
  @JsonProperty("ssl")
  @Override
  public boolean ssl() {
    return ssl;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code username} attribute
   */
  @JsonProperty("username")
  @Override
  public String username() {
    return username;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code encryptedPassword} attribute
   */
  @JsonProperty("encryptedPassword")
  @Override
  public String encryptedPassword() {
    return encryptedPassword;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code additionalProperties} attribute
   */
  @JsonProperty("additionalProperties")
  @Override
  public ImmutableMap<String, String> additionalProperties() {
    return additionalProperties;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code version} attribute
   */
  @JsonIgnore
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link SmtpConfigBase#fromEmailAddress() fromEmailAddress}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for fromEmailAddress
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfig withFromEmailAddress(String value) {
    if (this.fromEmailAddress == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new SmtpConfig(
        newValue,
        this.fromDisplayName,
        this.host,
        this.port,
        this.ssl,
        this.username,
        this.encryptedPassword,
        this.additionalProperties);
  }
  
  /**
   * Copy current immutable object by setting value for {@link SmtpConfigBase#fromDisplayName() fromDisplayName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for fromDisplayName
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfig withFromDisplayName(String value) {
    if (this.fromDisplayName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new SmtpConfig(
        this.fromEmailAddress,
        newValue,
        this.host,
        this.port,
        this.ssl,
        this.username,
        this.encryptedPassword,
        this.additionalProperties);
  }
  
  /**
   * Copy current immutable object by setting value for {@link SmtpConfigBase#host() host}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for host
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfig withHost(String value) {
    if (this.host == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new SmtpConfig(
        this.fromEmailAddress,
        this.fromDisplayName,
        newValue,
        this.port,
        this.ssl,
        this.username,
        this.encryptedPassword,
        this.additionalProperties);
  }
  
  /**
   * Copy current immutable object by setting value for {@link SmtpConfigBase#port() port}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for port, can be {@code null}
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfig withPort(@Nullable Integer value) {
    if (this.port == value) {
      return this;
    }
    @Nullable Integer newValue = value;
    return new SmtpConfig(
        this.fromEmailAddress,
        this.fromDisplayName,
        this.host,
        newValue,
        this.ssl,
        this.username,
        this.encryptedPassword,
        this.additionalProperties);
  }
  
  /**
   * Copy current immutable object by setting value for {@link SmtpConfigBase#ssl() ssl}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for ssl
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfig withSsl(boolean value) {
    if (this.ssl == value) {
      return this;
    }
    boolean newValue = value;
    return new SmtpConfig(
        this.fromEmailAddress,
        this.fromDisplayName,
        this.host,
        this.port,
        newValue,
        this.username,
        this.encryptedPassword,
        this.additionalProperties);
  }
  
  /**
   * Copy current immutable object by setting value for {@link SmtpConfigBase#username() username}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for username
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfig withUsername(String value) {
    if (this.username == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new SmtpConfig(
        this.fromEmailAddress,
        this.fromDisplayName,
        this.host,
        this.port,
        this.ssl,
        newValue,
        this.encryptedPassword,
        this.additionalProperties);
  }
  
  /**
   * Copy current immutable object by setting value for {@link SmtpConfigBase#encryptedPassword() encryptedPassword}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for encryptedPassword
   * @return modified copy of the {@code this} object
   */
  public final SmtpConfig withEncryptedPassword(String value) {
    if (this.encryptedPassword == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new SmtpConfig(
        this.fromEmailAddress,
        this.fromDisplayName,
        this.host,
        this.port,
        this.ssl,
        this.username,
        newValue,
        this.additionalProperties);
  }
  
  /**
   * Copy current immutable object by replacing {@link SmtpConfigBase#additionalProperties() additionalProperties} map with specified map.
   * Nulls are not permitted as keys or values.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries to be added to additionalProperties map
   * @return modified copy of {@code this} object
   */
  public final SmtpConfig withAdditionalProperties(Map<String, ? extends String> entries) {
    if (this.additionalProperties == entries) {
      return this;
    }
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new SmtpConfig(
        this.fromEmailAddress,
        this.fromDisplayName,
        this.host,
        this.port,
        this.ssl,
        this.username,
        this.encryptedPassword,
        newValue);
  }
  
  /**
   * This instance is equal to instances of {@code SmtpConfig} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof SmtpConfig && equalTo((SmtpConfig) another));
  }
  
  private boolean equalTo(SmtpConfig another) {
    return fromEmailAddress.equals(another.fromEmailAddress)
        && fromDisplayName.equals(another.fromDisplayName)
        && host.equals(another.host)
        && Objects.equal(port, another.port)
        && ssl == another.ssl
        && username.equals(another.username)
        && encryptedPassword.equals(another.encryptedPassword)
        && additionalProperties.equals(another.additionalProperties)
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code fromEmailAddress}, {@code fromDisplayName}, {@code host}, {@code port}, {@code ssl}, {@code username}, {@code encryptedPassword}, {@code additionalProperties}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + fromEmailAddress.hashCode();
    h = h * 17 + fromDisplayName.hashCode();
    h = h * 17 + host.hashCode();
    h = h * 17 + Objects.hashCode(port);
    h = h * 17 + Booleans.hashCode(ssl);
    h = h * 17 + username.hashCode();
    h = h * 17 + encryptedPassword.hashCode();
    h = h * 17 + additionalProperties.hashCode();
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code SmtpConfig{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SmtpConfig")
        .add("fromEmailAddress", fromEmailAddress)
        .add("fromDisplayName", fromDisplayName)
        .add("host", host)
        .add("port", port)
        .add("ssl", ssl)
        .add("username", username)
        .add("encryptedPassword", encryptedPassword)
        .add("additionalProperties", additionalProperties)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static SmtpConfig fromAllAttributes(
      @JsonProperty("fromEmailAddress") @Nullable String fromEmailAddress,
      @JsonProperty("fromDisplayName") @Nullable String fromDisplayName,
      @JsonProperty("host") @Nullable String host,
      @JsonProperty("port") @Nullable Integer port,
      @JsonProperty("ssl") @Nullable Boolean ssl,
      @JsonProperty("username") @Nullable String username,
      @JsonProperty("encryptedPassword") @Nullable String encryptedPassword,
      @JsonProperty("additionalProperties") @Nullable Map<String, String> additionalProperties) {
    SmtpConfig.Builder builder = SmtpConfig.builder();
    if (fromEmailAddress != null) {
      builder.fromEmailAddress(fromEmailAddress);
    }
    if (fromDisplayName != null) {
      builder.fromDisplayName(fromDisplayName);
    }
    if (host != null) {
      builder.host(host);
    }
    if (port != null) {
      builder.port(port);
    }
    if (ssl != null) {
      builder.ssl(ssl);
    }
    if (username != null) {
      builder.username(username);
    }
    if (encryptedPassword != null) {
      builder.encryptedPassword(encryptedPassword);
    }
    if (additionalProperties != null) {
      builder.putAllAdditionalProperties(additionalProperties);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link SmtpConfigBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable SmtpConfig instance
   */
  public static SmtpConfig copyOf(SmtpConfigBase instance) {
    if (instance instanceof SmtpConfig) {
      return (SmtpConfig) instance;
    }
    return SmtpConfig.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.SmtpConfig}.
   * @return new SmtpConfig builder
   */
  public static SmtpConfig.Builder builder() {
    return new SmtpConfig.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.SmtpConfig}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long NONDEFAULT_BIT_SSL = 0x1L;
    private long nondefaultBitset;
  
    private @Nullable String fromEmailAddress;
    private @Nullable String fromDisplayName;
    private @Nullable String host;
    private @Nullable Integer port;
    private boolean ssl;
    private @Nullable String username;
    private @Nullable String encryptedPassword;
    private ImmutableMap.Builder<String, String> additionalPropertiesBuilder = ImmutableMap.builder();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link SmtpConfigBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(SmtpConfigBase instance) {
      Preconditions.checkNotNull(instance);
      fromEmailAddress(instance.fromEmailAddress());
      fromDisplayName(instance.fromDisplayName());
      host(instance.host());
      @Nullable Integer portValue = instance.port();
      if (portValue != null) {
        port(portValue);
      }
      ssl(instance.ssl());
      username(instance.username());
      encryptedPassword(instance.encryptedPassword());
      putAllAdditionalProperties(instance.additionalProperties());
      return this;
    }
  
    /**
     * Initializes value for {@link SmtpConfigBase#fromEmailAddress() fromEmailAddress}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link SmtpConfigBase#fromEmailAddress() fromEmailAddress}.</em>
     * @param fromEmailAddress value for fromEmailAddress
     * @return {@code this} builder for chained invocation
     */
    public final Builder fromEmailAddress(String fromEmailAddress) {
      this.fromEmailAddress = Preconditions.checkNotNull(fromEmailAddress);
      return this;
    }
  
    /**
     * Initializes value for {@link SmtpConfigBase#fromDisplayName() fromDisplayName}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link SmtpConfigBase#fromDisplayName() fromDisplayName}.</em>
     * @param fromDisplayName value for fromDisplayName
     * @return {@code this} builder for chained invocation
     */
    public final Builder fromDisplayName(String fromDisplayName) {
      this.fromDisplayName = Preconditions.checkNotNull(fromDisplayName);
      return this;
    }
  
    /**
     * Initializes value for {@link SmtpConfigBase#host() host}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link SmtpConfigBase#host() host}.</em>
     * @param host value for host
     * @return {@code this} builder for chained invocation
     */
    public final Builder host(String host) {
      this.host = Preconditions.checkNotNull(host);
      return this;
    }
  
    /**
     * Initializes value for {@link SmtpConfigBase#port() port}.
     * @param port value for port, can be {@code null}
     * @return {@code this} builder for chained invocation
     */
    public final Builder port(@Nullable Integer port) {
      this.port = port;
      return this;
    }
  
    /**
     * Initializes value for {@link SmtpConfigBase#ssl() ssl}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link SmtpConfigBase#ssl() ssl}.</em>
     * @param ssl value for ssl
     * @return {@code this} builder for chained invocation
     */
    public final Builder ssl(boolean ssl) {
      this.ssl = ssl;
      nondefaultBitset |= NONDEFAULT_BIT_SSL;
      return this;
    }
  
    /**
     * Initializes value for {@link SmtpConfigBase#username() username}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link SmtpConfigBase#username() username}.</em>
     * @param username value for username
     * @return {@code this} builder for chained invocation
     */
    public final Builder username(String username) {
      this.username = Preconditions.checkNotNull(username);
      return this;
    }
  
    /**
     * Initializes value for {@link SmtpConfigBase#encryptedPassword() encryptedPassword}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link SmtpConfigBase#encryptedPassword() encryptedPassword}.</em>
     * @param encryptedPassword value for encryptedPassword
     * @return {@code this} builder for chained invocation
     */
    public final Builder encryptedPassword(String encryptedPassword) {
      this.encryptedPassword = Preconditions.checkNotNull(encryptedPassword);
      return this;
    }
  
    /**
     * Put one entry to {@link SmtpConfigBase#additionalProperties() additionalProperties} map.
     * @param key the key in additionalProperties map
     * @param value the associated value in additionalProperties map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putAdditionalProperties(String key, String value) {
      additionalPropertiesBuilder.put(key, value);
      return this;
    }
  
    /**
     * Put one entry to {@link SmtpConfigBase#additionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entry the key and value entry
     * @return {@code this} builder for chained invocation
     */
    public final Builder putAdditionalProperties(Map.Entry<String, ? extends String> entry) {
      additionalPropertiesBuilder.put(entry);
      return this;
    }
  
    /**
     * Sets or replaces all mappings from specified map as entries for {@link SmtpConfigBase#additionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entries to be added to additionalProperties map
     * @return {@code this} builder for chained invocation
     */
    public final Builder additionalProperties(Map<String, ? extends String> entries) {
      additionalPropertiesBuilder = ImmutableMap.builder();
      return putAllAdditionalProperties(entries);
    }
  
    /**
     * Put all mappings from specified map as entries to {@link SmtpConfigBase#additionalProperties() additionalProperties} map. Nulls are not permitted
     * @param entries to be added to additionalProperties map
     * @return {@code this} builder for chained invocation
     */
    public final Builder putAllAdditionalProperties(Map<String, ? extends String> entries) {
      additionalPropertiesBuilder.putAll(entries);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.SmtpConfig}.
     * @return immutable instance of SmtpConfig
     */
    public SmtpConfig build() {
      return new SmtpConfig(this);
    }
  
    private boolean sslIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_SSL) != 0;
    }
  }
}
