package org.glowroot.config;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link StorageConfigBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code StorageConfig.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "StorageConfigBase"})
@Immutable
public final class StorageConfig extends StorageConfigBase {
  private final int aggregateExpirationHours;
  private final int traceExpirationHours;
  private final int gaugeExpirationHours;
  private final int cappedDatabaseSizeMb;
  private final String version;

  private StorageConfig(StorageConfig.Builder builder) {
    this.aggregateExpirationHours = builder.aggregateExpirationHoursIsSet()
        ? builder.aggregateExpirationHours
        : super.aggregateExpirationHours();
    this.traceExpirationHours = builder.traceExpirationHoursIsSet()
        ? builder.traceExpirationHours
        : super.traceExpirationHours();
    this.gaugeExpirationHours = builder.gaugeExpirationHoursIsSet()
        ? builder.gaugeExpirationHours
        : super.gaugeExpirationHours();
    this.cappedDatabaseSizeMb = builder.cappedDatabaseSizeMbIsSet()
        ? builder.cappedDatabaseSizeMb
        : super.cappedDatabaseSizeMb();
    this.version = Preconditions.checkNotNull(super.version());
  }

  private StorageConfig(
      int aggregateExpirationHours,
      int traceExpirationHours,
      int gaugeExpirationHours,
      int cappedDatabaseSizeMb) {
    this.aggregateExpirationHours = aggregateExpirationHours;
    this.traceExpirationHours = traceExpirationHours;
    this.gaugeExpirationHours = gaugeExpirationHours;
    this.cappedDatabaseSizeMb = cappedDatabaseSizeMb;
    this.version = Preconditions.checkNotNull(super.version());
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code aggregateExpirationHours} attribute
   */
  @JsonProperty("aggregateExpirationHours")
  @Override
  public int aggregateExpirationHours() {
    return aggregateExpirationHours;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code traceExpirationHours} attribute
   */
  @JsonProperty("traceExpirationHours")
  @Override
  public int traceExpirationHours() {
    return traceExpirationHours;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code gaugeExpirationHours} attribute
   */
  @JsonProperty("gaugeExpirationHours")
  @Override
  public int gaugeExpirationHours() {
    return gaugeExpirationHours;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code cappedDatabaseSizeMb} attribute
   */
  @JsonProperty("cappedDatabaseSizeMb")
  @Override
  public int cappedDatabaseSizeMb() {
    return cappedDatabaseSizeMb;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code version} attribute
   */
  @JsonIgnore
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link StorageConfigBase#aggregateExpirationHours() aggregateExpirationHours}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for aggregateExpirationHours
   * @return modified copy of the {@code this} object
   */
  public final StorageConfig withAggregateExpirationHours(int value) {
    if (this.aggregateExpirationHours == value) {
      return this;
    }
    int newValue = value;
    return new StorageConfig(newValue, this.traceExpirationHours, this.gaugeExpirationHours, this.cappedDatabaseSizeMb);
  }
  
  /**
   * Copy current immutable object by setting value for {@link StorageConfigBase#traceExpirationHours() traceExpirationHours}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for traceExpirationHours
   * @return modified copy of the {@code this} object
   */
  public final StorageConfig withTraceExpirationHours(int value) {
    if (this.traceExpirationHours == value) {
      return this;
    }
    int newValue = value;
    return new StorageConfig(this.aggregateExpirationHours, newValue, this.gaugeExpirationHours, this.cappedDatabaseSizeMb);
  }
  
  /**
   * Copy current immutable object by setting value for {@link StorageConfigBase#gaugeExpirationHours() gaugeExpirationHours}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for gaugeExpirationHours
   * @return modified copy of the {@code this} object
   */
  public final StorageConfig withGaugeExpirationHours(int value) {
    if (this.gaugeExpirationHours == value) {
      return this;
    }
    int newValue = value;
    return new StorageConfig(this.aggregateExpirationHours, this.traceExpirationHours, newValue, this.cappedDatabaseSizeMb);
  }
  
  /**
   * Copy current immutable object by setting value for {@link StorageConfigBase#cappedDatabaseSizeMb() cappedDatabaseSizeMb}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for cappedDatabaseSizeMb
   * @return modified copy of the {@code this} object
   */
  public final StorageConfig withCappedDatabaseSizeMb(int value) {
    if (this.cappedDatabaseSizeMb == value) {
      return this;
    }
    int newValue = value;
    return new StorageConfig(this.aggregateExpirationHours, this.traceExpirationHours, this.gaugeExpirationHours, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code StorageConfig} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof StorageConfig && equalTo((StorageConfig) another));
  }
  
  private boolean equalTo(StorageConfig another) {
    return aggregateExpirationHours == another.aggregateExpirationHours
        && traceExpirationHours == another.traceExpirationHours
        && gaugeExpirationHours == another.gaugeExpirationHours
        && cappedDatabaseSizeMb == another.cappedDatabaseSizeMb
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code aggregateExpirationHours}, {@code traceExpirationHours}, {@code gaugeExpirationHours}, {@code cappedDatabaseSizeMb}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + aggregateExpirationHours;
    h = h * 17 + traceExpirationHours;
    h = h * 17 + gaugeExpirationHours;
    h = h * 17 + cappedDatabaseSizeMb;
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code StorageConfig{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("StorageConfig")
        .add("aggregateExpirationHours", aggregateExpirationHours)
        .add("traceExpirationHours", traceExpirationHours)
        .add("gaugeExpirationHours", gaugeExpirationHours)
        .add("cappedDatabaseSizeMb", cappedDatabaseSizeMb)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static StorageConfig fromAllAttributes(
      @JsonProperty("aggregateExpirationHours") @Nullable Integer aggregateExpirationHours,
      @JsonProperty("traceExpirationHours") @Nullable Integer traceExpirationHours,
      @JsonProperty("gaugeExpirationHours") @Nullable Integer gaugeExpirationHours,
      @JsonProperty("cappedDatabaseSizeMb") @Nullable Integer cappedDatabaseSizeMb) {
    StorageConfig.Builder builder = StorageConfig.builder();
    if (aggregateExpirationHours != null) {
      builder.aggregateExpirationHours(aggregateExpirationHours);
    }
    if (traceExpirationHours != null) {
      builder.traceExpirationHours(traceExpirationHours);
    }
    if (gaugeExpirationHours != null) {
      builder.gaugeExpirationHours(gaugeExpirationHours);
    }
    if (cappedDatabaseSizeMb != null) {
      builder.cappedDatabaseSizeMb(cappedDatabaseSizeMb);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link StorageConfigBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable StorageConfig instance
   */
  public static StorageConfig copyOf(StorageConfigBase instance) {
    if (instance instanceof StorageConfig) {
      return (StorageConfig) instance;
    }
    return StorageConfig.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.StorageConfig}.
   * @return new StorageConfig builder
   */
  public static StorageConfig.Builder builder() {
    return new StorageConfig.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.StorageConfig}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long NONDEFAULT_BIT_AGGREGATE_EXPIRATION_HOURS = 0x1L;
    private static final long NONDEFAULT_BIT_TRACE_EXPIRATION_HOURS = 0x2L;
    private static final long NONDEFAULT_BIT_GAUGE_EXPIRATION_HOURS = 0x4L;
    private static final long NONDEFAULT_BIT_CAPPED_DATABASE_SIZE_MB = 0x8L;
    private long nondefaultBitset;
  
    private int aggregateExpirationHours;
    private int traceExpirationHours;
    private int gaugeExpirationHours;
    private int cappedDatabaseSizeMb;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link StorageConfigBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(StorageConfigBase instance) {
      Preconditions.checkNotNull(instance);
      aggregateExpirationHours(instance.aggregateExpirationHours());
      traceExpirationHours(instance.traceExpirationHours());
      gaugeExpirationHours(instance.gaugeExpirationHours());
      cappedDatabaseSizeMb(instance.cappedDatabaseSizeMb());
      return this;
    }
  
    /**
     * Initializes value for {@link StorageConfigBase#aggregateExpirationHours() aggregateExpirationHours}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link StorageConfigBase#aggregateExpirationHours() aggregateExpirationHours}.</em>
     * @param aggregateExpirationHours value for aggregateExpirationHours
     * @return {@code this} builder for chained invocation
     */
    public final Builder aggregateExpirationHours(int aggregateExpirationHours) {
      this.aggregateExpirationHours = aggregateExpirationHours;
      nondefaultBitset |= NONDEFAULT_BIT_AGGREGATE_EXPIRATION_HOURS;
      return this;
    }
  
    /**
     * Initializes value for {@link StorageConfigBase#traceExpirationHours() traceExpirationHours}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link StorageConfigBase#traceExpirationHours() traceExpirationHours}.</em>
     * @param traceExpirationHours value for traceExpirationHours
     * @return {@code this} builder for chained invocation
     */
    public final Builder traceExpirationHours(int traceExpirationHours) {
      this.traceExpirationHours = traceExpirationHours;
      nondefaultBitset |= NONDEFAULT_BIT_TRACE_EXPIRATION_HOURS;
      return this;
    }
  
    /**
     * Initializes value for {@link StorageConfigBase#gaugeExpirationHours() gaugeExpirationHours}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link StorageConfigBase#gaugeExpirationHours() gaugeExpirationHours}.</em>
     * @param gaugeExpirationHours value for gaugeExpirationHours
     * @return {@code this} builder for chained invocation
     */
    public final Builder gaugeExpirationHours(int gaugeExpirationHours) {
      this.gaugeExpirationHours = gaugeExpirationHours;
      nondefaultBitset |= NONDEFAULT_BIT_GAUGE_EXPIRATION_HOURS;
      return this;
    }
  
    /**
     * Initializes value for {@link StorageConfigBase#cappedDatabaseSizeMb() cappedDatabaseSizeMb}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link StorageConfigBase#cappedDatabaseSizeMb() cappedDatabaseSizeMb}.</em>
     * @param cappedDatabaseSizeMb value for cappedDatabaseSizeMb
     * @return {@code this} builder for chained invocation
     */
    public final Builder cappedDatabaseSizeMb(int cappedDatabaseSizeMb) {
      this.cappedDatabaseSizeMb = cappedDatabaseSizeMb;
      nondefaultBitset |= NONDEFAULT_BIT_CAPPED_DATABASE_SIZE_MB;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.StorageConfig}.
     * @return immutable instance of StorageConfig
     */
    public StorageConfig build() {
      return new StorageConfig(this);
    }
  
    private boolean aggregateExpirationHoursIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_AGGREGATE_EXPIRATION_HOURS) != 0;
    }
  
    private boolean traceExpirationHoursIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_TRACE_EXPIRATION_HOURS) != 0;
    }
  
    private boolean gaugeExpirationHoursIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_GAUGE_EXPIRATION_HOURS) != 0;
    }
  
    private boolean cappedDatabaseSizeMbIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_CAPPED_DATABASE_SIZE_MB) != 0;
    }
  }
}
