package org.glowroot.config;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonIgnore;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.primitives.Booleans;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link UserRecordingConfigBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code UserRecordingConfig.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "UserRecordingConfigBase"})
@Immutable
public final class UserRecordingConfig extends UserRecordingConfigBase {
  private final boolean enabled;
  private final String user;
  private final int profileIntervalMillis;
  private final String version;

  private UserRecordingConfig(UserRecordingConfig.Builder builder) {
    this.enabled = builder.enabledIsSet()
        ? builder.enabled
        : super.enabled();
    this.user = builder.user != null
        ? builder.user
        : Preconditions.checkNotNull(super.user());
    this.profileIntervalMillis = builder.profileIntervalMillisIsSet()
        ? builder.profileIntervalMillis
        : super.profileIntervalMillis();
    this.version = Preconditions.checkNotNull(super.version());
  }

  private UserRecordingConfig(boolean enabled, String user, int profileIntervalMillis) {
    this.enabled = enabled;
    this.user = user;
    this.profileIntervalMillis = profileIntervalMillis;
    this.version = Preconditions.checkNotNull(super.version());
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code enabled} attribute
   */
  @JsonProperty("enabled")
  @Override
  public boolean enabled() {
    return enabled;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code user} attribute
   */
  @JsonProperty("user")
  @Override
  public String user() {
    return user;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code profileIntervalMillis} attribute
   */
  @JsonProperty("profileIntervalMillis")
  @Override
  public int profileIntervalMillis() {
    return profileIntervalMillis;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code version} attribute
   */
  @JsonIgnore
  @JsonProperty("version")
  @Override
  public String version() {
    return version;
  }
  
  /**
   * Copy current immutable object by setting value for {@link UserRecordingConfigBase#enabled() enabled}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for enabled
   * @return modified copy of the {@code this} object
   */
  public final UserRecordingConfig withEnabled(boolean value) {
    if (this.enabled == value) {
      return this;
    }
    boolean newValue = value;
    return new UserRecordingConfig(newValue, this.user, this.profileIntervalMillis);
  }
  
  /**
   * Copy current immutable object by setting value for {@link UserRecordingConfigBase#user() user}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for user
   * @return modified copy of the {@code this} object
   */
  public final UserRecordingConfig withUser(String value) {
    if (this.user == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new UserRecordingConfig(this.enabled, newValue, this.profileIntervalMillis);
  }
  
  /**
   * Copy current immutable object by setting value for {@link UserRecordingConfigBase#profileIntervalMillis() profileIntervalMillis}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for profileIntervalMillis
   * @return modified copy of the {@code this} object
   */
  public final UserRecordingConfig withProfileIntervalMillis(int value) {
    if (this.profileIntervalMillis == value) {
      return this;
    }
    int newValue = value;
    return new UserRecordingConfig(this.enabled, this.user, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code UserRecordingConfig} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof UserRecordingConfig && equalTo((UserRecordingConfig) another));
  }
  
  private boolean equalTo(UserRecordingConfig another) {
    return enabled == another.enabled
        && user.equals(another.user)
        && profileIntervalMillis == another.profileIntervalMillis
        && version.equals(another.version);
  }
  
  /**
   * Computes hash code from attributes: {@code enabled}, {@code user}, {@code profileIntervalMillis}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Booleans.hashCode(enabled);
    h = h * 17 + user.hashCode();
    h = h * 17 + profileIntervalMillis;
    h = h * 17 + version.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code UserRecordingConfig{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("UserRecordingConfig")
        .add("enabled", enabled)
        .add("user", user)
        .add("profileIntervalMillis", profileIntervalMillis)
        .add("version", version)
        .toString();
  }
  
  @JsonCreator
  public static UserRecordingConfig fromAllAttributes(
      @JsonProperty("enabled") @Nullable Boolean enabled,
      @JsonProperty("user") @Nullable String user,
      @JsonProperty("profileIntervalMillis") @Nullable Integer profileIntervalMillis) {
    UserRecordingConfig.Builder builder = UserRecordingConfig.builder();
    if (enabled != null) {
      builder.enabled(enabled);
    }
    if (user != null) {
      builder.user(user);
    }
    if (profileIntervalMillis != null) {
      builder.profileIntervalMillis(profileIntervalMillis);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link UserRecordingConfigBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable UserRecordingConfig instance
   */
  public static UserRecordingConfig copyOf(UserRecordingConfigBase instance) {
    if (instance instanceof UserRecordingConfig) {
      return (UserRecordingConfig) instance;
    }
    return UserRecordingConfig.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.config.UserRecordingConfig}.
   * @return new UserRecordingConfig builder
   */
  public static UserRecordingConfig.Builder builder() {
    return new UserRecordingConfig.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.config.UserRecordingConfig}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long NONDEFAULT_BIT_ENABLED = 0x1L;
    private static final long NONDEFAULT_BIT_PROFILE_INTERVAL_MILLIS = 0x2L;
    private long nondefaultBitset;
  
    private boolean enabled;
    private @Nullable String user;
    private int profileIntervalMillis;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link UserRecordingConfigBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(UserRecordingConfigBase instance) {
      Preconditions.checkNotNull(instance);
      enabled(instance.enabled());
      user(instance.user());
      profileIntervalMillis(instance.profileIntervalMillis());
      return this;
    }
  
    /**
     * Initializes value for {@link UserRecordingConfigBase#enabled() enabled}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link UserRecordingConfigBase#enabled() enabled}.</em>
     * @param enabled value for enabled
     * @return {@code this} builder for chained invocation
     */
    public final Builder enabled(boolean enabled) {
      this.enabled = enabled;
      nondefaultBitset |= NONDEFAULT_BIT_ENABLED;
      return this;
    }
  
    /**
     * Initializes value for {@link UserRecordingConfigBase#user() user}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link UserRecordingConfigBase#user() user}.</em>
     * @param user value for user
     * @return {@code this} builder for chained invocation
     */
    public final Builder user(String user) {
      this.user = Preconditions.checkNotNull(user);
      return this;
    }
  
    /**
     * Initializes value for {@link UserRecordingConfigBase#profileIntervalMillis() profileIntervalMillis}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link UserRecordingConfigBase#profileIntervalMillis() profileIntervalMillis}.</em>
     * @param profileIntervalMillis value for profileIntervalMillis
     * @return {@code this} builder for chained invocation
     */
    public final Builder profileIntervalMillis(int profileIntervalMillis) {
      this.profileIntervalMillis = profileIntervalMillis;
      nondefaultBitset |= NONDEFAULT_BIT_PROFILE_INTERVAL_MILLIS;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.config.UserRecordingConfig}.
     * @return immutable instance of UserRecordingConfig
     */
    public UserRecordingConfig build() {
      return new UserRecordingConfig(this);
    }
  
    private boolean enabledIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_ENABLED) != 0;
    }
  
    private boolean profileIntervalMillisIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_PROFILE_INTERVAL_MILLIS) != 0;
    }
  }
}
