package org.glowroot.jvm;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Booleans;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link OptionalService.AvailabilityBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code Availability.builder()}.
 * Use static factory method to create immutable instances:
 * {@code Availability.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "OptionalService.AvailabilityBase"})
@Immutable
public final class Availability extends OptionalService.AvailabilityBase {
  private final boolean isAvailable;
  private final String reason;

  private Availability(boolean isAvailable, String reason) {
    this.isAvailable = isAvailable;
    this.reason = reason;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code isAvailable} attribute
   */
  @JsonProperty("isAvailable")
  @Override
  public boolean isAvailable() {
    return isAvailable;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code reason} attribute
   */
  @JsonProperty("reason")
  @Override
  public String getReason() {
    return reason;
  }
  
  /**
   * Copy current immutable object by setting value for {@link OptionalService.AvailabilityBase#isAvailable() isAvailable}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for isAvailable
   * @return modified copy of the {@code this} object
   */
  public final Availability withIsAvailable(boolean value) {
    if (this.isAvailable == value) {
      return this;
    }
    boolean newValue = value;
    return new Availability(newValue, this.reason);
  }
  
  /**
   * Copy current immutable object by setting value for {@link OptionalService.AvailabilityBase#getReason() reason}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for reason
   * @return modified copy of the {@code this} object
   */
  public final Availability withReason(String value) {
    if (this.reason == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new Availability(this.isAvailable, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code Availability} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof Availability && equalTo((Availability) another));
  }
  
  private boolean equalTo(Availability another) {
    return isAvailable == another.isAvailable
        && reason.equals(another.reason);
  }
  
  /**
   * Computes hash code from attributes: {@code isAvailable}, {@code reason}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Booleans.hashCode(isAvailable);
    h = h * 17 + reason.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code Availability{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Availability")
        .add("isAvailable", isAvailable)
        .add("reason", reason)
        .toString();
  }
  
  @JsonCreator
  public static Availability fromAllAttributes(
      @JsonProperty("isAvailable") @Nullable Boolean isAvailable,
      @JsonProperty("reason") @Nullable String reason) {
    Availability.Builder builder = Availability.builder();
    if (isAvailable != null) {
      builder.isAvailable(isAvailable);
    }
    if (reason != null) {
      builder.reason(reason);
    }
    return builder.build();
  }

  /**
   * Construct new immutable {@code Availability} instance.
   * @param isAvailable value for {@code isAvailable}
   * @param reason value for {@code reason}
   * @return immutable Availability instance
   */
  public static org.glowroot.jvm.Availability of(boolean isAvailable, String reason) {
    return new Availability(isAvailable, reason);
  }
  
  /**
   * Creates immutable copy of {@link OptionalService.AvailabilityBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable Availability instance
   */
  public static Availability copyOf(OptionalService.AvailabilityBase instance) {
    if (instance instanceof Availability) {
      return (Availability) instance;
    }
    return Availability.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.jvm.Availability}.
   * @return new Availability builder
   */
  public static Availability.Builder builder() {
    return new Availability.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.jvm.Availability}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_IS_AVAILABLE = 0x1L;
    private static final long INITIALIZED_BIT_REASON = 0x2L;
    private long initializedBitset;
  
    private boolean isAvailable;
    private @Nullable String reason;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link OptionalService.AvailabilityBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(OptionalService.AvailabilityBase instance) {
      Preconditions.checkNotNull(instance);
      isAvailable(instance.isAvailable());
      reason(instance.getReason());
      return this;
    }
  
    /**
     * Initializes value for {@link OptionalService.AvailabilityBase#isAvailable() isAvailable}.
     * @param isAvailable value for isAvailable
     * @return {@code this} builder for chained invocation
     */
    public final Builder isAvailable(boolean isAvailable) {
      this.isAvailable = isAvailable;
      initializedBitset |= INITIALIZED_BIT_IS_AVAILABLE;
      return this;
    }
  
    /**
     * Initializes value for {@link OptionalService.AvailabilityBase#getReason() reason}.
     * @param reason value for reason
     * @return {@code this} builder for chained invocation
     */
    public final Builder reason(String reason) {
      this.reason = Preconditions.checkNotNull(reason);
      initializedBitset |= INITIALIZED_BIT_REASON;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.jvm.Availability}.
     * @return immutable instance of Availability
     */
    public Availability build() {
      checkRequiredAttributes();
      return new Availability(isAvailable, reason);
    }
  
    private boolean isAvailableIsSet() {
      return (initializedBitset & INITIALIZED_BIT_IS_AVAILABLE) != 0;
    }
  
    private boolean reasonIsSet() {
      return (initializedBitset & INITIALIZED_BIT_REASON) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!isAvailableIsSet()) {
        attributes.add("isAvailable");
      }
      if (!reasonIsSet()) {
        attributes.add("reason");
      }
      return "Cannot build Availability, some of required attributes are not set " + attributes;
    }
  }
}
