package org.glowroot.local.store;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.checkerframework.checker.tainting.qual.Untainted;

/**
 * Immutable implementation of {@link ParameterizedSqlBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ParameterizedSql.builder()}.
 * Use static factory method to create immutable instances:
 * {@code ParameterizedSql.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ParameterizedSqlBase"})
@Immutable
final class ParameterizedSql extends ParameterizedSqlBase {
  private final String sql;
  private final ImmutableList<java.lang.Object> args;

  private ParameterizedSql(String sql, Iterable<? extends java.lang.Object> args) {
    this.sql = Preconditions.checkNotNull(sql);
    this.args = ImmutableList.copyOf(args);
  }

  private ParameterizedSql(
      ParameterizedSql original,
      String sql,
      ImmutableList<java.lang.Object> args) {
    this.sql = sql;
    this.args = args;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code sql} attribute
   */
  @Untainted
  @Override
  public String sql() {
    return sql;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code args} attribute
   */
  @Override
  public ImmutableList<java.lang.Object> args() {
    return args;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ParameterizedSqlBase#sql() sql}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for sql
   * @return modified copy of the {@code this} object
   */
  public final ParameterizedSql withSql(String value) {
    if (this.sql == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ParameterizedSql(this, newValue, this.args);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ParameterizedSqlBase#args() args}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final ParameterizedSql withArgs(java.lang.Object... elements) {
    ImmutableList<java.lang.Object> newValue = ImmutableList.copyOf(elements);
    return new ParameterizedSql(this, this.sql, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link ParameterizedSqlBase#args() args}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of args elements to set
   * @return modified copy of {@code this} object
   */
  public final ParameterizedSql withArgs(Iterable<? extends java.lang.Object> elements) {
    if (this.args == elements) {
      return this;
    }
    ImmutableList<java.lang.Object> newValue = ImmutableList.copyOf(elements);
    return new ParameterizedSql(this, this.sql, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ParameterizedSql} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ParameterizedSql && equalTo((ParameterizedSql) another));
  }
  
  private boolean equalTo(ParameterizedSql another) {
    return sql.equals(another.sql)
        && args.equals(another.args);
  }
  
  /**
   * Computes hash code from attributes: {@code sql}, {@code args}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + sql.hashCode();
    h = h * 17 + args.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code ParameterizedSql{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ParameterizedSql")
        .add("sql", sql)
        .add("args", args)
        .toString();
  }

  /**
   * Construct new immutable {@code ParameterizedSql} instance.
   * @param sql value for {@code sql}
   * @param args value for {@code args}
   * @return immutable ParameterizedSql instance
   */
  public static org.glowroot.local.store.ParameterizedSql of(String sql, ImmutableList<java.lang.Object> args) {
    return of(sql, (Iterable<? extends java.lang.Object>) args);
  }

  /**
   * Construct new immutable {@code ParameterizedSql} instance.
   * @param sql value for {@code sql}
   * @param args value for {@code args}
   * @return immutable ParameterizedSql instance
   */
  public static org.glowroot.local.store.ParameterizedSql of(String sql, Iterable<? extends java.lang.Object> args) {
    return new ParameterizedSql(sql, args);
  }
  
  /**
   * Creates immutable copy of {@link ParameterizedSqlBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable ParameterizedSql instance
   */
  static ParameterizedSql copyOf(ParameterizedSqlBase instance) {
    if (instance instanceof ParameterizedSql) {
      return (ParameterizedSql) instance;
    }
    return ParameterizedSql.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.store.ParameterizedSql}.
   * @return new ParameterizedSql builder
   */
  static ParameterizedSql.Builder builder() {
    return new ParameterizedSql.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.store.ParameterizedSql}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_SQL = 0x1L;
    private long initializedBitset;
  
    private @Nullable String sql;
    private ImmutableList.Builder<java.lang.Object> argsBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link ParameterizedSqlBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(ParameterizedSqlBase instance) {
      Preconditions.checkNotNull(instance);
      sql(instance.sql());
      addAllArgs(instance.args());
      return this;
    }
  
    /**
     * Initializes value for {@link ParameterizedSqlBase#sql() sql}.
     * @param sql value for sql
     * @return {@code this} builder for chained invocation
     */
    public final Builder sql(String sql) {
      this.sql = Preconditions.checkNotNull(sql);
      initializedBitset |= INITIALIZED_BIT_SQL;
      return this;
    }
  
    /**
     * Adds one element to {@link ParameterizedSqlBase#args() args} list.
     * @param element args element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addArgs(java.lang.Object element) {
      argsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link ParameterizedSqlBase#args() args} list.
     * @param elements array of args elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addArgs(java.lang.Object... elements) {
      argsBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link ParameterizedSqlBase#args() args} list.
     * @param elements iterable of args elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder args(Iterable<? extends java.lang.Object> elements) {
      argsBuilder = ImmutableList.builder();
      return addAllArgs(elements);
    }
  
    /**
     * Adds elements to {@link ParameterizedSqlBase#args() args} list.
     * @param elements iterable of args elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllArgs(Iterable<? extends java.lang.Object> elements) {
      argsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.store.ParameterizedSql}.
     * @return immutable instance of ParameterizedSql
     */
    public org.glowroot.local.store.ParameterizedSql build() {
      checkRequiredAttributes();
      return new ParameterizedSql(null, sql, argsBuilder.build());
    }
  
    private boolean sqlIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SQL) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!sqlIsSet()) {
        attributes.add("sql");
      }
      return "Cannot build ParameterizedSql, some of required attributes are not set " + attributes;
    }
  }
}
