package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import org.glowroot.shaded.google.common.primitives.Longs;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.glowroot.local.store.AggregateDao;

/**
 * Immutable implementation of {@link ErrorJsonService.ErrorSummaryRequestBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code ErrorSummaryRequest.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ErrorJsonService.ErrorSummaryRequestBase"})
@Immutable
final class ErrorSummaryRequest extends ErrorJsonService.ErrorSummaryRequestBase {
  private final long from;
  private final long to;
  private final String transactionType;
  private final AggregateDao.ErrorSummarySortOrder sortOrder;
  private final int limit;

  private ErrorSummaryRequest(
      long from,
      long to,
      String transactionType,
      AggregateDao.ErrorSummarySortOrder sortOrder,
      int limit) {
    this.from = from;
    this.to = to;
    this.transactionType = transactionType;
    this.sortOrder = sortOrder;
    this.limit = limit;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code from} attribute
   */
  @JsonProperty("from")
  @Override
  public long from() {
    return from;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code to} attribute
   */
  @JsonProperty("to")
  @Override
  public long to() {
    return to;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code transactionType} attribute
   */
  @JsonProperty("transactionType")
  @Override
  public String transactionType() {
    return transactionType;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code sortOrder} attribute
   */
  @JsonProperty("sortOrder")
  @Override
  public AggregateDao.ErrorSummarySortOrder sortOrder() {
    return sortOrder;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code limit} attribute
   */
  @JsonProperty("limit")
  @Override
  public int limit() {
    return limit;
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorJsonService.ErrorSummaryRequestBase#from() from}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for from
   * @return modified copy of the {@code this} object
   */
  public final ErrorSummaryRequest withFrom(long value) {
    if (this.from == value) {
      return this;
    }
    long newValue = value;
    return new ErrorSummaryRequest(newValue, this.to, this.transactionType, this.sortOrder, this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorJsonService.ErrorSummaryRequestBase#to() to}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for to
   * @return modified copy of the {@code this} object
   */
  public final ErrorSummaryRequest withTo(long value) {
    if (this.to == value) {
      return this;
    }
    long newValue = value;
    return new ErrorSummaryRequest(this.from, newValue, this.transactionType, this.sortOrder, this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorJsonService.ErrorSummaryRequestBase#transactionType() transactionType}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for transactionType
   * @return modified copy of the {@code this} object
   */
  public final ErrorSummaryRequest withTransactionType(String value) {
    if (this.transactionType == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new ErrorSummaryRequest(this.from, this.to, newValue, this.sortOrder, this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorJsonService.ErrorSummaryRequestBase#sortOrder() sortOrder}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for sortOrder
   * @return modified copy of the {@code this} object
   */
  public final ErrorSummaryRequest withSortOrder(AggregateDao.ErrorSummarySortOrder value) {
    if (this.sortOrder == value) {
      return this;
    }
    AggregateDao.ErrorSummarySortOrder newValue = Preconditions.checkNotNull(value);
    return new ErrorSummaryRequest(this.from, this.to, this.transactionType, newValue, this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link ErrorJsonService.ErrorSummaryRequestBase#limit() limit}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for limit
   * @return modified copy of the {@code this} object
   */
  public final ErrorSummaryRequest withLimit(int value) {
    if (this.limit == value) {
      return this;
    }
    int newValue = value;
    return new ErrorSummaryRequest(this.from, this.to, this.transactionType, this.sortOrder, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code ErrorSummaryRequest} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof ErrorSummaryRequest && equalTo((ErrorSummaryRequest) another));
  }
  
  private boolean equalTo(ErrorSummaryRequest another) {
    return from == another.from
        && to == another.to
        && transactionType.equals(another.transactionType)
        && sortOrder.equals(another.sortOrder)
        && limit == another.limit;
  }
  
  /**
   * Computes hash code from attributes: {@code from}, {@code to}, {@code transactionType}, {@code sortOrder}, {@code limit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Longs.hashCode(from);
    h = h * 17 + Longs.hashCode(to);
    h = h * 17 + transactionType.hashCode();
    h = h * 17 + sortOrder.hashCode();
    h = h * 17 + limit;
    return h;
  }
  
  /**
   * Prints immutable value {@code ErrorSummaryRequest{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ErrorSummaryRequest")
        .add("from", from)
        .add("to", to)
        .add("transactionType", transactionType)
        .add("sortOrder", sortOrder)
        .add("limit", limit)
        .toString();
  }
  
  @JsonCreator
  public static ErrorSummaryRequest fromAllAttributes(
      @JsonProperty("from") @Nullable Long from,
      @JsonProperty("to") @Nullable Long to,
      @JsonProperty("transactionType") @Nullable String transactionType,
      @JsonProperty("sortOrder") @Nullable AggregateDao.ErrorSummarySortOrder sortOrder,
      @JsonProperty("limit") @Nullable Integer limit) {
    ErrorSummaryRequest.Builder builder = ErrorSummaryRequest.builder();
    if (from != null) {
      builder.from(from);
    }
    if (to != null) {
      builder.to(to);
    }
    if (transactionType != null) {
      builder.transactionType(transactionType);
    }
    if (sortOrder != null) {
      builder.sortOrder(sortOrder);
    }
    if (limit != null) {
      builder.limit(limit);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link ErrorJsonService.ErrorSummaryRequestBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable ErrorSummaryRequest instance
   */
  static ErrorSummaryRequest copyOf(ErrorJsonService.ErrorSummaryRequestBase instance) {
    if (instance instanceof ErrorSummaryRequest) {
      return (ErrorSummaryRequest) instance;
    }
    return ErrorSummaryRequest.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.ErrorSummaryRequest}.
   * @return new ErrorSummaryRequest builder
   */
  static ErrorSummaryRequest.Builder builder() {
    return new ErrorSummaryRequest.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.ErrorSummaryRequest}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1f;
    private static final long INITIALIZED_BIT_FROM = 0x1L;
    private static final long INITIALIZED_BIT_TO = 0x2L;
    private static final long INITIALIZED_BIT_TRANSACTION_TYPE = 0x4L;
    private static final long INITIALIZED_BIT_SORT_ORDER = 0x8L;
    private static final long INITIALIZED_BIT_LIMIT = 0x10L;
    private long initializedBitset;
  
    private long from;
    private long to;
    private @Nullable String transactionType;
    private @Nullable AggregateDao.ErrorSummarySortOrder sortOrder;
    private int limit;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link ErrorJsonService.ErrorSummaryRequestBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(ErrorJsonService.ErrorSummaryRequestBase instance) {
      Preconditions.checkNotNull(instance);
      from(instance.from());
      to(instance.to());
      transactionType(instance.transactionType());
      sortOrder(instance.sortOrder());
      limit(instance.limit());
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorJsonService.ErrorSummaryRequestBase#from() from}.
     * @param from value for from
     * @return {@code this} builder for chained invocation
     */
    public final Builder from(long from) {
      this.from = from;
      initializedBitset |= INITIALIZED_BIT_FROM;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorJsonService.ErrorSummaryRequestBase#to() to}.
     * @param to value for to
     * @return {@code this} builder for chained invocation
     */
    public final Builder to(long to) {
      this.to = to;
      initializedBitset |= INITIALIZED_BIT_TO;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorJsonService.ErrorSummaryRequestBase#transactionType() transactionType}.
     * @param transactionType value for transactionType
     * @return {@code this} builder for chained invocation
     */
    public final Builder transactionType(String transactionType) {
      this.transactionType = Preconditions.checkNotNull(transactionType);
      initializedBitset |= INITIALIZED_BIT_TRANSACTION_TYPE;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorJsonService.ErrorSummaryRequestBase#sortOrder() sortOrder}.
     * @param sortOrder value for sortOrder
     * @return {@code this} builder for chained invocation
     */
    public final Builder sortOrder(AggregateDao.ErrorSummarySortOrder sortOrder) {
      this.sortOrder = Preconditions.checkNotNull(sortOrder);
      initializedBitset |= INITIALIZED_BIT_SORT_ORDER;
      return this;
    }
  
    /**
     * Initializes value for {@link ErrorJsonService.ErrorSummaryRequestBase#limit() limit}.
     * @param limit value for limit
     * @return {@code this} builder for chained invocation
     */
    public final Builder limit(int limit) {
      this.limit = limit;
      initializedBitset |= INITIALIZED_BIT_LIMIT;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.ErrorSummaryRequest}.
     * @return immutable instance of ErrorSummaryRequest
     */
    public org.glowroot.local.ui.ErrorSummaryRequest build() {
      checkRequiredAttributes();
      return new ErrorSummaryRequest(from, to, transactionType, sortOrder, limit);
    }
  
    private boolean fromIsSet() {
      return (initializedBitset & INITIALIZED_BIT_FROM) != 0;
    }
  
    private boolean toIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TO) != 0;
    }
  
    private boolean transactionTypeIsSet() {
      return (initializedBitset & INITIALIZED_BIT_TRANSACTION_TYPE) != 0;
    }
  
    private boolean sortOrderIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SORT_ORDER) != 0;
    }
  
    private boolean limitIsSet() {
      return (initializedBitset & INITIALIZED_BIT_LIMIT) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!fromIsSet()) {
        attributes.add("from");
      }
      if (!toIsSet()) {
        attributes.add("to");
      }
      if (!transactionTypeIsSet()) {
        attributes.add("transactionType");
      }
      if (!sortOrderIsSet()) {
        attributes.add("sortOrder");
      }
      if (!limitIsSet()) {
        attributes.add("limit");
      }
      return "Cannot build ErrorSummaryRequest, some of required attributes are not set " + attributes;
    }
  }
}
