package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link InstrumentationJsonService.InstrumentationErrorResponseBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code InstrumentationErrorResponse.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "InstrumentationJsonService.InstrumentationErrorResponseBase"})
@Immutable
final class InstrumentationErrorResponse
    extends InstrumentationJsonService.InstrumentationErrorResponseBase {
  private final ImmutableList<String> errors;

  private InstrumentationErrorResponse(ImmutableList<String> errors) {
    this.errors = errors;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code errors} attribute
   */
  @JsonProperty("errors")
  @Override
  public ImmutableList<String> errors() {
    return errors;
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.InstrumentationErrorResponseBase#errors() errors}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationErrorResponse withErrors(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationErrorResponse(newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link InstrumentationJsonService.InstrumentationErrorResponseBase#errors() errors}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of errors elements to set
   * @return modified copy of {@code this} object
   */
  public final InstrumentationErrorResponse withErrors(Iterable<String> elements) {
    if (this.errors == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new InstrumentationErrorResponse(newValue);
  }
  
  /**
   * This instance is equal to instances of {@code InstrumentationErrorResponse} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof InstrumentationErrorResponse && equalTo((InstrumentationErrorResponse) another));
  }
  
  private boolean equalTo(InstrumentationErrorResponse another) {
    return errors.equals(another.errors);
  }
  
  /**
   * Computes hash code from attributes: {@code errors}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + errors.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code InstrumentationErrorResponse{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("InstrumentationErrorResponse")
        .add("errors", errors)
        .toString();
  }
  
  @JsonCreator
  public static InstrumentationErrorResponse fromAllAttributes(
      @JsonProperty("errors") @Nullable ImmutableList<String> errors) {
    InstrumentationErrorResponse.Builder builder = InstrumentationErrorResponse.builder();
    if (errors != null) {
      builder.addAllErrors(errors);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link InstrumentationJsonService.InstrumentationErrorResponseBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable InstrumentationErrorResponse instance
   */
  static InstrumentationErrorResponse copyOf(InstrumentationJsonService.InstrumentationErrorResponseBase instance) {
    if (instance instanceof InstrumentationErrorResponse) {
      return (InstrumentationErrorResponse) instance;
    }
    return InstrumentationErrorResponse.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.InstrumentationErrorResponse}.
   * @return new InstrumentationErrorResponse builder
   */
  static InstrumentationErrorResponse.Builder builder() {
    return new InstrumentationErrorResponse.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.InstrumentationErrorResponse}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
  
    private ImmutableList.Builder<String> errorsBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link InstrumentationJsonService.InstrumentationErrorResponseBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(InstrumentationJsonService.InstrumentationErrorResponseBase instance) {
      Preconditions.checkNotNull(instance);
      addAllErrors(instance.errors());
      return this;
    }
  
    /**
     * Adds one element to {@link InstrumentationJsonService.InstrumentationErrorResponseBase#errors() errors} list.
     * @param element errors element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addErrors(String element) {
      errorsBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.InstrumentationErrorResponseBase#errors() errors} list.
     * @param elements array of errors elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addErrors(String... elements) {
      errorsBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link InstrumentationJsonService.InstrumentationErrorResponseBase#errors() errors} list.
     * @param elements iterable of errors elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder errors(Iterable<String> elements) {
      errorsBuilder = ImmutableList.builder();
      return addAllErrors(elements);
    }
  
    /**
     * Adds elements to {@link InstrumentationJsonService.InstrumentationErrorResponseBase#errors() errors} list.
     * @param elements iterable of errors elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllErrors(Iterable<String> elements) {
      errorsBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.InstrumentationErrorResponse}.
     * @return immutable instance of InstrumentationErrorResponse
     */
    public org.glowroot.local.ui.InstrumentationErrorResponse build() {
      return new InstrumentationErrorResponse(errorsBuilder.build());
    }
  }
}
