package org.glowroot.local.ui;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link HttpServerHandler.JsonServiceMappingBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code JsonServiceMapping.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "HttpServerHandler.JsonServiceMappingBase"})
@Immutable
final class JsonServiceMapping extends HttpServerHandler.JsonServiceMappingBase {
  private final HttpServerHandler.HttpMethod httpMethod;
  private final String path;
  private final java.lang.Object service;
  private final String methodName;
  private final Pattern pattern;

  private JsonServiceMapping(
      HttpServerHandler.HttpMethod httpMethod,
      String path,
      java.lang.Object service,
      String methodName) {
    this.httpMethod = httpMethod;
    this.path = path;
    this.service = service;
    this.methodName = methodName;
    this.pattern = Preconditions.checkNotNull(super.pattern());
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code httpMethod} attribute
   */
  @Override
  public HttpServerHandler.HttpMethod httpMethod() {
    return httpMethod;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code path} attribute
   */
  @Override
  public String path() {
    return path;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code service} attribute
   */
  @Override
  public java.lang.Object service() {
    return service;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code methodName} attribute
   */
  @Override
  public String methodName() {
    return methodName;
  }
  
  /**
   * {@inheritDoc}
   * @return computed at construction value of {@code pattern} attribute
   */
  @Override
  public Pattern pattern() {
    return pattern;
  }
  
  /**
   * Copy current immutable object by setting value for {@link HttpServerHandler.JsonServiceMappingBase#httpMethod() httpMethod}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for httpMethod
   * @return modified copy of the {@code this} object
   */
  public final JsonServiceMapping withHttpMethod(HttpServerHandler.HttpMethod value) {
    if (this.httpMethod == value) {
      return this;
    }
    HttpServerHandler.HttpMethod newValue = Preconditions.checkNotNull(value);
    return new JsonServiceMapping(newValue, this.path, this.service, this.methodName);
  }
  
  /**
   * Copy current immutable object by setting value for {@link HttpServerHandler.JsonServiceMappingBase#path() path}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for path
   * @return modified copy of the {@code this} object
   */
  public final JsonServiceMapping withPath(String value) {
    if (this.path == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new JsonServiceMapping(this.httpMethod, newValue, this.service, this.methodName);
  }
  
  /**
   * Copy current immutable object by setting value for {@link HttpServerHandler.JsonServiceMappingBase#service() service}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for service
   * @return modified copy of the {@code this} object
   */
  public final JsonServiceMapping withService(java.lang.Object value) {
    if (this.service == value) {
      return this;
    }
    java.lang.Object newValue = Preconditions.checkNotNull(value);
    return new JsonServiceMapping(this.httpMethod, this.path, newValue, this.methodName);
  }
  
  /**
   * Copy current immutable object by setting value for {@link HttpServerHandler.JsonServiceMappingBase#methodName() methodName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for methodName
   * @return modified copy of the {@code this} object
   */
  public final JsonServiceMapping withMethodName(String value) {
    if (this.methodName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new JsonServiceMapping(this.httpMethod, this.path, this.service, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code JsonServiceMapping} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof JsonServiceMapping && equalTo((JsonServiceMapping) another));
  }
  
  private boolean equalTo(JsonServiceMapping another) {
    return httpMethod.equals(another.httpMethod)
        && path.equals(another.path)
        && service.equals(another.service)
        && methodName.equals(another.methodName)
        && pattern.equals(another.pattern);
  }
  
  /**
   * Computes hash code from attributes: {@code httpMethod}, {@code path}, {@code service}, {@code methodName}, {@code pattern}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + httpMethod.hashCode();
    h = h * 17 + path.hashCode();
    h = h * 17 + service.hashCode();
    h = h * 17 + methodName.hashCode();
    h = h * 17 + pattern.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code JsonServiceMapping{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("JsonServiceMapping")
        .add("httpMethod", httpMethod)
        .add("path", path)
        .add("service", service)
        .add("methodName", methodName)
        .add("pattern", pattern)
        .toString();
  }
  
  /**
   * Creates immutable copy of {@link HttpServerHandler.JsonServiceMappingBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable JsonServiceMapping instance
   */
  static JsonServiceMapping copyOf(HttpServerHandler.JsonServiceMappingBase instance) {
    if (instance instanceof JsonServiceMapping) {
      return (JsonServiceMapping) instance;
    }
    return JsonServiceMapping.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.JsonServiceMapping}.
   * @return new JsonServiceMapping builder
   */
  static JsonServiceMapping.Builder builder() {
    return new JsonServiceMapping.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.JsonServiceMapping}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0xf;
    private static final long INITIALIZED_BIT_HTTP_METHOD = 0x1L;
    private static final long INITIALIZED_BIT_PATH = 0x2L;
    private static final long INITIALIZED_BIT_SERVICE = 0x4L;
    private static final long INITIALIZED_BIT_METHOD_NAME = 0x8L;
    private long initializedBitset;
  
    private @Nullable HttpServerHandler.HttpMethod httpMethod;
    private @Nullable String path;
    private @Nullable java.lang.Object service;
    private @Nullable String methodName;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link HttpServerHandler.JsonServiceMappingBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(HttpServerHandler.JsonServiceMappingBase instance) {
      Preconditions.checkNotNull(instance);
      httpMethod(instance.httpMethod());
      path(instance.path());
      service(instance.service());
      methodName(instance.methodName());
      return this;
    }
  
    /**
     * Initializes value for {@link HttpServerHandler.JsonServiceMappingBase#httpMethod() httpMethod}.
     * @param httpMethod value for httpMethod
     * @return {@code this} builder for chained invocation
     */
    public final Builder httpMethod(HttpServerHandler.HttpMethod httpMethod) {
      this.httpMethod = Preconditions.checkNotNull(httpMethod);
      initializedBitset |= INITIALIZED_BIT_HTTP_METHOD;
      return this;
    }
  
    /**
     * Initializes value for {@link HttpServerHandler.JsonServiceMappingBase#path() path}.
     * @param path value for path
     * @return {@code this} builder for chained invocation
     */
    public final Builder path(String path) {
      this.path = Preconditions.checkNotNull(path);
      initializedBitset |= INITIALIZED_BIT_PATH;
      return this;
    }
  
    /**
     * Initializes value for {@link HttpServerHandler.JsonServiceMappingBase#service() service}.
     * @param service value for service
     * @return {@code this} builder for chained invocation
     */
    public final Builder service(java.lang.Object service) {
      this.service = Preconditions.checkNotNull(service);
      initializedBitset |= INITIALIZED_BIT_SERVICE;
      return this;
    }
  
    /**
     * Initializes value for {@link HttpServerHandler.JsonServiceMappingBase#methodName() methodName}.
     * @param methodName value for methodName
     * @return {@code this} builder for chained invocation
     */
    public final Builder methodName(String methodName) {
      this.methodName = Preconditions.checkNotNull(methodName);
      initializedBitset |= INITIALIZED_BIT_METHOD_NAME;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.JsonServiceMapping}.
     * @return immutable instance of JsonServiceMapping
     */
    public org.glowroot.local.ui.JsonServiceMapping build() {
      checkRequiredAttributes();
      return new JsonServiceMapping(httpMethod, path, service, methodName);
    }
  
    private boolean httpMethodIsSet() {
      return (initializedBitset & INITIALIZED_BIT_HTTP_METHOD) != 0;
    }
  
    private boolean pathIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PATH) != 0;
    }
  
    private boolean serviceIsSet() {
      return (initializedBitset & INITIALIZED_BIT_SERVICE) != 0;
    }
  
    private boolean methodNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_METHOD_NAME) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!httpMethodIsSet()) {
        attributes.add("httpMethod");
      }
      if (!pathIsSet()) {
        attributes.add("path");
      }
      if (!serviceIsSet()) {
        attributes.add("service");
      }
      if (!methodNameIsSet()) {
        attributes.add("methodName");
      }
      return "Cannot build JsonServiceMapping, some of required attributes are not set " + attributes;
    }
  }
}
