package org.glowroot.local.ui;

import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import java.util.regex.Matcher;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link HttpServerHandler.JsonServiceMatcherBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code JsonServiceMatcher.builder()}.
 * Use static factory method to create immutable instances:
 * {@code JsonServiceMatcher.of()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "HttpServerHandler.JsonServiceMatcherBase"})
@Immutable
final class JsonServiceMatcher extends HttpServerHandler.JsonServiceMatcherBase {
  private final JsonServiceMapping jsonServiceMapping;
  private final Matcher matcher;

  private JsonServiceMatcher(JsonServiceMapping jsonServiceMapping, Matcher matcher) {
    this.jsonServiceMapping = jsonServiceMapping;
    this.matcher = matcher;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code jsonServiceMapping} attribute
   */
  @Override
  public JsonServiceMapping jsonServiceMapping() {
    return jsonServiceMapping;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code matcher} attribute
   */
  @Override
  public Matcher matcher() {
    return matcher;
  }
  
  /**
   * Copy current immutable object by setting value for {@link HttpServerHandler.JsonServiceMatcherBase#jsonServiceMapping() jsonServiceMapping}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for jsonServiceMapping
   * @return modified copy of the {@code this} object
   */
  public final JsonServiceMatcher withJsonServiceMapping(JsonServiceMapping value) {
    if (this.jsonServiceMapping == value) {
      return this;
    }
    JsonServiceMapping newValue = Preconditions.checkNotNull(value);
    return new JsonServiceMatcher(newValue, this.matcher);
  }
  
  /**
   * Copy current immutable object by setting value for {@link HttpServerHandler.JsonServiceMatcherBase#matcher() matcher}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for matcher
   * @return modified copy of the {@code this} object
   */
  public final JsonServiceMatcher withMatcher(Matcher value) {
    if (this.matcher == value) {
      return this;
    }
    Matcher newValue = Preconditions.checkNotNull(value);
    return new JsonServiceMatcher(this.jsonServiceMapping, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code JsonServiceMatcher} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof JsonServiceMatcher && equalTo((JsonServiceMatcher) another));
  }
  
  private boolean equalTo(JsonServiceMatcher another) {
    return jsonServiceMapping.equals(another.jsonServiceMapping)
        && matcher.equals(another.matcher);
  }
  
  /**
   * Computes hash code from attributes: {@code jsonServiceMapping}, {@code matcher}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + jsonServiceMapping.hashCode();
    h = h * 17 + matcher.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code JsonServiceMatcher{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("JsonServiceMatcher")
        .add("jsonServiceMapping", jsonServiceMapping)
        .add("matcher", matcher)
        .toString();
  }

  /**
   * Construct new immutable {@code JsonServiceMatcher} instance.
   * @param jsonServiceMapping value for {@code jsonServiceMapping}
   * @param matcher value for {@code matcher}
   * @return immutable JsonServiceMatcher instance
   */
  public static org.glowroot.local.ui.JsonServiceMatcher of(JsonServiceMapping jsonServiceMapping, Matcher matcher) {
    return new JsonServiceMatcher(jsonServiceMapping, matcher);
  }
  
  /**
   * Creates immutable copy of {@link HttpServerHandler.JsonServiceMatcherBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable JsonServiceMatcher instance
   */
  static JsonServiceMatcher copyOf(HttpServerHandler.JsonServiceMatcherBase instance) {
    if (instance instanceof JsonServiceMatcher) {
      return (JsonServiceMatcher) instance;
    }
    return JsonServiceMatcher.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.JsonServiceMatcher}.
   * @return new JsonServiceMatcher builder
   */
  static JsonServiceMatcher.Builder builder() {
    return new JsonServiceMatcher.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.JsonServiceMatcher}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_JSON_SERVICE_MAPPING = 0x1L;
    private static final long INITIALIZED_BIT_MATCHER = 0x2L;
    private long initializedBitset;
  
    private @Nullable JsonServiceMapping jsonServiceMapping;
    private @Nullable Matcher matcher;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link HttpServerHandler.JsonServiceMatcherBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(HttpServerHandler.JsonServiceMatcherBase instance) {
      Preconditions.checkNotNull(instance);
      jsonServiceMapping(instance.jsonServiceMapping());
      matcher(instance.matcher());
      return this;
    }
  
    /**
     * Initializes value for {@link HttpServerHandler.JsonServiceMatcherBase#jsonServiceMapping() jsonServiceMapping}.
     * @param jsonServiceMapping value for jsonServiceMapping
     * @return {@code this} builder for chained invocation
     */
    public final Builder jsonServiceMapping(JsonServiceMapping jsonServiceMapping) {
      this.jsonServiceMapping = Preconditions.checkNotNull(jsonServiceMapping);
      initializedBitset |= INITIALIZED_BIT_JSON_SERVICE_MAPPING;
      return this;
    }
  
    /**
     * Initializes value for {@link HttpServerHandler.JsonServiceMatcherBase#matcher() matcher}.
     * @param matcher value for matcher
     * @return {@code this} builder for chained invocation
     */
    public final Builder matcher(Matcher matcher) {
      this.matcher = Preconditions.checkNotNull(matcher);
      initializedBitset |= INITIALIZED_BIT_MATCHER;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.JsonServiceMatcher}.
     * @return immutable instance of JsonServiceMatcher
     */
    public org.glowroot.local.ui.JsonServiceMatcher build() {
      checkRequiredAttributes();
      return new JsonServiceMatcher(jsonServiceMapping, matcher);
    }
  
    private boolean jsonServiceMappingIsSet() {
      return (initializedBitset & INITIALIZED_BIT_JSON_SERVICE_MAPPING) != 0;
    }
  
    private boolean matcherIsSet() {
      return (initializedBitset & INITIALIZED_BIT_MATCHER) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!jsonServiceMappingIsSet()) {
        attributes.add("jsonServiceMapping");
      }
      if (!matcherIsSet()) {
        attributes.add("matcher");
      }
      return "Cannot build JsonServiceMatcher, some of required attributes are not set " + attributes;
    }
  }
}
