package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link JvmJsonService.MBeanAttributeMapRequestBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code MBeanAttributeMapRequest.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "JvmJsonService.MBeanAttributeMapRequestBase"})
@Immutable
final class MBeanAttributeMapRequest
    extends JvmJsonService.MBeanAttributeMapRequestBase {
  private final String objectName;

  private MBeanAttributeMapRequest(String objectName) {
    this.objectName = objectName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code objectName} attribute
   */
  @JsonProperty("objectName")
  @Override
  public String objectName() {
    return objectName;
  }
  
  /**
   * Copy current immutable object by setting value for {@link JvmJsonService.MBeanAttributeMapRequestBase#objectName() objectName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for objectName
   * @return modified copy of the {@code this} object
   */
  public final MBeanAttributeMapRequest withObjectName(String value) {
    if (this.objectName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new MBeanAttributeMapRequest(newValue);
  }
  
  /**
   * This instance is equal to instances of {@code MBeanAttributeMapRequest} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof MBeanAttributeMapRequest && equalTo((MBeanAttributeMapRequest) another));
  }
  
  private boolean equalTo(MBeanAttributeMapRequest another) {
    return objectName.equals(another.objectName);
  }
  
  /**
   * Computes hash code from attributes: {@code objectName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + objectName.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code MBeanAttributeMapRequest{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MBeanAttributeMapRequest")
        .add("objectName", objectName)
        .toString();
  }
  
  @JsonCreator
  public static MBeanAttributeMapRequest fromAllAttributes(
      @JsonProperty("objectName") @Nullable String objectName) {
    MBeanAttributeMapRequest.Builder builder = MBeanAttributeMapRequest.builder();
    if (objectName != null) {
      builder.objectName(objectName);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link JvmJsonService.MBeanAttributeMapRequestBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable MBeanAttributeMapRequest instance
   */
  static MBeanAttributeMapRequest copyOf(JvmJsonService.MBeanAttributeMapRequestBase instance) {
    if (instance instanceof MBeanAttributeMapRequest) {
      return (MBeanAttributeMapRequest) instance;
    }
    return MBeanAttributeMapRequest.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.MBeanAttributeMapRequest}.
   * @return new MBeanAttributeMapRequest builder
   */
  static MBeanAttributeMapRequest.Builder builder() {
    return new MBeanAttributeMapRequest.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.MBeanAttributeMapRequest}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x1;
    private static final long INITIALIZED_BIT_OBJECT_NAME = 0x1L;
    private long initializedBitset;
  
    private @Nullable String objectName;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link JvmJsonService.MBeanAttributeMapRequestBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(JvmJsonService.MBeanAttributeMapRequestBase instance) {
      Preconditions.checkNotNull(instance);
      objectName(instance.objectName());
      return this;
    }
  
    /**
     * Initializes value for {@link JvmJsonService.MBeanAttributeMapRequestBase#objectName() objectName}.
     * @param objectName value for objectName
     * @return {@code this} builder for chained invocation
     */
    public final Builder objectName(String objectName) {
      this.objectName = Preconditions.checkNotNull(objectName);
      initializedBitset |= INITIALIZED_BIT_OBJECT_NAME;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.MBeanAttributeMapRequest}.
     * @return immutable instance of MBeanAttributeMapRequest
     */
    public org.glowroot.local.ui.MBeanAttributeMapRequest build() {
      checkRequiredAttributes();
      return new MBeanAttributeMapRequest(objectName);
    }
  
    private boolean objectNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_OBJECT_NAME) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!objectNameIsSet()) {
        attributes.add("objectName");
      }
      return "Cannot build MBeanAttributeMapRequest, some of required attributes are not set " + attributes;
    }
  }
}
