package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import org.glowroot.shaded.google.common.primitives.Booleans;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link GaugeJsonService.MBeanAttributeNamesResponseBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code MBeanAttributeNamesResponse.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "GaugeJsonService.MBeanAttributeNamesResponseBase"})
@Immutable
final class MBeanAttributeNamesResponse
    extends GaugeJsonService.MBeanAttributeNamesResponseBase {
  private final boolean mbeanUnavailable;
  private final boolean mbeanUnmatched;
  private final boolean duplicateMBean;
  private final ImmutableList<String> mbeanAttributes;

  private MBeanAttributeNamesResponse(MBeanAttributeNamesResponse.Builder builder) {
    this.mbeanAttributes = builder.mbeanAttributesBuilder.build();
    this.mbeanUnavailable = builder.mbeanUnavailableIsSet()
        ? builder.mbeanUnavailable
        : super.mbeanUnavailable();
    this.mbeanUnmatched = builder.mbeanUnmatchedIsSet()
        ? builder.mbeanUnmatched
        : super.mbeanUnmatched();
    this.duplicateMBean = builder.duplicateMBeanIsSet()
        ? builder.duplicateMBean
        : super.duplicateMBean();
  }

  private MBeanAttributeNamesResponse(
      boolean mbeanUnavailable,
      boolean mbeanUnmatched,
      boolean duplicateMBean,
      ImmutableList<String> mbeanAttributes) {
    this.mbeanUnavailable = mbeanUnavailable;
    this.mbeanUnmatched = mbeanUnmatched;
    this.duplicateMBean = duplicateMBean;
    this.mbeanAttributes = mbeanAttributes;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code mbeanUnavailable} attribute
   */
  @JsonProperty("mbeanUnavailable")
  @Override
  public boolean mbeanUnavailable() {
    return mbeanUnavailable;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code mbeanUnmatched} attribute
   */
  @JsonProperty("mbeanUnmatched")
  @Override
  public boolean mbeanUnmatched() {
    return mbeanUnmatched;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code duplicateMBean} attribute
   */
  @JsonProperty("duplicateMBean")
  @Override
  public boolean duplicateMBean() {
    return duplicateMBean;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code mbeanAttributes} attribute
   */
  @JsonProperty("mbeanAttributes")
  @Override
  public ImmutableList<String> mbeanAttributes() {
    return mbeanAttributes;
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeJsonService.MBeanAttributeNamesResponseBase#mbeanUnavailable() mbeanUnavailable}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for mbeanUnavailable
   * @return modified copy of the {@code this} object
   */
  public final MBeanAttributeNamesResponse withMbeanUnavailable(boolean value) {
    if (this.mbeanUnavailable == value) {
      return this;
    }
    boolean newValue = value;
    return new MBeanAttributeNamesResponse(newValue, this.mbeanUnmatched, this.duplicateMBean, this.mbeanAttributes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeJsonService.MBeanAttributeNamesResponseBase#mbeanUnmatched() mbeanUnmatched}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for mbeanUnmatched
   * @return modified copy of the {@code this} object
   */
  public final MBeanAttributeNamesResponse withMbeanUnmatched(boolean value) {
    if (this.mbeanUnmatched == value) {
      return this;
    }
    boolean newValue = value;
    return new MBeanAttributeNamesResponse(this.mbeanUnavailable, newValue, this.duplicateMBean, this.mbeanAttributes);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeJsonService.MBeanAttributeNamesResponseBase#duplicateMBean() duplicateMBean}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for duplicateMBean
   * @return modified copy of the {@code this} object
   */
  public final MBeanAttributeNamesResponse withDuplicateMBean(boolean value) {
    if (this.duplicateMBean == value) {
      return this;
    }
    boolean newValue = value;
    return new MBeanAttributeNamesResponse(this.mbeanUnavailable, this.mbeanUnmatched, newValue, this.mbeanAttributes);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link GaugeJsonService.MBeanAttributeNamesResponseBase#mbeanAttributes() mbeanAttributes}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final MBeanAttributeNamesResponse withMbeanAttributes(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new MBeanAttributeNamesResponse(this.mbeanUnavailable, this.mbeanUnmatched, this.duplicateMBean, newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link GaugeJsonService.MBeanAttributeNamesResponseBase#mbeanAttributes() mbeanAttributes}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of mbeanAttributes elements to set
   * @return modified copy of {@code this} object
   */
  public final MBeanAttributeNamesResponse withMbeanAttributes(Iterable<String> elements) {
    if (this.mbeanAttributes == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new MBeanAttributeNamesResponse(this.mbeanUnavailable, this.mbeanUnmatched, this.duplicateMBean, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code MBeanAttributeNamesResponse} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof MBeanAttributeNamesResponse && equalTo((MBeanAttributeNamesResponse) another));
  }
  
  private boolean equalTo(MBeanAttributeNamesResponse another) {
    return mbeanUnavailable == another.mbeanUnavailable
        && mbeanUnmatched == another.mbeanUnmatched
        && duplicateMBean == another.duplicateMBean
        && mbeanAttributes.equals(another.mbeanAttributes);
  }
  
  /**
   * Computes hash code from attributes: {@code mbeanUnavailable}, {@code mbeanUnmatched}, {@code duplicateMBean}, {@code mbeanAttributes}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Booleans.hashCode(mbeanUnavailable);
    h = h * 17 + Booleans.hashCode(mbeanUnmatched);
    h = h * 17 + Booleans.hashCode(duplicateMBean);
    h = h * 17 + mbeanAttributes.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code MBeanAttributeNamesResponse{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MBeanAttributeNamesResponse")
        .add("mbeanUnavailable", mbeanUnavailable)
        .add("mbeanUnmatched", mbeanUnmatched)
        .add("duplicateMBean", duplicateMBean)
        .add("mbeanAttributes", mbeanAttributes)
        .toString();
  }
  
  @JsonCreator
  public static MBeanAttributeNamesResponse fromAllAttributes(
      @JsonProperty("mbeanUnavailable") @Nullable Boolean mbeanUnavailable,
      @JsonProperty("mbeanUnmatched") @Nullable Boolean mbeanUnmatched,
      @JsonProperty("duplicateMBean") @Nullable Boolean duplicateMBean,
      @JsonProperty("mbeanAttributes") @Nullable ImmutableList<String> mbeanAttributes) {
    MBeanAttributeNamesResponse.Builder builder = MBeanAttributeNamesResponse.builder();
    if (mbeanUnavailable != null) {
      builder.mbeanUnavailable(mbeanUnavailable);
    }
    if (mbeanUnmatched != null) {
      builder.mbeanUnmatched(mbeanUnmatched);
    }
    if (duplicateMBean != null) {
      builder.duplicateMBean(duplicateMBean);
    }
    if (mbeanAttributes != null) {
      builder.addAllMbeanAttributes(mbeanAttributes);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link GaugeJsonService.MBeanAttributeNamesResponseBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable MBeanAttributeNamesResponse instance
   */
  static MBeanAttributeNamesResponse copyOf(GaugeJsonService.MBeanAttributeNamesResponseBase instance) {
    if (instance instanceof MBeanAttributeNamesResponse) {
      return (MBeanAttributeNamesResponse) instance;
    }
    return MBeanAttributeNamesResponse.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.MBeanAttributeNamesResponse}.
   * @return new MBeanAttributeNamesResponse builder
   */
  static MBeanAttributeNamesResponse.Builder builder() {
    return new MBeanAttributeNamesResponse.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.MBeanAttributeNamesResponse}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long NONDEFAULT_BIT_MBEAN_UNAVAILABLE = 0x1L;
    private static final long NONDEFAULT_BIT_MBEAN_UNMATCHED = 0x2L;
    private static final long NONDEFAULT_BIT_DUPLICATE_M_BEAN = 0x4L;
    private long nondefaultBitset;
  
    private boolean mbeanUnavailable;
    private boolean mbeanUnmatched;
    private boolean duplicateMBean;
    private ImmutableList.Builder<String> mbeanAttributesBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link GaugeJsonService.MBeanAttributeNamesResponseBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(GaugeJsonService.MBeanAttributeNamesResponseBase instance) {
      Preconditions.checkNotNull(instance);
      mbeanUnavailable(instance.mbeanUnavailable());
      mbeanUnmatched(instance.mbeanUnmatched());
      duplicateMBean(instance.duplicateMBean());
      addAllMbeanAttributes(instance.mbeanAttributes());
      return this;
    }
  
    /**
     * Initializes value for {@link GaugeJsonService.MBeanAttributeNamesResponseBase#mbeanUnavailable() mbeanUnavailable}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link GaugeJsonService.MBeanAttributeNamesResponseBase#mbeanUnavailable() mbeanUnavailable}.</em>
     * @param mbeanUnavailable value for mbeanUnavailable
     * @return {@code this} builder for chained invocation
     */
    public final Builder mbeanUnavailable(boolean mbeanUnavailable) {
      this.mbeanUnavailable = mbeanUnavailable;
      nondefaultBitset |= NONDEFAULT_BIT_MBEAN_UNAVAILABLE;
      return this;
    }
  
    /**
     * Initializes value for {@link GaugeJsonService.MBeanAttributeNamesResponseBase#mbeanUnmatched() mbeanUnmatched}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link GaugeJsonService.MBeanAttributeNamesResponseBase#mbeanUnmatched() mbeanUnmatched}.</em>
     * @param mbeanUnmatched value for mbeanUnmatched
     * @return {@code this} builder for chained invocation
     */
    public final Builder mbeanUnmatched(boolean mbeanUnmatched) {
      this.mbeanUnmatched = mbeanUnmatched;
      nondefaultBitset |= NONDEFAULT_BIT_MBEAN_UNMATCHED;
      return this;
    }
  
    /**
     * Initializes value for {@link GaugeJsonService.MBeanAttributeNamesResponseBase#duplicateMBean() duplicateMBean}.
     * <p><em>If not set, this attribute will have default value returned by initializer of {@link GaugeJsonService.MBeanAttributeNamesResponseBase#duplicateMBean() duplicateMBean}.</em>
     * @param duplicateMBean value for duplicateMBean
     * @return {@code this} builder for chained invocation
     */
    public final Builder duplicateMBean(boolean duplicateMBean) {
      this.duplicateMBean = duplicateMBean;
      nondefaultBitset |= NONDEFAULT_BIT_DUPLICATE_M_BEAN;
      return this;
    }
  
    /**
     * Adds one element to {@link GaugeJsonService.MBeanAttributeNamesResponseBase#mbeanAttributes() mbeanAttributes} list.
     * @param element mbeanAttributes element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMbeanAttributes(String element) {
      mbeanAttributesBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link GaugeJsonService.MBeanAttributeNamesResponseBase#mbeanAttributes() mbeanAttributes} list.
     * @param elements array of mbeanAttributes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addMbeanAttributes(String... elements) {
      mbeanAttributesBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link GaugeJsonService.MBeanAttributeNamesResponseBase#mbeanAttributes() mbeanAttributes} list.
     * @param elements iterable of mbeanAttributes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder mbeanAttributes(Iterable<String> elements) {
      mbeanAttributesBuilder = ImmutableList.builder();
      return addAllMbeanAttributes(elements);
    }
  
    /**
     * Adds elements to {@link GaugeJsonService.MBeanAttributeNamesResponseBase#mbeanAttributes() mbeanAttributes} list.
     * @param elements iterable of mbeanAttributes elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllMbeanAttributes(Iterable<String> elements) {
      mbeanAttributesBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.MBeanAttributeNamesResponse}.
     * @return immutable instance of MBeanAttributeNamesResponse
     */
    public org.glowroot.local.ui.MBeanAttributeNamesResponse build() {
      return new MBeanAttributeNamesResponse(this);
    }
  
    private boolean mbeanUnavailableIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_MBEAN_UNAVAILABLE) != 0;
    }
  
    private boolean mbeanUnmatchedIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_MBEAN_UNMATCHED) != 0;
    }
  
    private boolean duplicateMBeanIsSet() {
      return (nondefaultBitset & NONDEFAULT_BIT_DUPLICATE_M_BEAN) != 0;
    }
  }
}
