package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.Lists;
import java.util.Collection;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link GaugeJsonService.MBeanObjectNameRequestBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code MBeanObjectNameRequest.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "GaugeJsonService.MBeanObjectNameRequestBase"})
@Immutable
final class MBeanObjectNameRequest
    extends GaugeJsonService.MBeanObjectNameRequestBase {
  private final String partialMBeanObjectName;
  private final int limit;

  private MBeanObjectNameRequest(String partialMBeanObjectName, int limit) {
    this.partialMBeanObjectName = partialMBeanObjectName;
    this.limit = limit;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code partialMBeanObjectName} attribute
   */
  @JsonProperty("partialMBeanObjectName")
  @Override
  public String partialMBeanObjectName() {
    return partialMBeanObjectName;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code limit} attribute
   */
  @JsonProperty("limit")
  @Override
  public int limit() {
    return limit;
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeJsonService.MBeanObjectNameRequestBase#partialMBeanObjectName() partialMBeanObjectName}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for partialMBeanObjectName
   * @return modified copy of the {@code this} object
   */
  public final MBeanObjectNameRequest withPartialMBeanObjectName(String value) {
    if (this.partialMBeanObjectName == value) {
      return this;
    }
    String newValue = Preconditions.checkNotNull(value);
    return new MBeanObjectNameRequest(newValue, this.limit);
  }
  
  /**
   * Copy current immutable object by setting value for {@link GaugeJsonService.MBeanObjectNameRequestBase#limit() limit}.
   * Value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value new value for limit
   * @return modified copy of the {@code this} object
   */
  public final MBeanObjectNameRequest withLimit(int value) {
    if (this.limit == value) {
      return this;
    }
    int newValue = value;
    return new MBeanObjectNameRequest(this.partialMBeanObjectName, newValue);
  }
  
  /**
   * This instance is equal to instances of {@code MBeanObjectNameRequest} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof MBeanObjectNameRequest && equalTo((MBeanObjectNameRequest) another));
  }
  
  private boolean equalTo(MBeanObjectNameRequest another) {
    return partialMBeanObjectName.equals(another.partialMBeanObjectName)
        && limit == another.limit;
  }
  
  /**
   * Computes hash code from attributes: {@code partialMBeanObjectName}, {@code limit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + partialMBeanObjectName.hashCode();
    h = h * 17 + limit;
    return h;
  }
  
  /**
   * Prints immutable value {@code MBeanObjectNameRequest{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MBeanObjectNameRequest")
        .add("partialMBeanObjectName", partialMBeanObjectName)
        .add("limit", limit)
        .toString();
  }
  
  @JsonCreator
  public static MBeanObjectNameRequest fromAllAttributes(
      @JsonProperty("partialMBeanObjectName") @Nullable String partialMBeanObjectName,
      @JsonProperty("limit") @Nullable Integer limit) {
    MBeanObjectNameRequest.Builder builder = MBeanObjectNameRequest.builder();
    if (partialMBeanObjectName != null) {
      builder.partialMBeanObjectName(partialMBeanObjectName);
    }
    if (limit != null) {
      builder.limit(limit);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link GaugeJsonService.MBeanObjectNameRequestBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable MBeanObjectNameRequest instance
   */
  static MBeanObjectNameRequest copyOf(GaugeJsonService.MBeanObjectNameRequestBase instance) {
    if (instance instanceof MBeanObjectNameRequest) {
      return (MBeanObjectNameRequest) instance;
    }
    return MBeanObjectNameRequest.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.MBeanObjectNameRequest}.
   * @return new MBeanObjectNameRequest builder
   */
  static MBeanObjectNameRequest.Builder builder() {
    return new MBeanObjectNameRequest.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.MBeanObjectNameRequest}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
    private static final long INITIALIZED_BITSET_ALL = 0x3;
    private static final long INITIALIZED_BIT_PARTIAL_M_BEAN_OBJECT_NAME = 0x1L;
    private static final long INITIALIZED_BIT_LIMIT = 0x2L;
    private long initializedBitset;
  
    private @Nullable String partialMBeanObjectName;
    private int limit;
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link GaugeJsonService.MBeanObjectNameRequestBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(GaugeJsonService.MBeanObjectNameRequestBase instance) {
      Preconditions.checkNotNull(instance);
      partialMBeanObjectName(instance.partialMBeanObjectName());
      limit(instance.limit());
      return this;
    }
  
    /**
     * Initializes value for {@link GaugeJsonService.MBeanObjectNameRequestBase#partialMBeanObjectName() partialMBeanObjectName}.
     * @param partialMBeanObjectName value for partialMBeanObjectName
     * @return {@code this} builder for chained invocation
     */
    public final Builder partialMBeanObjectName(String partialMBeanObjectName) {
      this.partialMBeanObjectName = Preconditions.checkNotNull(partialMBeanObjectName);
      initializedBitset |= INITIALIZED_BIT_PARTIAL_M_BEAN_OBJECT_NAME;
      return this;
    }
  
    /**
     * Initializes value for {@link GaugeJsonService.MBeanObjectNameRequestBase#limit() limit}.
     * @param limit value for limit
     * @return {@code this} builder for chained invocation
     */
    public final Builder limit(int limit) {
      this.limit = limit;
      initializedBitset |= INITIALIZED_BIT_LIMIT;
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.MBeanObjectNameRequest}.
     * @return immutable instance of MBeanObjectNameRequest
     */
    public org.glowroot.local.ui.MBeanObjectNameRequest build() {
      checkRequiredAttributes();
      return new MBeanObjectNameRequest(partialMBeanObjectName, limit);
    }
  
    private boolean partialMBeanObjectNameIsSet() {
      return (initializedBitset & INITIALIZED_BIT_PARTIAL_M_BEAN_OBJECT_NAME) != 0;
    }
  
    private boolean limitIsSet() {
      return (initializedBitset & INITIALIZED_BIT_LIMIT) != 0;
    }
  
    private void checkRequiredAttributes() {
      if (initializedBitset != INITIALIZED_BITSET_ALL) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }
  
    private String formatRequiredAttributesMessage() {
      Collection<String> attributes = Lists.newArrayList();
      if (!partialMBeanObjectNameIsSet()) {
        attributes.add("partialMBeanObjectName");
      }
      if (!limitIsSet()) {
        attributes.add("limit");
      }
      return "Cannot build MBeanObjectNameRequest, some of required attributes are not set " + attributes;
    }
  }
}
