package org.glowroot.local.ui;

import org.glowroot.shaded.fasterxml.jackson.annotation.JsonCreator;
import org.glowroot.shaded.fasterxml.jackson.annotation.JsonProperty;
import org.glowroot.shaded.google.common.base.MoreObjects;
import org.glowroot.shaded.google.common.base.Preconditions;
import org.glowroot.shaded.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link JvmJsonService.MBeanTreeRequestBase}.
 * <p>
 * Use builder to create immutable instances:
 * {@code MBeanTreeRequest.builder()}.
 */
@SuppressWarnings("all")
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "JvmJsonService.MBeanTreeRequestBase"})
@Immutable
final class MBeanTreeRequest extends JvmJsonService.MBeanTreeRequestBase {
  private final ImmutableList<String> expanded;

  private MBeanTreeRequest(ImmutableList<String> expanded) {
    this.expanded = expanded;
  }
  
  /**
   * {@inheritDoc}
   * @return value of {@code expanded} attribute
   */
  @JsonProperty("expanded")
  @Override
  public ImmutableList<String> expanded() {
    return expanded;
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link JvmJsonService.MBeanTreeRequestBase#expanded() expanded}.
   * @param elements elements to set
   * @return modified copy of {@code this} object
   */
  public final MBeanTreeRequest withExpanded(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new MBeanTreeRequest(newValue);
  }
  
  /**
   * Copy current immutable object with elements that replace content of {@link JvmJsonService.MBeanTreeRequestBase#expanded() expanded}.
   * Shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements iterable of expanded elements to set
   * @return modified copy of {@code this} object
   */
  public final MBeanTreeRequest withExpanded(Iterable<String> elements) {
    if (this.expanded == elements) {
      return this;
    }
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new MBeanTreeRequest(newValue);
  }
  
  /**
   * This instance is equal to instances of {@code MBeanTreeRequest} with equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    return this == another
        || (another instanceof MBeanTreeRequest && equalTo((MBeanTreeRequest) another));
  }
  
  private boolean equalTo(MBeanTreeRequest another) {
    return expanded.equals(another.expanded);
  }
  
  /**
   * Computes hash code from attributes: {@code expanded}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + expanded.hashCode();
    return h;
  }
  
  /**
   * Prints immutable value {@code MBeanTreeRequest{...}} with attribute values,
   * excluding any non-generated and auxiliary attributes.
   * @return string representation of value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MBeanTreeRequest")
        .add("expanded", expanded)
        .toString();
  }
  
  @JsonCreator
  public static MBeanTreeRequest fromAllAttributes(
      @JsonProperty("expanded") @Nullable List<String> expanded) {
    MBeanTreeRequest.Builder builder = MBeanTreeRequest.builder();
    if (expanded != null) {
      builder.addAllExpanded(expanded);
    }
    return builder.build();
  }
  
  /**
   * Creates immutable copy of {@link JvmJsonService.MBeanTreeRequestBase}.
   * Uses accessors to get values to initialize immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance instance to copy
   * @return copied immutable MBeanTreeRequest instance
   */
  static MBeanTreeRequest copyOf(JvmJsonService.MBeanTreeRequestBase instance) {
    if (instance instanceof MBeanTreeRequest) {
      return (MBeanTreeRequest) instance;
    }
    return MBeanTreeRequest.builder()
        .all(instance)
        .build();
  }

  /**
   * Creates builder for {@link org.glowroot.local.ui.MBeanTreeRequest}.
   * @return new MBeanTreeRequest builder
   */
  static MBeanTreeRequest.Builder builder() {
    return new MBeanTreeRequest.Builder();
  }
  
  /**
   * Builds instances of {@link org.glowroot.local.ui.MBeanTreeRequest}.
   * Initialized attributes and then invoke {@link #build()} method to create
   * immutable instance.
   * <p><em>Builder is not thread safe and generally should not be stored in field or collection,
   * but used immediately to create instances.</em>
   */
  @NotThreadSafe
  static final class Builder {
  
    private ImmutableList.Builder<String> expandedBuilder = ImmutableList.builder();
    private Builder() {}
  
    /**
     * Fill builder with attribute values from provided {@link JvmJsonService.MBeanTreeRequestBase} instance.
     * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
     * Instance's absent optional values will not be copied (will not override current).
     * Collection elements and entries will be added, not replaced.
     * @param instance instance to copy values from
     * @return {@code this} builder for chained invocation
     */
    public final Builder all(JvmJsonService.MBeanTreeRequestBase instance) {
      Preconditions.checkNotNull(instance);
      addAllExpanded(instance.expanded());
      return this;
    }
  
    /**
     * Adds one element to {@link JvmJsonService.MBeanTreeRequestBase#expanded() expanded} list.
     * @param element expanded element
     * @return {@code this} builder for chained invocation
     */
    public final Builder addExpanded(String element) {
      expandedBuilder.add(element);
      return this;
    }
  
    /**
     * Adds elements to {@link JvmJsonService.MBeanTreeRequestBase#expanded() expanded} list.
     * @param elements array of expanded elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addExpanded(String... elements) {
      expandedBuilder.add(elements);
      return this;
    }
  
    /**
     * Sets or replaces all elements for {@link JvmJsonService.MBeanTreeRequestBase#expanded() expanded} list.
     * @param elements iterable of expanded elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder expanded(Iterable<String> elements) {
      expandedBuilder = ImmutableList.builder();
      return addAllExpanded(elements);
    }
  
    /**
     * Adds elements to {@link JvmJsonService.MBeanTreeRequestBase#expanded() expanded} list.
     * @param elements iterable of expanded elements
     * @return {@code this} builder for chained invocation
     */
    public final Builder addAllExpanded(Iterable<String> elements) {
      expandedBuilder.addAll(elements);
      return this;
    }
  
    /**
     * Builds new {@link org.glowroot.local.ui.MBeanTreeRequest}.
     * @return immutable instance of MBeanTreeRequest
     */
    public org.glowroot.local.ui.MBeanTreeRequest build() {
      return new MBeanTreeRequest(expandedBuilder.build());
    }
  }
}
